<?php
session_start();
$_SESSION['user_id'] = 1;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>My Wallet</title>
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>
  <header class="app-header">
    <div class="left">My Wallet</div>
    <div class="right">
      <select id="currency-select"></select>
    </div>
  </header>

  <main class="app-main">
    <section class="balance-summary">
      <div class="total-label">Total Balance</div>
      <div id="total-amount">—</div>
      <div id="total-fiat">—</div>
    </section>

    <section class="wallet-list" id="wallet-list"></section>
  </main>

  <button id="open-swap" class="swap-button">Swap</button>

  <div id="swap-modal" class="modal hidden">
    <div class="modal-inner">
      <h3>Swap</h3>
      <label>From</label>
      <select id="swap-from"></select>
      <label>To</label>
      <select id="swap-to"></select>
      <label>Amount</label>
      <input id="swap-amount" type="number" min="0" step="any" />
      <div class="modal-actions">
        <button id="do-swap">Confirm</button>
        <button id="close-swap">Close</button>
      </div>
      <div id="swap-result" class="result"></div>
    </div>
  </div>

  <script src="assets/app.js"></script>
</body>
</html>
