CREATE DATABASE IF NOT EXISTS wallet_db;
USE wallet_db;
CREATE TABLE users (id INT AUTO_INCREMENT PRIMARY KEY,email VARCHAR(255) NOT NULL UNIQUE,display_name VARCHAR(100),created_at DATETIME DEFAULT CURRENT_TIMESTAMP);
CREATE TABLE wallets (id INT AUTO_INCREMENT PRIMARY KEY,symbol VARCHAR(20) NOT NULL,name VARCHAR(100) NOT NULL);
CREATE TABLE balances (id INT AUTO_INCREMENT PRIMARY KEY,user_id INT NOT NULL,wallet_id INT NOT NULL,balance DECIMAL(36,18) DEFAULT 0,FOREIGN KEY(user_id) REFERENCES users(id) ON DELETE CASCADE,FOREIGN KEY(wallet_id) REFERENCES wallets(id) ON DELETE CASCADE);
CREATE TABLE transactions (id BIGINT AUTO_INCREMENT PRIMARY KEY,user_id INT NOT NULL,wallet_from INT,wallet_to INT,amount_from DECIMAL(36,18),amount_to DECIMAL(36,18),rate DECIMAL(36,18),created_at DATETIME DEFAULT CURRENT_TIMESTAMP,FOREIGN KEY(user_id) REFERENCES users(id));
INSERT INTO users (email,display_name) VALUES ('demo@example.com','Demo User');
INSERT INTO wallets (symbol,name) VALUES ('BTC','Bitcoin'),('ETH','Ethereum'),('USDT','Tether'),('BNB','Binance Coin');
INSERT INTO balances (user_id,wallet_id,balance) VALUES (1,1,0.01234567),(1,2,0.45),(1,3,120.5),(1,4,2.1);
