<?php
require_once 'config.php';header('Content-Type: application/json');
$input=json_decode(file_get_contents('php://input'),true);
$user_id=intval($input['user_id']??0);$from=$input['from'];$to=$input['to'];$amount=floatval($input['amount']);
if($amount<=0||!$from||!$to){http_response_code(400);echo json_encode(['error'=>'invalid']);exit;}
$pdo=get_db();
try{$pdo->beginTransaction();$stmt=$pdo->prepare('SELECT id FROM wallets WHERE symbol IN (?,?)');$stmt->execute([$from,$to]);$ids=$stmt->fetchAll(PDO::FETCH_COLUMN);if(count($ids)<2)throw new Exception('wallet not found');
$stmt=$pdo->prepare('SELECT balance FROM balances WHERE user_id=? AND wallet_id=? FOR UPDATE');$stmt->execute([$user_id,$ids[0]]);$fromBal=floatval($stmt->fetchColumn());$stmt->execute([$user_id,$ids[1]]);$toBal=floatval($stmt->fetchColumn());
if($fromBal<$amount)throw new Exception('insufficient funds');$rate=1.0;$toAmount=$amount*$rate;
$stmt=$pdo->prepare('UPDATE balances SET balance=balance-? WHERE user_id=? AND wallet_id=?');$stmt->execute([$amount,$user_id,$ids[0]]);
$stmt=$pdo->prepare('UPDATE balances SET balance=balance+? WHERE user_id=? AND wallet_id=?');$stmt->execute([$toAmount,$user_id,$ids[1]]);
$stmt=$pdo->prepare('INSERT INTO transactions (user_id,wallet_from,wallet_to,amount_from,amount_to,rate,created_at) VALUES (?,?,?,?,?,?,NOW())');$stmt->execute([$user_id,$ids[0],$ids[1],$amount,$toAmount,$rate]);
$pdo->commit();echo json_encode(['success'=>true,'message'=>'Swap completed']);}
catch(Exception $e){$pdo->rollBack();http_response_code(400);echo json_encode(['error'=>true,'message'=>$e->getMessage()]);}
