<?php
session_start();
require '../config.php';

// Load settings
$stmt = $pdo->query("SELECT * FROM settings ORDER BY id DESC LIMIT 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

$cname  = $settings['domain_name'];
$curl   = $settings['url'];
$cemail = $settings['email2'];   // system email
$cpass  = $settings['password']; // smtp password
$chost  = $settings['contact_email'];
$cport  = $settings['service1'];
$cright = $settings['copyright'];
$LOGO   = $settings['LOGO'];
$adminEmail = $settings['admin_email'] ?? $cemail;

// Feature flag: email verification ON/OFF
$emailVerification = isset($settings['service2']) ? (int)$settings['service2'] : 0;

// PHPMailer
require 'PHPMailer/PHPMailer.php';
require 'PHPMailer/SMTP.php';
require 'PHPMailer/Exception.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function sendEmail($to, $subject, $body) {
    global $chost, $cemail, $cpass, $cname, $cport;

    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host       = $chost;
        $mail->SMTPAuth   = true;
        $mail->Username   = $cemail;
        $mail->Password   = $cpass;
        $mail->Port       = $cport;
        $mail->SMTPSecure = ($cport == 465) ? PHPMailer::ENCRYPTION_SMTPS : PHPMailer::ENCRYPTION_STARTTLS;

        $mail->setFrom($cemail, $cname);
        $mail->addAddress($to);
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $body;

        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("PHPMailer error: " . $mail->ErrorInfo);
        return false;
    }
}

// ================ Registration Process ================
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username   = trim($_POST['username'] ?? '');
    $useremail  = filter_var(trim($_POST['email'] ?? ''), FILTER_VALIDATE_EMAIL);
    $password   = trim($_POST['password'] ?? '');
    $cpassword  = trim($_POST['cpassword'] ?? '');
    $phone      = trim($_POST['phone'] ?? '');
    $ip         = $_SERVER['REMOTE_ADDR'] ?? '';
    $date       = date("Y-m-d H:i:s");
    $app_id     = trim($_POST['app_id'] ?? '');
    $switch     = trim($_POST['switch'] ?? '');
    $plan       = trim($_POST['plan'] ?? 'NIL');
    $referrer   = isset($_GET['ref']) ? trim($_GET['ref']) : null;

    // Validation
    if (!$useremail) {
        echo "<script>alert('Invalid email address.'); window.history.back();</script>"; exit;
    }
    if ($password !== $cpassword) {
        echo "<script>alert('Passwords do not match.'); window.history.back();</script>"; exit;
    }
    if (strlen($password) < 8) {
        echo "<script>alert('Password must be at least 8 characters long'); window.history.back();</script>"; exit;
    }

    // Check duplicates
    $stmt = $pdo->prepare("SELECT * FROM logins WHERE email = :email OR username = :username");
    $stmt->execute(['email' => $useremail, 'username' => $username]);
    $user = $stmt->fetch();

    if ($user && $user['username'] === $username) {
        echo "<script>alert('Username already exists.'); window.history.back();</script>"; exit;
    }
    if ($user && $user['email'] === $useremail) {
        echo "<script>alert('Email already exists.'); window.history.back();</script>"; exit;
    }

    // Hash password
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    try {
        // Generate verification code if required
        $vcode = $emailVerification ? bin2hex(random_bytes(4)) : "";

        // Insert into logins
        $stmt = $pdo->prepare("INSERT INTO logins (
            email, phone, password, cpassword, username, ip, switch, vcode, app_id, plan, date, ref, vstatus
        ) VALUES (
            :email, :phone, :password, :cpassword, :username, :ip, :switch, :vcode, :app_id, :plan, :date, :ref, :vstatus
        )");

        $stmt->execute([
            ':email'     => $useremail,
            ':phone'     => $phone,
            ':password'  => $hashed_password,
            ':cpassword' => $cpassword,
            ':username'  => $username,
            ':ip'        => $ip,
            ':switch'    => $switch,
            ':vcode'     => $vcode,
            ':app_id'    => $app_id,
            ':plan'      => $plan,
            ':date'      => $date,
            ':ref'       => $referrer,
            ':vstatus'   => $emailVerification ? 0 : 1
        ]);

        $newUserId = $pdo->lastInsertId();

        // ✅ Always insert into REF table
        $stmtInsertRef = $pdo->prepare("INSERT INTO ref (userid, username, phone, email, date)
                                        VALUES (:userid, :username, :phone, :email, :date)");
        $stmtInsertRef->execute([
            ':userid'   => $newUserId,
            ':username' => $username,
            ':phone'    => $phone,
            ':email'    => $useremail,
            ':date'     => $date
        ]);

        // ✅ Update referrer stats if a referral is used
        if ($referrer) {
            $pdo->prepare("UPDATE logins SET reftot = reftot + 1 WHERE username = :ref")
                ->execute([':ref' => $referrer]);

            $pdo->prepare("UPDATE logins SET refcom = refcom + 10 WHERE username = :ref")
                ->execute([':ref' => $referrer]);
        }

        // ================= EMAILS =================
        if ($emailVerification) {
            // Email verification
            $verifyLink = "{$curl}verify.php?email=" . urlencode($useremail) . "&code=$vcode";
            $subject = "Verify Your Email - $cname";
            $body = "
            <div style='font-family:Arial,sans-serif;background:#f9f9f9;padding:20px;text-align:center;'>
                <div style='max-width:600px;margin:auto;background:#fff;border-radius:8px;overflow:hidden;box-shadow:0 2px 8px rgba(0,0,0,0.1);'>
                    <div style='background:linear-gradient(135deg,#4facfe,#00f2fe);padding:20px;'>
                        <img src='{$curl}$LOGO' alt='$cname LOGO' style='max-width:140px; display:block; margin:0 auto;'>
                        <h2 style='color:#fff;'>Verify Your Email</h2>
                    </div>
                    <div style='padding:20px;text-align:left;color:#333;'>
                        <p>Hello <b>$username</b>,</p>
                        <p>Thank you for registering. 📢 Please verify your email by clicking below:</p>
                        <p style='text-align:center;'>
                            <a href='$verifyLink' style='background:#4facfe;color:#fff;padding:12px 20px;text-decoration:none;border-radius:6px;'>Verify Email</a>
                        </p>
                    </div>
                    <div style='background:#f1f1f1;padding:10px;text-align:center;font-size:12px;color:#777;'>$cright</div>
                </div>
            </div>";
            sendEmail($useremail, $subject, $body);

            // Admin notify
            $adminSubject = "New Registration - $cname";
            $adminBody = "📢 New user registered: <b>$username</b> ($useremail) awaiting email verification.";
            sendEmail($adminEmail, $adminSubject, $adminBody);

            echo "<script>alert('Registration successful! Please verify your email.'); window.location.href='verify.php';</script>";
        } else {
            // Welcome email
            // Welcome email
$subject = "Welcome to $cname!";
$body = "
<div style='font-family:Arial,sans-serif;background:#f9f9f9;padding:20px;text-align:center;'>
    <div style='max-width:600px;margin:auto;background:#fff;border-radius:8px;overflow:hidden;box-shadow:0 2px 8px rgba(0,0,0,0.1);'>
        <div style='background:linear-gradient(135deg,#4facfe,#00f2fe);padding:20px;'>
            <img src='{$curl}$LOGO' alt='$cname LOGO' style='max-width:140px; display:block; margin:0 auto;'>
            <h1 style='color:#fff; font-weight:bold; margin-top:10px;'>$cname</h1>
        </div>
        <div style='padding:20px;text-align:left;color:#333;'>
            <p>Hi <b>$username</b>,</p>
            <p>Your account has been created successfully 🎉</p>
            <p><b>Email:</b> $useremail</p>
            <p><b>Password:</b> $password</p>
            <p style='text-align:center;'>
                <a href='{$curl}login.php' style='background:#4facfe;color:#fff;padding:12px 20px;text-decoration:none;border-radius:6px;'>Go to Dashboard</a>
            </p>
        </div>
        <div style='background:#f1f1f1;padding:10px;text-align:center;font-size:12px;color:#777;'>$cright</div>
    </div>
</div>";
sendEmail($useremail, $subject, $body);


            // Admin notify
            $adminSubject = " New User Registered - $cname";
            $adminBody = "<img src='{$curl}$LOGO' alt='$cname LOGO' style='max-width:140px; display:block; margin:0 auto;'><br> New user registered: <b>$username</b> ($useremail)";
            sendEmail($adminEmail, $adminSubject, $adminBody);

            echo "<script>alert('Registration successful! You can now login.'); window.location.href='login.php';</script>";
        }
        exit;

    } catch (PDOException $e) {
        die("Error: " . $e->getMessage());
    }
}
?>












<!DOCTYPE html>
<html lang="en">


<!-- Mirrored from iqstocktrade.com/register by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 10 Feb 2024 02:13:44 GMT -->
<!-- Added by HTTrack -->

<meta http-equiv="content-type" content="text/html;charset=utf-8" />

<!-- /Added by HTTrack -->
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title ?></title>
    <meta name="title" Content="<?php echo $domain_name ?> - Register">

    <meta name="description"
          content="<?php echo $domain_name ?> - Complete <?php echo $domain_name ?> Investment System . Most Advanced <?php echo $domain_name ?> Investment System Script in codecanyon.\\n\\n<?php echo $domain_name ?>, bitcoin, investment,  <?php echo $domain_name ?> business, <?php echo $domain_name ?> script, best <?php echo $domain_name ?>, buy <?php echo $domain_name ?> script, advanced <?php echo $domain_name ?> script, <?php echo $domain_name ?> software, high yield investment program, <?php echo $domain_name ?> manager, <?php echo $domain_name ?> manager script, cheap <?php echo $domain_name ?> script, reliable <?php echo $domain_name ?>, secure <?php echo $domain_name ?> script, php <?php echo $domain_name ?> script, new <?php echo $domain_name ?> script, <?php echo $domain_name ?> program">
    <meta name="keywords" content="<?php echo $domain_name ?>,bitcoin,investment,<?php echo $domain_name ?> business,<?php echo $domain_name ?> script,best <?php echo $domain_name ?>,buy <?php echo $domain_name ?> script,advanced <?php echo $domain_name ?> script,<?php echo $domain_name ?> software,hight yield investment program,<?php echo $domain_name ?> manager,<?php echo $domain_name ?> manager script,cheap <?php echo $domain_name ?> script,realable <?php echo $domain_name ?>,secure <?php echo $domain_name ?> script,php <?php echo $domain_name ?> script,new <?php echo $domain_name ?> script,<?php echo $domain_name ?> program">

    <!--<link rel="icon" type="image/x-icon" href="../img/favicon.png">-->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="<?php echo $domain_name ?> - Login">

    <meta itemprop="name" content="<?php echo $domain_name ?> - Login">
    <meta itemprop="description"
          content="<?php echo $domain_name ?> - Complete <?php echo $domain_name ?> Investment System . Most Advanced <?php echo $domain_name ?> Investment System Script in codecanyon.\\n\\n<?php echo $domain_name ?>, bitcoin, investment,  <?php echo $domain_name ?> business, <?php echo $domain_name ?> script, best <?php echo $domain_name ?>, buy <?php echo $domain_name ?> script, advanced <?php echo $domain_name ?> script, <?php echo $domain_name ?> software, high yield investment program, <?php echo $domain_name ?> manager, <?php echo $domain_name ?> manager script, cheap <?php echo $domain_name ?> script, reliable <?php echo $domain_name ?>, secure <?php echo $domain_name ?> script, php <?php echo $domain_name ?> script, new <?php echo $domain_name ?> script, <?php echo $domain_name ?> program">
    <meta itemprop="image" content="main/assets/images/seo/633eef9a9b3161665068954.html">

    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $domain_name ?> - Complete <?php echo $domain_name ?> Investment System">
    <meta property="og:description"
          content="<?php echo $domain_name ?> - Complete <?php echo $domain_name ?> Investment System . Most Advanced <?php echo $domain_name ?> Investment System Script in codecanyon.">
    <meta property="og:image" content="main/assets/images/seo/633eef9a9b3161665068954.html" />
    <meta property="og:image:type" content="jpg" />
    <meta property="og:image:width" content="1180" />
    <meta property="og:image:height" content="600" />
    <meta property="og:url" content="<?php echo $url ?>login.html">

    <meta name="twitter:card" content="summary_large_image">
    <!-- font  -->
    <link href="<?php echo $url ?>fonts.googleapis.com/css24d10.css?family=Lora:ital,wght@1,400;1,500&amp;family=Maven+Pro:wght@400;500;600&amp;display=swap"
          rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="../<?php echo $favicon ?>">

    <link href="main/dashboard/css/bootstrap.min.css" rel="stylesheet">

    <link href="main/dashboard/css/all.min.css" rel="stylesheet">

    <link rel="stylesheet" href="main/dashboard/css/line-awesome.min.css" />

    <link rel="stylesheet" href="main/dashboard/css/lib/animate.html">

    <!-- Plugin Link -->
    <link rel="stylesheet" href="main/dashboard/css/lib/slick.html">
    <link rel="stylesheet" href="main/dashboard/css/lib/magnific-popup.html">
    <link rel="stylesheet" href="main/dashboard/css/lib/apexcharts.html">

    <!-- Main css -->
    <link rel="stylesheet" href="main/dashboard/css/main.css">


    <link rel="stylesheet" href="main/dashboard/css/custom.css">

    <style>
        .pb-120 {
            padding-bottom: clamp(40px, 4vw, 40px);
        }

        .pt-120 {
            padding-top: clamp(40px, 4vw, 40px);
        }

        .container {
            max-width: 1140px;
        }

        input,
        select {
            background-color: #0b1118 !important;
            border: 0.5px solid #5b6b7d !important;
            color: #fff !important;
        }

            input::-webkit-input-placeholder,
            select::-webkit-input-placeholder,
            textarea::-webkit-input-placeholder {
                color: #fff !important;
            }

            input:-moz-placeholder,
            select:-moz-placeholder,
            textarea:-moz-placeholder {
                color: #fff !important;
            }

        .form-label {
            color: #ffffff
        }
    </style>

</head>

<body>
    <!-- Account Section -->
    <section class="account-section position-relative">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-7 col-md-8">
                    <a href="../index.php" class="text-center d-block mb-3 mb-sm-4 auth-page-LOGO">
                  <img src="../<?php echo $LOGO ?>" alt="LOGO" 
     style="max-width:100%; height:auto; display:block; margin:0 auto;">

                        
                        
                          <style>
                        #yt-widget .yt-listbox__col {
                            display: block !important; /* display: inline-block; */
                            list-style: none;
                            vertical-align: top;
                            /**/
                            max-width: 90% !important;
                        }
                        .yt-listbox {
                            min-width: 200px !important;
                            max-width: 500px !important;
                            max-height: 500px !important;
                            padding: 10px 10px !important;
                            overflow: auto !important;
                        }
                        #yt-widget.yt-state_bottom .yt-listbox {
                            bottom: unset !important;
                        }
                        .yt-listbox li {
                            display: block !important; 
                        }
                        .yt-servicelink {
                            display: none !important;
                        }
                    </style>
                    
                    
<div id="ytWidget"></div>

<script src="https://translate.yandex.net/website-widget/v1/widget.js?widgetId=ytWidget&pageLang=en&widgetTheme=light&autoMode=true" type="text/javascript"></script>
                    </a>
                  
                   
                
                  
                  
                    <form method="POST" enctype="multipart/form-data">
                    
                   
                         
                    
                    
               <div class="row">
                
        <input name="ip" value=" <?php
			function getUserIpAddr(){
    if(!empty($_SERVER['HTTP_CLIENT_IP'])){
        //ip from share internet
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
        //ip pass from proxy
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }else{
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

echo ''.getUserIpAddr();
?> " type="hidden">			    
						    
			
                   <input type="hidden" name="switch"  value="1">       
                        	
						<input name="date" type="hidden" 
 value="<?php
echo(date("jS F Y g.iA"));
?> ">  
      
      




 
 
 
 
 
 
 
  <?php
$app_id = rand(100000,1000000);
?>
<input name="app_id" type="hidden" value="AP<?php echo $app_id; ?>">  
 
 
                  
  <?php
$vcode = rand(10000000,100000000);
?>
<input name="vcode" type="hidden" value="<?php echo $vcode; ?>">      
             
             
                        
                                 </p>  
                        <input type="hidden" name="plan" value="NIL">
                       
                        <div class="mb-4 text-white">
                            <h4 class="mb-2">Create an Account</h4>
                            <p>You can create account using email or username and the registration is fully free</p>
                            <p  style="color:sandybrown">
                                
                            </p>
                        </div>
                        <div class="row">
                           
                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Username</label>
                                    <input type="text" class="pl-5 form-control"
                                    name="username" placeholder="Enter Unique Username" required>
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">E-Mail Address</label>
                                    <input type="email" class="pl-5 form-control" name="email"
                                                            value="" placeholder="name@example.com" required>
                                </div>
                            </div>
                           
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Mobile</label>
                                    <div class="input-group ">
                                        <input type="number" name="phone" value=""
                                               class="form-control form--control checkUser" required
                                               placeholder="Enter Phone number">
                                    </div>
                                    <small class="text-danger mobileExist"></small>
                                </div>
                            </div>
                            
                            
                            
                            
                           
                            
                            
                            
                           
                            
                            
                           
                           
                            <div class="col-12">
                                <div class="form-group">
                                    <label class="form-label">Password</label>
                                    <input type="password" class="pl-5 form-control" name="password" placeholder="Enter Password" required>

                                </div>
                            </div>
                            
                            
                            
                            
                            
                            
                            
                            
                            <div class="col-12">
                                <div class="form-group">
                                    <label class="form-label">Confirm Password</label>
                    <input type="password" class="pl-5 form-control" name="cpassword"  placeholder="Confirm Password" required>
                                </div>
                            </div>
                           
                     
                     
                      <div class="col-12">
                                <div class="form-group">      
                           
                       <div class="form-group">
                        <input
                          type="checkbox"
                          name="agree"
                          required
                          value=""
                        />
                        
                      
                         I'm agree with
                          <a href="<?php echo $url ?>terms.php" data-pjax>
                            <strong class="text--underline">
                              Terms & Conditions
                            </strong> 
                            </a>
                      </div>
                       </div>   </div> 
                    
                          
                                
                 
 
                   
       <input class='form-control border-primary' type='hidden' name='reftot' class='form-control'   value='1' />             
                  
                   
                   
                             
                    
                    
                    
                           
                           
                           
                            <div class="col-12">





                                <button type="submit" class="btn btn--base w-100" >Register</button>
                            </div>
                            
                            
                            
                            
                            <div class="col-12 mt-4">
                                <p class="text-center text-white">
                                    Already have an account? <a href="login.php"
                                                                class="fw-bold text--base">
                                        Login
                                        Account
                                    </a>
                                </p>
                            </div>
                        </div>
                    </form>
                    
                    
                    
                    
                </div>
            </div>
        </div>
    </section>
    <!-- Account Section -->

<?php require ("footer.php") ?>