<?php
require_once 'config.php';
header('Content-Type: application/json');
$input = json_decode(file_get_contents('php://input'), true);
$username = trim($input['username'] ?? '');
$email = trim($input['email'] ?? '');
$password = $input['password'] ?? '';
if (!$username || !$email || !$password) {
    http_response_code(400);
    echo json_encode(['error'=>'Missing fields']); exit;
}
try {
    $pdo = get_db();
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO users (username,email,password_hash) VALUES (?,?,?)");
    $stmt->execute([$username,$email,$hash]);
    echo json_encode(['success'=>true,'message'=>'Registered successfully. Await admin approval.']);
} catch (PDOException $e) {
    if (str_contains($e->getMessage(),'Duplicate')) {
        echo json_encode(['error'=>'Username or email already exists']);
    } else {
        http_response_code(500);
        echo json_encode(['error'=>'Server error']);
    }
}