<?php
require_once 'config.php';
header('Content-Type: application/json');
$input = json_decode(file_get_contents('php://input'), true);
$username = trim($input['username'] ?? '');
$password = $input['password'] ?? '';
$pdo = get_db();
$stmt = $pdo->prepare("SELECT * FROM users WHERE username=?");
$stmt->execute([$username]);
$user = $stmt->fetch();
if (!$user || !password_verify($password,$user['password_hash'])) {
    http_response_code(401);
    echo json_encode(['error'=>'Invalid username or password']); exit;
}
if ($user['status']!=='approved') {
    echo json_encode(['error'=>'Your account is pending admin approval.']); exit;
}
$_SESSION['user_id'] = $user['id'];
echo json_encode(['success'=>true,'message'=>'Login successful']);