<?php
require_once("header.php");

$log_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

/* ─────────────────────────────────────────────
   HANDLE DELETION (runs before any HTML output)
   ───────────────────────────────────────────── */
if (isset($_GET['del'])) {
    $del_id = intval($_GET['del']);              // basic validation

    try {
        $stmt = $pdo->prepare("DELETE FROM withdraw WHERE id = ?");
        $stmt->execute([$del_id]);

        /* After delete → alert, then reload the same list (keep ?id=…) */
        echo "<script>
                alert('Deleted successfully!!!');
                window.location.href = 'uwithdraw.php?id={$log_id}';
              </script>";
        exit;
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
        exit;
    }
}
?>

<div class="main-panel">
  <div class="content bg-light">
    <div class="page-inner">
      <div class="table-responsive">

<?php
try {
    /* Fetch withdraw records for this user */
    $stmt = $pdo->prepare("SELECT * FROM withdraw WHERE log_id = :log_id");
    $stmt->execute(['log_id' => $log_id]);
    $ordersres = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($ordersres) === 0) {
        echo "<strong>No Requests</strong>";
    } else {
        echo "
        <div class='table-responsive'>
          <table class='table table-bordered'>
            <thead>
              <tr>
                <th>DATE</th>
                <th>LOGIN&nbsp;ID</th>
                <th>ENTRY&nbsp;ID</th>
                <th>USER</th>
                <th>EMAIL</th>
                <th>AMOUNT</th>
                <th>METHOD</th>
                <th>WALLET</th>
                <th>TRANSACTION&nbsp;ID</th>
                <th>STATUS</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>";

        foreach ($ordersres as $row) {
            /* Common values, safely escaped */
            $entryId   = htmlspecialchars($row['id'],       ENT_QUOTES);
            $amount    = htmlspecialchars($row['amount'],   ENT_QUOTES);
            $currency  = htmlspecialchars($row['user_cur'], ENT_QUOTES);
            $method    = htmlspecialchars($row['method'],   ENT_QUOTES);
            $wallet    = htmlspecialchars($row['note'],     ENT_QUOTES);

            echo "<tr>
                    <td>" . date("D jS F Y g.iA", strtotime($row['date'])) . "</td>
                    <td>" . htmlspecialchars($row['log_id'])               . "</td>
                    <td>$entryId</td>
                    <td>" . htmlspecialchars($row['user'])                 . "</td>
                    <td>" . htmlspecialchars($row['email'])                . "</td>
                    <td>$amount&nbsp;$currency</td>
                    <td>$method</td>
                    <td>$wallet</td>
                    <td>" . htmlspecialchars($row['trans_id'])             . "</td>";

            /* Status badge */
            switch ($row['status']) {
                case '0': echo "<td class='text-primary'>PENDING</td>";          break;
                case '1': echo "<td class='text-primary'>AWAITING</td>";         break;
                case '2': echo "<td class='text-success'>WITHDRAW CONFIRMED</td>";break;
                case '3': echo "<td class='text-danger'>DECLINED</td>";          break;
                case '4': echo "<td class='text-danger'>PAUSED</td>";            break;
                default: echo  "<td>UNKNOWN</td>";
            }

            /* Action buttons */
            echo "<td>";
            if ($row['status'] != 2) {
                echo "<a href='uwithdraw_complete.php?id=$entryId' class='btn btn-success btn-sm'>CONFIRM&nbsp;WITHDRAW</a>";
            } else {
                $delUrl = "uwithdraw.php?del={$entryId}&id={$log_id}";
                echo "<a href='#' class='btn btn-danger btn-sm'
                           onclick=\"confirmDelete('$delUrl'); return false;\">DELETE</a>";
            }
            echo "</td>
                  </tr>";
        }

        echo "</tbody></table></div>";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

      </div> <!-- .table-responsive -->
    </div>   <!-- .page-inner -->
  </div>     <!-- .content -->
</div>       <!-- .main-panel -->

<!-- ─────────────────────────────────────────────
     JS confirmation helper (once per page)
     ──────────────────────────────────────────── -->
<script>
function confirmDelete(url) {
    if (confirm("Are you sure you want to delete this withdraw request? This action cannot be undone.")) {
        window.location.href = url;
    }
}
</script>

<?php require("footer.php"); ?>
