<?php
require_once("header.php");

/* ───────────────────────────────
   1.  Get user context (id = log_id)
   ─────────────────────────────── */
$log_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

/* ───────────────────────────────
   2.  Handle deletion before output
   ─────────────────────────────── */
if (isset($_GET['del'])) {
    $del_id = intval($_GET['del']);

    try {
        $stmt = $pdo->prepare("DELETE FROM copied WHERE id = ?");
        $stmt->execute([$del_id]);

        echo "<script>
                alert('Deleted successfully!!!');
                window.location.href = 'ucopy.php?id={$log_id}';
              </script>";
        exit;
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
        exit;
    }
}
?>

<div class="main-panel">
  <div class="content bg-light">
    <div class="page-inner">
      <div class="table-responsive">

<?php
/* ───────────────────────────────
   3.  Fetch copy‑trading records
   ─────────────────────────────── */
try {
    $stmt = $pdo->prepare("SELECT * FROM copied WHERE log_id = :log_id");
    $stmt->execute(['log_id' => $log_id]);
    $copies = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($copies) === 0) {
        echo "<strong>No Requests</strong>";
    } else {
        echo "
        <table class='table table-bordered'>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Username</th>
                    <th>Trader</th>
                    <th>Amount</th>
                    <th>Profit</th>
                    <th>Status</th>
                    <th>Confirm</th>
                    <th>Delete</th>
                </tr>
            </thead>
            <tbody>";

        foreach ($copies as $row) {
            $id       = htmlspecialchars($row['id']);
            $currency = isset($row['currency']) ? htmlspecialchars($row['currency']) : '';
            $amount   = number_format($row['amount'], 2) . " {$currency}";

            echo "<tr>
                <td>{$id}</td>
                <td>" . htmlspecialchars($row['date'])     . "</td>
                <td>" . htmlspecialchars($row['username']) . "</td>
                <td>" . htmlspecialchars($row['trader'])   . "</td>
                <td>{$amount}</td>
                <td>" . htmlspecialchars($row['returnr'])  . "</td>";

            /* Status badge */
            switch ($row['status']) {
                case '0': echo "<td class='text-primary'>PENDING</td>";    break;
                case '1': echo "<td class='text-success'>COMPLETED</td>"; break;
                case '2': echo "<td class='text-danger'>CANCELED</td>";   break;
                default:  echo "<td>UNKNOWN</td>";
            }

            /* Confirm button */
            echo "<td>
                    <a href='ucopy_complete.php?id={$id}' class='btn btn-success btn-sm'>CONFIRM COPY</a>
                  </td>";

            /* Delete button */
            $delUrl = "ucopy.php?del={$id}&id={$log_id}";
            echo "<td>
                    <a href='#' onclick=\"confirmDelete('$delUrl'); return false;\" class='btn btn-danger btn-sm'>DELETE</a>
                  </td>
            </tr>";
        }

        echo "</tbody></table>";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

      </div>
    </div>
  </div>
</div>

<!-- ───────────────────────────────
     4.  Confirmation JavaScript
     ─────────────────────────────── -->
<script>
function confirmDelete(url) {
    if (confirm("Are you sure you want to delete this copy‑trade record? This action cannot be undone.")) {
        window.location.href = url;
    }
}
</script>

<?php require("footer.php"); ?>
