<?php
session_start();
require_once("../config.php"); // Contains $pdo and $config_basedir

// Redirect if not logged in
if (empty($_SESSION['SESS_ADMINLOGGEDIN'])) {
    header("Location: " . $config_basedir . "../admin/adminlogin.php");
    exit;
}

require_once("header.php");

// ================== FETCH SETTINGS ==================
$id = isset($_GET['id']) ? intval($_GET['id']) : 1;
$stmt = $pdo->prepare("SELECT * FROM settings WHERE id = ?");
$stmt->execute([$id]);
$ordrow = $stmt->fetch(PDO::FETCH_ASSOC);

// ================== UPDATE SETTINGS ==================
if (isset($_POST['info'])) {
    $data = [
        'welc_head'   => $_POST['welc_head'] ?? '',
        'welc_msg'    => $_POST['welc_msg'] ?? '',
        'domain_name' => $_POST['domain_name'] ?? '',
        'phone'       => $_POST['phone'] ?? '',
        'country'     => $_POST['country'] ?? '',
        'state'       => $_POST['state'] ?? '',
        'city'        => $_POST['city'] ?? '',
        'address'     => $_POST['address'] ?? '',
        'copyright'   => $_POST['copyright'] ?? '',
        'whatsapp'    => $_POST['whatsapp'] ?? '',
        'LOGO'        => $ordrow['LOGO'],     // keep current unless changed below
        'favicon'     => $ordrow['favicon'],  // keep current unless changed below
    ];

    // ================== HANDLE LOGO ==================
    if (!empty($_FILES['LOGO']['name'])) {
        $ext = strtolower(pathinfo($_FILES["LOGO"]["name"], PATHINFO_EXTENSION));
        $allowed = ["jpg", "jpeg", "png", "gif", "jfif"];
        if (in_array($ext, $allowed) && $_FILES['LOGO']['size'] > 0) {
            $filePath = "img/" . basename($_FILES["LOGO"]["name"]);
            move_uploaded_file($_FILES["LOGO"]["tmp_name"], "../" . $filePath);
            $data['LOGO'] = $filePath;
        }
    }

    // ================== HANDLE FAVICON ==================
    if (!empty($_FILES['favicon']['name'])) {
        $ext = strtolower(pathinfo($_FILES["favicon"]["name"], PATHINFO_EXTENSION));
        $allowed = ["jpg", "jpeg", "png", "gif", "jfif", "ico"];
        if (in_array($ext, $allowed) && $_FILES['favicon']['size'] > 0) {
            $filePath = "img/" . basename($_FILES["favicon"]["name"]);
            move_uploaded_file($_FILES["favicon"]["tmp_name"], "../" . $filePath);
            $data['favicon'] = $filePath;
        }
    }

    // ================== UPDATE DB ==================
    $sql = "UPDATE settings SET
                welc_head = :welc_head,
                welc_msg = :welc_msg,
                domain_name = :domain_name,
                phone = :phone,
                country = :country,
                state = :state,
                city = :city,
                address = :address,
                copyright = :copyright,
                whatsapp = :whatsapp,
                LOGO = :LOGO,
                favicon = :favicon
            WHERE id = :id";

    $stmt = $pdo->prepare($sql);
    $data['id'] = $id;
    $success = $stmt->execute($data);

    echo $success
        ? "<div class='alert alert-success'>Settings updated successfully. <meta http-equiv='refresh' content='2;url='></div>"
        : "<div class='alert alert-danger'>Failed to update settings.</div>";
}
?>


 <div wire:id="0ho7JEz65LVMGIzD4ceZ" wire:initial-data="{&quot;fingerprint&quot;:{&quot;id&quot;:&quot;0ho7JEz65LVMGIzD4ceZ&quot;,&quot;name&quot;:&quot;admin.manage-users&quot;,&quot;locale&quot;:&quot;en&quot;,&quot;path&quot;:&quot;admin\/dashboard\/manageusers&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;v&quot;:&quot;acj&quot;},&quot;effects&quot;:{&quot;listeners&quot;:[],&quot;path&quot;:&quot;https:\/\/xtbtrading.live\/trade\/admin\/dashboard\/manageusers&quot;},&quot;serverMemo&quot;:{&quot;children&quot;:[],&quot;errors&quot;:[],&quot;htmlHash&quot;:&quot;ed570425&quot;,&quot;data&quot;:{&quot;pagenum&quot;:10,&quot;searchvalue&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;id&quot;,&quot;orderdirection&quot;:&quot;desc&quot;,&quot;selectPage&quot;:false,&quot;selectAll&quot;:false,&quot;checkrecord&quot;:[],&quot;selected&quot;:&quot;&quot;,&quot;action&quot;:&quot;Delete&quot;,&quot;username&quot;:null,&quot;fullname&quot;:null,&quot;email&quot;:null,&quot;password&quot;:null,&quot;message&quot;:null,&quot;subject&quot;:null,&quot;plan&quot;:null,&quot;datecreated&quot;:null,&quot;topamount&quot;:null,&quot;toptype&quot;:null,&quot;topcolumn&quot;:&quot;Bonus&quot;,&quot;page&quot;:1,&quot;paginators&quot;:{&quot;page&quot;:1}},&quot;dataMeta&quot;:[],&quot;checksum&quot;:&quot;9e82a6adabccc53607a584c57da8f89b4130352eb62c7aa9cc50f9455ca3c494&quot;}}">
<div class="main-panel">
    <div class="content bg-light">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-dark">Edit Site Info</h1>
            </div>

            <div class="card shadow p-4 bg-light">

                <!-- Current Logo/Favicon -->
                <div class="mb-4 text-center">
                    <img src="../<?= htmlspecialchars($ordrow['LOGO']) ?>" style="width:150px;height:75px;background:#000;margin:10px;">
                    <img src="../<?= htmlspecialchars($ordrow['favicon']) ?>" style="width:75px;height:75px;background:#000;margin:10px;">
                </div>

                <!-- ================== SETTINGS FORM ================== -->
                <form method="POST" enctype="multipart/form-data">

                    <div class="form-group">
                        <h3 class="title1 text-dark">WELCOME HEADER</h3>
                        <input type="text" class="form-control" name="welc_head" value="<?= htmlspecialchars($ordrow['welc_head']) ?>">
                    </div>

                    <div class="form-group">
    <label>WELCOME MESSAGE</label>
    <textarea class="form-control" name="welc_msg" rows="5"><?= htmlspecialchars($ordrow['welc_msg']) ?></textarea>
</div>


                    <div class="form-group">
                        <h3>DOMAIN NAME</h3>
                        <input type="text" class="form-control" name="domain_name" value="<?= htmlspecialchars($ordrow['domain_name']) ?>">
                    </div>

                    <div class="form-group">
                        <h3>PHONE</h3>
                        <input type="text" class="form-control" name="phone" value="<?= htmlspecialchars($ordrow['phone']) ?>">
                    </div>

                    <div class="form-group">
                        <h3>COUNTRY</h3>
                        <input type="text" class="form-control" name="country" value="<?= htmlspecialchars($ordrow['country']) ?>">
                    </div>

                    <div class="form-group">
                        <h3>STATE</h3>
                        <input type="text" class="form-control" name="state" value="<?= htmlspecialchars($ordrow['state']) ?>">
                    </div>

                    <div class="form-group">
                        <h3>CITY</h3>
                        <input type="text" class="form-control" name="city" value="<?= htmlspecialchars($ordrow['city']) ?>">
                    </div>

                    <div class="form-group">
                        <h3>ADDRESS</h3>
                        <input type="text" class="form-control" name="address" value="<?= htmlspecialchars($ordrow['address']) ?>">
                    </div>

                    <div class="form-group">
                        <h3>COPYRIGHT</h3>
                        <input type="text" class="form-control" name="copyright" value="<?= htmlspecialchars($ordrow['copyright']) ?>">
                    </div>

                    <div class="form-group">
                        <h3>WHATSAPP</h3>
                        <input type="text" class="form-control" name="whatsapp" value="<?= htmlspecialchars($ordrow['whatsapp']) ?>">
                    </div>

                    <div class="form-group">
                        <h3>UPLOAD SITE LOGO</h3>
                        <input type="file" class="form-control" name="LOGO" accept="image/*">
                    </div>

                    <div class="form-group">
                        <h3>UPLOAD SITE FAVICON</h3>
                        <input type="file" class="form-control" name="favicon" accept="image/*">
                    </div>

                    <button type="submit" class="btn btn-success btn-block btn-lg" name="info">UPDATE SETTINGS</button>
                </form>
            </div>
        </div>
    </div>
</div></div>

<?php require("footer.php"); ?>
