<?php 
require_once("header.php");

$log_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (isset($_GET['del'])) {
    $del_id = intval($_GET['del']);
    try {
        $stmt = $pdo->prepare("DELETE FROM invest_min WHERE id = ?");
        $stmt->execute([$del_id]);
        echo "<script>
            alert('Deleted successfully!!!');
            window.location.href = 'adminmining.php?id={$log_id}';
        </script>";
        exit;
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
        exit;
    }
}
?>

<div class='main-panel'>
  <div class='content bg-light'>
    <div class='page-inner'>
      <div class='table-responsive'>

<?php
try {
    $stmt = $pdo->prepare("SELECT * FROM invest_min WHERE log_id = :log_id");
    $stmt->execute(['log_id' => $log_id]);
    $ordersres = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($ordersres) == 0) {
        echo "<strong>No Requests</strong>";
    } else {
        echo "<div class='table-responsive'>
            <table class='table table-bordered'>
            <thead>
              <tr>
                <th>#</th>
                <th>Date</th>
                <th>User ID</th>
                <th>Amount</th>
                <th>Subscription Plan</th>
                <th>ROI %</th>
                <th>Duration(Time)</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>";

        foreach ($ordersres as $row) {
            $id       = htmlspecialchars($row['id']);
            $date     = htmlspecialchars($row['date']);
            $user_id  = htmlspecialchars($row['log_id']);
            $amount   = number_format($row['amount'], 2);
            $currency = htmlspecialchars($row['currency']); // fixed variable
            $plan     = htmlspecialchars($row['plan']);
            $percent  = htmlspecialchars($row['percent']);
            $duration = (int)$row['duration'];
            $status   = $row['status'];

            // Duration display helper
            $durations = [
                5 => "5 minutes",
                30 => "30 minutes",
                60 => "1 Hour",
                720 => "12 Hours",
                1440 => "24 Hours",
                10080 => "1 Week",
                20160 => "2 Weeks",
                30240 => "3 Weeks",
                40320 => "1 Month",
                80640 => "2 Months",
                120960 => "3 Months",
                161280 => "4 Months",
                201600 => "5 Months",
                241920 => "6 Months",
                282240 => "7 Months",
                322560 => "8 Months",
                362880 => "9 Months",
                403200 => "10 Months",
                443520 => "11 Months",
                483840 => "12 Months"
            ];
            $duration_text = $durations[$duration] ?? "Unknown";

            echo "<tr>
                    <td>{$id}</td>
                    <td>{$date}</td>
                    <td>{$user_id}</td>
                    <td>{$amount} {$currency}</td>
                    <td>{$plan}</td>
                    <td>{$percent}</td>
                    <td>{$duration_text}</td>
                    <td>";

            if ($status == '1') {
                echo "ACTIVE <div class='spinner-grow text-success'></div>";
            } elseif ($status == '2') {
                echo "COMPLETED <i class='icon ion-md-checkmark-circle-outline green' style='font-size:25px'></i>";
            } elseif ($status == '3') {
                echo "DECLINED <i class='icon ion-md-close-circle-outline red' style='font-size:25px'></i>";
            } else {
                echo "UNKNOWN";
            }

            echo "</td>";

            echo "<td>";
            if ($status != '2') {
                echo "<a href='adminmining_complete.php?id={$id}' class='btn btn-success'>COMPLETE</a> ";
            }

            $delUrl = "adminmining.php?del={$id}&id={$log_id}";
            echo "<a href='#' class='btn btn-danger' onclick=\"if(confirm('Are you sure you want to delete this record?')){ window.location.href='{$delUrl}'; } return false;\">DELETE</a>";

            echo "</td>";

            echo "</tr>";
        }

        echo "</tbody></table></div>";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

      </div>
    </div>
  </div>
</div>

<?php require("footer.php"); ?>
