<?php 
require_once("header.php");

$log_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

/* ─────────────────────────────────────────────
   HANDLE DELETE REQUEST
   ───────────────────────────────────────────── */
if (isset($_GET['del'])) {
    $del_id = intval($_GET['del']);

    try {
        $stmt = $pdo->prepare("DELETE FROM invest WHERE id = ?");
        $stmt->execute([$del_id]);

        echo "<script>
            alert('Deleted successfully!!!');
            window.location.href = 'admininvest.php?id={$log_id}';
        </script>";
        exit;
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
        exit;
    }
}
?>

<div class="main-panel">
  <div class="content bg-light">
    <div class="page-inner">
      <div class="table-responsive">

<?php
try {
    $stmt = $pdo->prepare("SELECT * FROM invest WHERE log_id = :log_id");
    $stmt->execute(['log_id' => $log_id]);
    $investments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($investments) === 0) {
        echo "<strong>No Requests</strong>";
    } else {
        echo "
        <table class='table table-bordered'>
        <thead>
            <tr>
                <th>#</th>
                <th>Date</th>
                <th>User ID</th>
                <th>Amount</th>
                <th>Plan</th>
                <th>ROI %</th>
                <th>Duration</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>";

        // Duration Map
        $durationMap = [
            5 => "5 minutes", 30 => "30 minutes", 60 => "1 Hour", 720 => "12 Hours",
            1440 => "24 Hours", 10080 => "1 Week", 20160 => "2 Weeks", 30240 => "3 Weeks",
            40320 => "1 Month", 80640 => "2 Months", 120960 => "3 Months", 161280 => "4 Months",
            201600 => "5 Months", 241920 => "6 Months", 282240 => "7 Months",
            322560 => "8 Months", 362880 => "9 Months", 403200 => "10 Months",
            443520 => "11 Months", 483840 => "12 Months"
        ];

        foreach ($investments as $row) {
            $id = htmlspecialchars($row['id']);
            $amount = number_format($row['amount'], 2);
            $currency = htmlspecialchars($row['currency'] ?? ''); // Fix: in original code this was undefined

            echo "<tr>
                <td>{$id}</td>
                <td>" . htmlspecialchars($row['date']) . "</td>
                <td>" . htmlspecialchars($row['log_id']) . "</td>
                <td>{$amount} {$currency}</td>
                <td>" . htmlspecialchars($row['plan']) . "</td>
                <td>" . htmlspecialchars($row['percent']) . "</td>
                <td>" . ($durationMap[$row['duration']] ?? "Unknown") . "</td>";

            // Status
            $status = $row['status'];
            echo "<td>";
            if ($status == '1') {
                echo "ACTIVE <div class='spinner-grow text-success'></div>";
            } elseif ($status == '2') {
                echo "COMPLETED <i class='icon ion-md-checkmark-circle-outline green' style='font-size:25px'></i>";
            } elseif ($status == '3') {
                echo "DECLINED <i class='icon ion-md-close-circle-outline red' style='font-size:25px'></i>";
            } else {
                echo "UNKNOWN";
            }
            echo "</td>";

            // Action
            echo "<td>";
            if ($status != '2') {
                echo "<a href='admininvest_complete.php?id={$id}' class='btn btn-success btn-sm'>COMPLETE</a> ";
            }

            // Delete button with confirmation
            $delUrl = "admininvest.php?del={$id}&id={$log_id}";
            echo "<a href='#' onclick=\"confirmDelete('{$delUrl}'); return false;\" class='btn btn-danger btn-sm'>DELETE</a>";
            echo "</td>";

            echo "</tr>";
        }

        echo "</tbody></table>";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

      </div>
    </div>
  </div>
</div>

<script>
function confirmDelete(url) {
    if (confirm("Are you sure you want to delete this investment? This cannot be undone.")) {
        window.location.href = url;
    }
}
</script>

<?php require("footer.php"); ?>
