<?php require("header.php"); ?>

<main class="flex-1 px-2 py-2 md:p-4 pb-20 md:pb-6 overflow-hidden" x-data="{ tab: 'deposit' }">

    <div class="bg-[#0F0A1F] rounded-2xl">
        <!-- Tabs -->
        <div class="flex pt-2 pl-2">
            <button @click="tab = 'deposit'"
                :class="tab === 'deposit' ? 'bg-[#2FE6DE]/10 text-[#2FE6DE]' : 'hover:bg-[#1A1428] text-gray-400 hover:text-[#2FE6DE]'"
                class="flex-1 flex items-center justify-center gap-2 px-4 py-3 rounded-xl transition-colors">
                <i class="fas fa-arrow-down text-sm"></i>
                Deposit
            </button>
            <button @click="tab = 'withdrawal'"
                :class="tab === 'withdrawal' ? 'bg-[#2FE6DE]/10 text-[#2FE6DE]' : 'hover:bg-[#1A1428] text-gray-400 hover:text-[#2FE6DE]'"
                class="flex-1 flex items-center justify-center gap-2 px-4 py-3 rounded-xl transition-colors">
                <i class="fas fa-arrow-up text-sm"></i>
                Withdraw
            </button>
            <button @click="tab = 'others'"
                :class="tab === 'others' ? 'bg-[#2FE6DE]/10 text-[#2FE6DE]' : 'hover:bg-[#1A1428] text-gray-400 hover:text-[#2FE6DE]'"
                class="flex-1 flex items-center justify-center gap-2 px-4 py-3 rounded-xl transition-colors">
                <i class="fas fa-list text-sm"></i>
                Others
            </button>
        </div>

        <!-- Deposits Section -->
        <div class="p-6 space-y-4" x-show="tab === 'deposit'">
            <?php
            $user_id = $_SESSION['SESS_USERID'] ?? 0;
            $stmt = $pdo->prepare("SELECT * FROM deposit WHERE log_id = :log_id ORDER BY date DESC");
            $stmt->execute(['log_id' => $user_id]);
            $deposits = $stmt->fetchAll(PDO::FETCH_ASSOC);
            ?>

            <?php if (count($deposits) === 0): ?>
                <div class="text-center text-gray-400">No deposit history</div>
            <?php else: ?>
                <div class="space-y-4">
                    <?php foreach ($deposits as $row): ?>
                        <div class="bg-[#1A1428] rounded-xl p-4 hover:bg-[#2A243B] transition-colors">
                            <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                                <div class="flex items-center gap-4">
                                    <div class="bg-[#2FE6DE]/10 p-3 rounded-xl">
                                        <i class="fas fa-credit-card text-[#2FE6DE] text-xl"></i>
                                    </div>
                                    <div>
                                        <div class="text-lg font-medium">
                                            <?= htmlspecialchars($row['cur']) ?>
                                            <?= number_format($row['amount'], 2) ?>
                                        </div>
                                        <div class="text-sm text-gray-400">
                                            <?= htmlspecialchars($row['method']) ?>
                                        </div>
                                        <div class="text-xs text-gray-500">
                                            <?= htmlspecialchars($row['note']) ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <?php if ($row['status'] == '1'): ?>
                                        <div class='px-4 py-2 rounded-xl bg-yellow-400/10 text-yellow-400 text-sm flex items-center gap-2'>
                                              <i class='fas fa-spinner fa-spin'></i> Processing
                                          </div>
                                    <?php elseif ($row['status'] == '2'): ?>
                                        <div class="px-4 py-2 rounded-xl bg-green-400/10 text-green-400 text-sm">
                                            <i class="fas fa-check-circle"></i> Completed
                                        </div>
                                    <?php else: ?>
                                        <div class="px-4 py-2 rounded-xl bg-yellow-400/10 text-yellow-400 text-sm">
                                            <i class="fas fa-clock"></i> Processing
                                        </div>
                                    <?php endif; ?>

                                    <div class="text-sm text-gray-400">
                                        <?= date("M d, Y h:i A", strtotime($row['date'])) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Withdrawals Section -->
<div class="p-6 space-y-4" x-show="tab === 'withdrawal'" x-cloak>
    <?php
    $user_id = $_SESSION['SESS_USERID'] ?? 0;

    $stmt = $pdo->prepare("SELECT * FROM withdraw WHERE log_id = :log_id ORDER BY date DESC");
    $stmt->execute(['log_id' => $user_id]);
    $withdrawals = $stmt->fetchAll(PDO::FETCH_ASSOC);
    ?>

    <?php if (count($withdrawals) === 0): ?>
        <div class="text-center text-gray-400">No withdrawal history</div>
    <?php else: ?>
        <div class="space-y-4">
            <?php foreach ($withdrawals as $row): ?>
                <div class="bg-[#1A1428] rounded-xl p-4 hover:bg-[#2A243B] transition-colors">
                    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                        <div class="flex items-center gap-4">
                            <div class="bg-[#2FE6DE]/10 p-3 rounded-xl">
                                <i class="fas fa-university text-[#2FE6DE] text-xl"></i>
                            </div>
                            <div>
                                <div class="text-lg font-medium">
                                    <?= htmlspecialchars($row['cur']) ?>
                                    <?= number_format($row['amount'], 2) ?>
                                </div>
                                <div class="text-sm text-gray-400">
                                    <?= htmlspecialchars($row['method']) ?>
                                </div>
                                <div class="text-xs text-gray-500">
                                    <?= htmlspecialchars($row['note']) ?>
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center gap-4">
                            <?php
                            switch ($row['status']) {
                                case '1': // PROCESSING
                                    echo "<div class='px-4 py-2 rounded-xl bg-yellow-400/10 text-yellow-400 text-sm flex items-center gap-2'>
                                              <i class='fas fa-spinner fa-spin'></i> Processing
                                          </div>";
                                    break;
                                case '2': // COMPLETED
                                    echo "<div class='px-4 py-2 rounded-xl bg-green-400/10 text-green-400 text-sm flex items-center gap-2'>
                                              <i class='fas fa-check-circle'></i> Completed
                                          </div>";
                                    break;
                                case '3': // DECLINED
                                    echo "<div class='px-4 py-2 rounded-xl bg-red-400/10 text-red-400 text-sm flex items-center gap-2'>
                                              <i class='fas fa-times-circle'></i> Declined
                                          </div>";
                                    break;
                                default:
                                    echo "<div class='px-4 py-2 rounded-xl bg-gray-400/10 text-gray-400 text-sm flex items-center gap-2'>
                                              <i class='fas fa-question-circle'></i> Unknown
                                          </div>";
                            }
                            ?>

                            <div class="text-sm text-gray-400">
                                <?= date("M d, Y h:i A", strtotime($row['date'])) ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>


        <!-- Others Section -->
        <div class="p-6 space-y-4" x-show="tab === 'others'" x-cloak>
            <div class="text-center text-gray-400">No other transactions yet</div>
        </div>
    </div>

</main>

<?php require("footer.php"); ?>

<!-- Alpine.js -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
