<?php require ("header.php") ?>


     <main class="flex-1 px-2 py-2 md:p-4 pb-20 md:pb-6 overflow-hidden">
            <div class="bg-gradient-to-b from-[#1A1428] to-[#0F0A1F]">
    <div class="w-full mx-auto px-2 sm:px-6 lg:px-8 py-6">
        <div>
<!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->
</div>

    <div>
<!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->
</div>

        <!-- Signal Trading Header -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-8">
            <div class="flex items-center">
                <div class="w-12 h-12 rounded-full bg-[#2FE6DE]/10 flex items-center justify-center mr-3">
                    <i class="fas fa-robot text-[#2FE6DE] text-xl"></i>
                </div>
                <div>
                    <h1 class="text-2xl font-bold text-white">AI Trading Signals</h1>
                    <p class="text-gray-400 mt-1">Let our AI-powered Signals trade for you</p>
                </div>
            </div>
            <div class="mt-4 md:mt-0 flex space-x-3">
                <a href="trade.php" class="px-4 py-2.5 bg-[#2FE6DE] text-black font-medium rounded-lg hover:bg-[#27c5be] transition-colors flex items-center focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]/50">
                    <i class="fas fa-chart-line mr-2"></i> Manual Trading
                </a>
                <a href="buy_signal.php#available-bots" class="px-4 py-2.5 bg-[#2A243B] text-white rounded-lg hover:bg-[#382f50] transition-colors flex items-center focus:outline-none focus:ring-2 focus:ring-gray-600/50">
                    <i class="fas fa-robot text-[#2FE6DE] text-xl"></i> Signal Trading
                </a>
            </div>
        </div>

        <!-- Stats Overview -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
            
            
            
           <?php
// =======================
// Trading stats (PDO)
// =======================
$log_id = $_SESSION['SESS_USERID'] ?? 0; // adjust if your session key is different
if (!$log_id) {
    echo "User not logged in.";
    return;
}

// 1) Active Signals: count trades where expirytime is still in the future
$stmt = $pdo->prepare("SELECT COUNT(*) FROM trade WHERE log_id = :log_id AND status = 1");
$stmt->execute([':log_id' => $log_id]);
$active_signals = (int)$stmt->fetchColumn();

// 2) Total Profit: sum of `returnr` (and also sum of numeric user_iprofit just in case)
$stmt = $pdo->prepare("SELECT COALESCE(SUM(returnr),0) AS sum_returnr, COALESCE(SUM(user_iprofit),0) AS sum_user_iprofit
                       FROM trade WHERE log_id = :log_id");
$stmt->execute([':log_id' => $log_id]);
$profitRow = $stmt->fetch(PDO::FETCH_ASSOC);
$total_profit_returnr = (float)$profitRow['sum_returnr'];
$total_profit_iprofit = (float)$profitRow['sum_user_iprofit'];

// 3) Completed trades stats (completed = expirytime <= NOW())
$stmt = $pdo->prepare("
    SELECT 
      COUNT(*) AS completed_count,
      SUM(CASE WHEN user_iprofit > 0 THEN 1 ELSE 0 END) AS wins,
      COALESCE(AVG(`Wrate`),0) AS avg_wrate
    FROM trade
    WHERE log_id = :log_id AND expirytime <= NOW()
");
$stmt->execute([':log_id' => $log_id]);
$completedRow = $stmt->fetch(PDO::FETCH_ASSOC);
$completed_count = (int)$completedRow['completed_count'];
$wins = (int)$completedRow['wins'];
$avg_wrate = (float)$completedRow['avg_wrate'];

// Defensive: avoid division by zero
$win_percentage = $completed_count > 0 ? ($wins / $completed_count) * 100 : 0.0;

// Format for display
$active_signals_display = $active_signals;
$total_profit_display = number_format($total_profit_returnr, 2);          // primary as returnr
$total_profit_alt = number_format($total_profit_iprofit, 2);              // alternative using user_iprofit
$win_percentage_display = number_format($win_percentage, 1);             // e.g. 85.0
$avg_wrate_display = number_format($avg_wrate, 4);                       // keep precision

?>

<!-- Active Signals -->
<div class="bg-[#0F0A1F] rounded-xl p-5 border border-gray-800/30 shadow-lg">
    <div class="flex items-center justify-between">
        <div>
            <p class="text-gray-400 text-sm">Active Signals</p>
            <h3 class="text-2xl font-bold text-white mt-1"><?= $active_signals_display ?></h3>
        </div>
        <div class="w-10 h-10 rounded-full bg-blue-500/10 flex items-center justify-center">
            <i class="fas fa-robot text-blue-400"></i>
        </div>
    </div>
    <div class="mt-2 text-xs text-gray-400">
        <?php if ($active_signals > 0): ?>
            <span><i class="fas fa-bolt"></i> <?= $active_signals ?> active signal<?= $active_signals>1 ? 's' : '' ?></span>
        <?php else: ?>
            <span><i class="fas fa-circle-notch"></i> No active signals</span>
        <?php endif; ?>
    </div>
</div>

<!-- Total Profit -->
<div class="bg-[#0F0A1F] rounded-xl p-5 border border-gray-800/30 shadow-lg mt-4">
    <div class="flex items-center justify-between">
        <div>
            <p class="text-gray-400 text-sm">Total Profit</p>
            <h3 class="text-2xl font-bold text-white mt-1"><?php echo $cur_symbol ?><?= $total_profit_display ?></h3>
        </div>
        <div class="w-10 h-10 rounded-full bg-green-500/10 flex items-center justify-center">
            <i class="fas fa-chart-line text-green-400"></i>
        </div>
    </div>
    <div class="mt-2 text-xs text-gray-400">
        <i class="fas fa-info-circle"></i>
        Calculated from `returnr`. (alt: user_iprofit = <?php echo $cur_symbol ?><?= $total_profit_alt ?>)
    </div>
</div>

<!-- Win Rate -->
<div class="bg-[#0F0A1F] rounded-xl p-5 border border-gray-800/30 shadow-lg mt-4">
    <div class="flex items-center justify-between">
       <?php
// Fetch total Wrate (sum of all percentages) for this user
$wrateStmt = $pdo->prepare("SELECT SUM(Wrate) as totalWrate FROM trade WHERE log_id = :log_id");
$wrateStmt->execute(['log_id' => $userId]);
$totalWrate = $wrateStmt->fetch(PDO::FETCH_ASSOC)['totalWrate'] ?? 0;
?>

<div>
    <p class="text-gray-400 text-sm">Win Rate</p>
    <h3 class="text-2xl font-bold text-white mt-1">
        <?= number_format($totalWrate, 2) ?>%
    </h3>
</div>

        <div class="w-10 h-10 rounded-full bg-purple-500/10 flex items-center justify-center">
            <i class="fas fa-trophy text-purple-400"></i>
        </div>
    </div>
    <div class="mt-2 text-xs text-gray-400">
        Based on <?= $completed_count ?> completed trade<?= $completed_count!==1 ? 's' : '' ?> • Avg Wrate: <?= $avg_wrate_display ?>
    </div>
</div>

            
            <div class="bg-[#0F0A1F] rounded-xl p-5 border border-gray-800/30 shadow-lg">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-400 text-sm">Available Balance</p>
                        <h3 class="text-2xl font-bold text-white mt-1"><?php echo $cur_symbol ?><?php echo $balc ?></h3>
                    </div>
                    <div class="w-10 h-10 rounded-full bg-[#2FE6DE]/10 flex items-center justify-center">
                        <i class="fas fa-wallet text-[#2FE6DE]"></i>
                    </div>
                </div>
                <div class="mt-2">
                    <a href="deposit.php" class="text-xs text-[#2FE6DE] hover:underline focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]/50 rounded px-1">
                        <i class="fas fa-plus-circle"></i> Add funds
                    </a>
                </div>
            </div>
        </div>


        
        
        
        
        
        
        
        
        
        
        <!-- Quick Filters -->
        <!--<div class="flex flex-wrap gap-2 mb-4">-->
        <!--    <a href="#all" class="px-3 py-1.5 rounded-lg text-sm bg-[#2FE6DE]/10 text-[#2FE6DE] border border-[#2FE6DE]/30 transition-colors">-->
        <!--        All Trades-->
        <!--    </a>-->
        <!--    <a href="#active" class="px-3 py-1.5 rounded-lg text-sm bg-[#2A243B] text-gray-300 border border-gray-800/30 transition-colors">-->
        <!--        Active-->
        <!--    </a>-->
        <!--    <a href="#win" class="px-3 py-1.5 rounded-lg text-sm bg-[#2A243B] text-gray-300 border border-gray-800/30 transition-colors">-->
        <!--        Wins-->
        <!--    </a>-->
        <!--    <a href="#loss" class="px-3 py-1.5 rounded-lg text-sm bg-[#2A243B] text-gray-300 border border-gray-800/30 transition-colors">-->
        <!--        Losses-->
        <!--    </a>-->
        <!--    <a href="#completed" class="px-3 py-1.5 rounded-lg text-sm bg-[#2A243B] text-gray-300 border border-gray-800/30 transition-colors">-->
        <!--        Completed-->
        <!--    </a>-->
        <!--</div>-->
        
        <!-- Advanced Filters -->
        <!--<div class="bg-[#0F0A1F] rounded-xl p-6 mb-6 border border-gray-800/30 shadow-lg">-->
        <!--    <div class="flex items-center justify-between mb-4">-->
        <!--        <h2 class="text-white font-medium flex items-center">-->
        <!--            <i class="fas fa-filter text-[#2FE6DE] mr-2"></i>-->
        <!--            Advanced Filters-->
        <!--        </h2>-->
        <!--        <button type="button" id="toggle-filters" class="text-gray-400 hover:text-white transition-colors">-->
        <!--            <i class="fas fa-chevron-down"></i>-->
        <!--        </button>-->
        <!--    </div>-->
            
        <!--    <div id="filter-form" class="filter-form">-->
        <!--        <form action="https://trade.helplabs.cloud/user/trading/bots/history" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">-->
        <!--            <div>-->
        <!--                <label for="status" class="block text-gray-400 mb-2 text-sm">Status</label>-->
        <!--                <select name="status" id="status" class="w-full bg-[#1A1428] text-white border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]/50">-->
        <!--                    <option value="">All Statuses</option>-->
        <!--                    <option value="pending" >Pending</option>-->
        <!--                    <option value="active" >Active</option>-->
        <!--                    <option value="completed" >Completed</option>-->
        <!--                </select>-->
        <!--            </div>-->
                    
        <!--            <div>-->
        <!--                <label for="result" class="block text-gray-400 mb-2 text-sm">Result</label>-->
        <!--                <select name="result" id="result" class="w-full bg-[#1A1428] text-white border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]/50">-->
        <!--                    <option value="">All Results</option>-->
        <!--                    <option value="win" >Win</option>-->
        <!--                    <option value="loss" >Loss</option>-->
        <!--                </select>-->
        <!--            </div>-->
                    
        <!--            <div>-->
        <!--                <label for="bot_id" class="block text-gray-400 mb-2 text-sm">Signal</label>-->
        <!--                <select name="bot_id" id="bot_id" class="w-full bg-[#1A1428] text-white border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]/50">-->
        <!--                    <option value="">All Signals</option>-->
        <!--                                                    <option value="1" >-->
        <!--                            Signalname-->
        <!--                        </option>-->
        <!--                                            </select>-->
        <!--            </div>-->
                    
        <!--            <div>-->
        <!--                <label for="pair" class="block text-gray-400 mb-2 text-sm">Trading Pair</label>-->
        <!--                <select name="pair" id="pair" class="w-full bg-[#1A1428] text-white border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]/50">-->
        <!--                    <option value="">All Pairs</option>-->
        <!--                                                    <option value="BTC/USDT" >-->
        <!--                            BTC/USDT-->
        <!--                        </option>-->
        <!--                                                    <option value="BNB/USDT" >-->
        <!--                            BNB/USDT-->
        <!--                        </option>-->
        <!--                                                    <option value="SOL/USDT" >-->
        <!--                            SOL/USDT-->
        <!--                        </option>-->
        <!--                                                    <option value="ADA/USDT" >-->
        <!--                            ADA/USDT-->
        <!--                        </option>-->
        <!--                                                    <option value="ETH/USDT" >-->
        <!--                            ETH/USDT-->
        <!--                        </option>-->
        <!--                                            </select>-->
        <!--            </div>-->
                    
        <!--            <div class="md:col-span-2 lg:col-span-4 flex flex-col sm:flex-row gap-3 mt-2">-->
        <!--                <button type="submit" class="flex-1 bg-[#2FE6DE] text-black px-4 py-2.5 rounded-lg font-medium hover:bg-[#27c5be] transition-colors flex items-center justify-center">-->
        <!--                    <i class="fas fa-search mr-2"></i> Apply Filters-->
        <!--                </button>-->
                        
        <!--                <a href="" class="flex-1 bg-[#2A243B] text-white px-4 py-2.5 rounded-lg hover:bg-[#382f50] transition-colors flex items-center justify-center">-->
        <!--                    <i class="fas fa-times mr-2"></i> Clear Filters-->
        <!--                </a>-->
        <!--            </div>-->
        <!--        </form>-->
        <!--    </div>-->
        <!--</div>-->
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        <?php
// Fetch last 8 trades for this user
$stmt = $pdo->prepare("SELECT * FROM trade WHERE log_id = :log_id ORDER BY id DESC LIMIT 1000");
$stmt->execute(['log_id' => $userId]);
$trades = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="bg-[#0F0A1F] rounded-xl p-6 border border-gray-800/30 shadow-lg">

    <!-- Desktop View -->
    <div class="hidden md:block overflow-x-auto scrollbar-hide">
        <table class="w-full min-w-[900px]">
            <thead>
                <tr class="text-left text-gray-400 text-sm border-b border-gray-800/50">
                    <th class="pb-4 pl-2">Signal</th>
                    <th class="pb-4">Trading Pair</th>
                    <th class="pb-4">Trading Type</th>
                    <th class="pb-4">Amount</th>
                    <th class="pb-4">Direction</th>
                    <th class="pb-4">Entry/Close</th>
                    <th class="pb-4">Time</th>
                    <th class="pb-4">Status</th>
                    <th class="pb-4">Result</th>
                    <th class="pb-4">Profit/Loss</th>
                    <th class="pb-4 text-right pr-2">Details</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($trades as $trade): 
                    $direction = strtolower($trade['optionr']) === 'buy' ? 'Buy' : 'Sell';
                    $directionColor = $direction === 'Buy' ? 'green-400' : 'red-400';
                    $statusText = $trade['status'] == 1 ? 'Pending' : 'Completed';
                    $statusColor = $trade['status'] == 1 ? 'yellow-400' : 'green-400';

                    // Result logic based on returnr
                    $result = ($trade['returnr'] > 1) ? 'Win' : 'Trading..';
                    $resultColor = ($trade['returnr'] > 1) ? 'green-400' : 'red-400';

                    // Profit/Loss shows returnr
                    $profitLoss = (float)$trade['returnr'];
                    $wrate = $trade['Wrate'] ?? 0;
                ?>
                <tr class="border-b border-gray-800/30 text-white hover:bg-[#191023]/50 transition-colors">
                    <td class="py-4 pl-2">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-[#2A243B] flex items-center justify-center mr-2">
                                <i class="fas fa-robot text-[#2FE6DE]"></i>
                            </div>
                            <span class="font-medium"><?= htmlspecialchars($trade['signa']) ?></span>
                        </div>
                    </td>
                    <td class="py-4"><?= htmlspecialchars($trade['asset']) ?></td>
                    <td class="py-4"><?= htmlspecialchars($trade['plan']) ?></td>
                    <td class="py-4"><?= htmlspecialchars($trade['user_cur']) ?><?= number_format($trade['invested'], 2) ?></td>
                    <td class="py-4">
                        <span class="px-2 py-1 rounded-full text-xs bg-<?= $directionColor ?>/20 text-<?= $directionColor ?>">
                            <i class="fas fa-arrow-<?= $direction === 'Buy' ? 'up' : 'down' ?> mr-1"></i>
                            <?= $direction ?>
                        </span>
                    </td>
                    <td class="py-4">
                        <div class="text-sm"><?= $trade['user_cur'] ?><?= number_format($trade['entryrate'], 2) ?></div>
                        <div class="text-xs text-green-400"><?= $trade['user_cur'] ?><?= number_format($trade['closerate'], 2) ?></div>
                    </td>
                    <td class="py-4">
                        <div class="text-sm"><?= date("M d, Y H:i", strtotime($trade['entrytime'])) ?></div>
                        <div class="text-xs text-gray-400"><?= date("M d, Y H:i", strtotime($trade['expirytime'])) ?></div>
                    </td>
                    <td class="py-4">
                        <span class="px-2 py-1 rounded-full text-xs bg-<?= $statusColor ?>/20 text-<?= $statusColor ?>">
                            <i class="fas fa-check-circle mr-1"></i> <?= $statusText ?>
                        </span>
                    </td>
                    <td class="py-4">
                        <span class="px-2 py-1 rounded-full text-xs bg-<?= $resultColor ?>/20 text-<?= $resultColor ?>">
                            <i class="fas fa-trophy mr-1"></i> <?= $result ?>
                        </span>
                    </td>
                    <td class="py-4">
                        <?php if ($trade['status'] == 1): ?>
                            <span class="text-yellow-400 font-medium">-- --</span>
                        <?php else: ?>
                            <span class="text-<?= $resultColor ?> font-medium">
                                <?= $trade['user_cur'] ?><?= number_format($profitLoss, 2) ?>
                                <span class="text-xs opacity-75">(<?= number_format($wrate, 2) ?>%)</span>
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="py-4 text-right pr-2">
                        <a href="trade_details.php?id=<?= $trade['id'] ?>" class="px-3 py-1.5 bg-[#2A243B] text-[#2FE6DE] rounded-lg hover:bg-[#382f50] transition-colors inline-flex items-center">
                            <i class="fas fa-eye mr-1.5"></i> Details
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

   <!-- Mobile horizontal scrollable table -->
<div id="scrollableTable" class="md:hidden overflow-x-auto scrollbar-thick scrollbar-thumb-[#2FE6DE] scrollbar-track-[#0F0A1F] rounded-lg border border-gray-800/30">
    <table class="min-w-[800px] w-full text-white text-sm border-collapse">
        <thead>
            <tr class="bg-[#191023] border-b border-gray-800/50 text-left">
                <th class="px-4 py-2 whitespace-nowrap">Signal</th>
                <th class="px-4 py-2 whitespace-nowrap">Type</th>
                <th class="px-4 py-2 whitespace-nowrap">Pair</th>
                <th class="px-4 py-2 whitespace-nowrap">Amount</th>
                <th class="px-4 py-2 whitespace-nowrap">Direction</th>
                <th class="px-4 py-2 whitespace-nowrap">Entry Price</th>
                <th class="px-4 py-2 whitespace-nowrap">Close Price</th>
                <th class="px-4 py-2 whitespace-nowrap">Time</th>
                <th class="px-4 py-2 whitespace-nowrap">Duration</th>
                <th class="px-4 py-2 whitespace-nowrap">Status</th>
                <th class="px-4 py-2 whitespace-nowrap">Result</th>
                <th class="px-4 py-2 whitespace-nowrap">Profit/Loss</th>
                <th class="px-4 py-2 whitespace-nowrap">Details</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($trades as $trade):
                $direction = strtolower($trade['optionr']) === 'buy' ? 'Buy' : 'Sell';
                $directionColor = $direction === 'Buy' ? 'green-400' : 'red-400';
                $statusText = $trade['status'] == 1 ? 'Pending' : 'Completed';
                $statusColor = $trade['status'] == 1 ? 'yellow-400' : 'green-400';

                $result = ($trade['returnr'] > 1) ? 'Win' : 'Loss';
                $resultColor = ($trade['returnr'] > 1) ? 'green-400' : 'red-400';

                $profitLoss = (float)$trade['returnr'];
                $wrate = $trade['Wrate'] ?? 0;

                // Duration calculation
                $entryTime = new DateTime($trade['entrytime']);
                $expiryTime = new DateTime($trade['expirytime']);
                $interval = $entryTime->diff($expiryTime);
                $durationStr = '';
                if ($interval->d > 0) $durationStr .= $interval->d . 'd ';
                if ($interval->h > 0) $durationStr .= $interval->h . 'h ';
                if ($interval->i > 0) $durationStr .= $interval->i . 'm';
                $durationStr = trim($durationStr);
                if ($durationStr === '') $durationStr = '0m';
            ?>
            <tr class="border-b border-gray-800/30 hover:bg-[#191023]/60 transition-colors">
                <td class="px-4 py-2 whitespace-nowrap flex items-center">
                    <div class="w-6 h-6 rounded-full bg-[#2A243B] flex items-center justify-center mr-2">
                        <i class="fas fa-robot text-[#2FE6DE]"></i>
                    </div>
                    <?= htmlspecialchars($trade['signa']) ?>
                </td>
                 <td class="px-4 py-2 whitespace-nowrap"><?= htmlspecialchars($trade['plan']) ?></td>
                 <td class="px-4 py-2 whitespace-nowrap"><?= htmlspecialchars($trade['asset']) ?></td>
                <td class="px-4 py-2 whitespace-nowrap"><?= htmlspecialchars($trade['user_cur']) ?><?= number_format($trade['invested'], 2) ?></td>
                <td class="px-4 py-2 whitespace-nowrap">
                    <span class="px-2 py-0.5 rounded-full text-xs bg-<?= $directionColor ?>/20 text-<?= $directionColor ?>">
                        <i class="fas fa-arrow-<?= $direction === 'Buy' ? 'up' : 'down' ?> mr-1"></i> <?= $direction ?>
                    </span>
                </td>
                <td class="px-4 py-2 whitespace-nowrap"><?= $trade['user_cur'] ?><?= number_format($trade['entryrate'], 2) ?></td>
                <td class="px-4 py-2 whitespace-nowrap text-green-400"><?= $trade['user_cur'] ?><?= number_format($trade['closerate'], 2) ?></td>
                <td class="px-4 py-2 whitespace-nowrap"><?= date("M d, Y H:i", strtotime($trade['entrytime'])) ?></td>
                <td class="px-4 py-2 whitespace-nowrap"><?= $durationStr ?></td>
                <td class="px-4 py-2 whitespace-nowrap">
                    <span class="px-2 py-0.5 rounded-full text-xs bg-<?= $statusColor ?>/20 text-<?= $statusColor ?>">
                        <?= $statusText ?>
                    </span>
                </td>
                <td class="px-4 py-2 whitespace-nowrap">
                    <span class="px-2 py-0.5 rounded-full text-xs bg-<?= $resultColor ?>/20 text-<?= $resultColor ?>">
                        <?= $result ?>
                    </span>
                </td>
                <td class="px-4 py-2 whitespace-nowrap font-medium">
                    <?php if ($trade['status'] == 1): ?>
                        <span class="text-yellow-400">-- --</span>
                    <?php else: ?>
                        <span class="text-<?= $resultColor ?>">
                            <?= $trade['user_cur'] ?><?= number_format($profitLoss, 2) ?>
                            <span class="text-xs opacity-75">(<?= number_format($wrate, 2) ?>%)</span>
                        </span>
                    <?php endif; ?>
                </td>
                <td class="px-4 py-2 whitespace-nowrap">
                    <a href="trade_details.php?id=<?= $trade['id'] ?>" class="px-3 py-1 bg-[#2A243B] text-[#2FE6DE] rounded-lg hover:bg-[#382f50] transition-colors inline-flex items-center">
                        <i class="fas fa-eye mr-1"></i> Details
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
  document.addEventListener("DOMContentLoaded", function() {
    const container = document.getElementById('scrollableTable');
    if (!container) return;

    let direction = 1; // 1 = right, -1 = left
    const speed = 0.5; // pixels per frame
    let animationId;

    function scrollStep() {
      container.scrollLeft += direction * speed;

      // Reverse direction when reaching scroll ends
      if (container.scrollLeft + container.clientWidth >= container.scrollWidth) {
        direction = -1;
      } else if (container.scrollLeft <= 0) {
        direction = 1;
      }

      animationId = requestAnimationFrame(scrollStep);
    }

    // Intersection Observer to start scrolling only when visible
    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          if (!animationId) animationId = requestAnimationFrame(scrollStep);
        } else {
          if (animationId) {
            cancelAnimationFrame(animationId);
            animationId = null;
          }
        }
      });
    }, { threshold: 0.1 });

    observer.observe(container);
  });
</script>
</div>

                    
                    
                    
                    
                    
            
            
            
            
            
            
            
                    
    
</div>

<style>
.scrollbar-hide::-webkit-scrollbar {
    display: none;
}
.scrollbar-hide {
    -ms-overflow-style: none;
    scrollbar-width: none;
}
.pulse-animation {
    animation: pulse 2s infinite;
}
@keyframes pulse {
    0% {
        box-shadow: 0 0 0 0 rgba(52, 211, 153, 0.7);
    }
    70% {
        box-shadow: 0 0 0 6px rgba(52, 211, 153, 0);
    }
    100% {
        box-shadow: 0 0 0 0 rgba(52, 211, 153, 0);
    }
}
.pagination-container nav {
    display: flex;
    justify-content: center;
}
.pagination-container nav > div {
    display: flex;
    align-items: center;
}
.pagination-container nav > div > span,
.pagination-container nav > div > a {
    margin: 0 0.25rem;
    padding: 0.5rem 0.75rem;
    border-radius: 0.5rem;
    font-size: 0.875rem;
    transition: all 0.2s;
}
.pagination-container nav > div > span {
    background-color: rgba(47, 230, 222, 0.1);
    color: #2FE6DE;
    border: 1px solid rgba(47, 230, 222, 0.3);
}
.pagination-container nav > div > a {
    background-color: #2A243B;
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.1);
}
.pagination-container nav > div > a:hover {
    background-color: #382f50;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle filter form
    const toggleFiltersBtn = document.getElementById('toggle-filters');
    const filterForm = document.getElementById('filter-form');
    
    if (toggleFiltersBtn && filterForm) {
        toggleFiltersBtn.addEventListener('click', function() {
            filterForm.classList.toggle('hidden');
            const icon = this.querySelector('i');
            if (icon.classList.contains('fa-chevron-down')) {
                icon.classList.remove('fa-chevron-down');
                icon.classList.add('fa-chevron-up');
            } else {
                icon.classList.remove('fa-chevron-up');
                icon.classList.add('fa-chevron-down');
            }
        });
    }
    
    // Export functionality
    const exportBtn = document.getElementById('export-btn');
    if (exportBtn) {
        exportBtn.addEventListener('click', function() {
            // Get current URL parameters to maintain filters
            const urlParams = new URLSearchParams(window.location.search);
            
            // Create export URL with current filters
            let exportUrl = 'https://trade.helplabs.cloud/user/trading/bots/history/export?format=xlsx';
            
            // Add all current filters to the export URL
            if (urlParams.has('status')) {
                exportUrl += '&status=' + urlParams.get('status');
            }
            
            if (urlParams.has('result')) {
                exportUrl += '&result=' + urlParams.get('result');
            }
            
            if (urlParams.has('bot_id')) {
                exportUrl += '&bot_id=' + urlParams.get('bot_id');
            }
            
            if (urlParams.has('pair')) {
                exportUrl += '&pair=' + urlParams.get('pair');
            }
            
            if (urlParams.has('start_date')) {
                exportUrl += '&start_date=' + urlParams.get('start_date');
            }
            
            if (urlParams.has('end_date')) {
                exportUrl += '&end_date=' + urlParams.get('end_date');
            }
            
            // Redirect to the export URL which will trigger the download
            window.location.href = exportUrl;
        });
    }
    
    // Check if there are any active filters and show the filter form if so
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.has('status') || urlParams.has('result') || urlParams.has('bot_id') || urlParams.has('pair')) {
        if (filterForm) {
            filterForm.classList.remove('hidden');
            if (toggleFiltersBtn) {
                const icon = toggleFiltersBtn.querySelector('i');
                icon.classList.remove('fa-chevron-down');
                icon.classList.add('fa-chevron-up');
            }
        }
    } else {
        // Hide filter form by default on mobile
        if (window.innerWidth < 768 && filterForm) {
            filterForm.classList.add('hidden');
        }
    }
});
</script>
        </main>
    
    
    
    <?php require ("footer.php") ?>