<?php require ("header.php")?>

<?php
// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $swift_fee = $_POST['swift_fee'] ?? '';
    $swift_pin = $_POST['swift_pin'] ?? '';
    $hidden_pin = $_POST['hidden_pin'] ?? '';
    $deposit = $_POST['deposit'] ?? '';
    $id = $_POST['id'] ?? '';

    if (empty($id)) {
        die("<div class='alert alert-danger'>User ID is missing! Debugging: " . var_export($_POST, true) . "</div>");
    }

    try {
        $stmt = $pdo->prepare("SELECT userbill FROM logins WHERE swift_fee = :swift_fee AND swift_pin = :swift_pin");
        $stmt->execute([
            ':swift_fee' => $swift_fee,
            ':swift_pin' => $swift_pin
        ]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            $userbill = $user['userbill'];
            $upgfee = $userbill + $deposit;

            $updateStmt = $pdo->prepare("UPDATE logins SET swift_pin = :hidden_pin, userbill = :upgfee, swift_status = 0 WHERE id = :id");
            $updateStmt->execute([
                ':hidden_pin' => $hidden_pin,
                ':upgfee' => $upgfee,
                ':id' => $id
            ]);

            $success = "
                <strong><img src='tools/small-box-loading.gif' width=150 height=50></strong><br>
                <div class='alert alert-success' style='margin-bottom:20px;'>
                    Swift Pin Granted Successfully...
                    <meta http-equiv='refresh' content='10; url=withdraw.php' />
                </div>";
        } else {
            $error5 = "<div class='alert alert-danger' align='center'>Incorrect Swift Pin!!!</div>";
        }
    } catch (PDOException $e) {
        $error5 = "<div class='alert alert-danger' align='center'>Database Error: " . $e->getMessage() . "</div>";
    }
}
?>

<div class="main-panel">
    <div class="content-wrapper bg-dark">
        <div class="row">
            <div class="col-md-12 grid-margin">
                <div class="d-flex justify-content-between flex-wrap">
                    <div class="align-items-end flex-wrap">
                        <div class="no-deposit">
                            <h4 class="card-title" style="font-family: 'Roboto'!important;">Swift FEE</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- SweetAlert2 Script for Swift PIN -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    title: 'Swift PIN Required',
                    html: `
                        <form method="POST">
                            <input type="hidden" name="id" value="<?php echo htmlspecialchars($id ?? ''); ?>">
                            <div class="form-group">
                                <label>Swift FEE (<?php echo $currency ?? ''; ?>)</label>
                                <input type="text" class="swal2-input" value="<?php echo $deposit*$swift_fee ?? ''; ?>" readonly>
                            </div>
                            <div class="form-group">
                                <label>Swift Percent (%)</label>
                                <input type="text" class="swal2-input" name="swift_fee" value="<?php echo $swift_fee ?? ''; ?>" readonly>
                            </div>
                            <div class="form-group">
                                <label>Swift PIN</label>
                                <input type="text" class="swal2-input" name="swift_pin" placeholder="******" required>
                            </div>
                            <input type="hidden" name="hidden_pin" value="<?php echo $swift_pin ?? ''; ?>">
                            <input type="hidden" name="deposit" value="<?php echo $deposit ?? ''; ?>">
                        </form>
                    `,
                    showCancelButton: true,
                    cancelButtonText: 'Cancel',
                    showDenyButton: true,
                    denyButtonText: 'Contact Support',
                    confirmButtonText: 'Submit PIN',
                    focusConfirm: false,
                    didOpen: () => {
                        const input = Swal.getPopup().querySelector('input[name="swift_pin"]');
                        if(input) input.focus();
                    }
                }).then((result) => {
                    if(result.isConfirmed) {
                        const form = Swal.getPopup().querySelector('form');
                        form.submit();
                    } else if(result.isDenied) {
                        window.location.href = 'support.php';
                    } else {
                        window.location.reload();
                    }
                });
            });
        </script>

        <!-- Existing card wrapper (optional) -->
        <div class="row">
            <div class="my-5 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <?php
                        if (isset($success)) echo $success;
                        if (isset($error5)) echo $error5;
                        ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php require ("footer.php")?>
