<?php require("header.php"); ?>

<main class="flex-1 px-2 py-2 md:p-4 pb-20 md:pb-6 overflow-hidden" x-data="{ tab: 'referrals' }">

    <div class="bg-[#0F0A1F] rounded-2xl">
        <!-- Tabs -->
        <div class="flex pt-2 pl-2">
            <button @click="tab = 'referrals'"
                :class="tab === 'referrals' ? 'bg-[#2FE6DE]/10 text-[#2FE6DE]' : 'hover:bg-[#1A1428] text-gray-400 hover:text-[#2FE6DE]'"
                class="flex-1 flex items-center justify-center gap-2 px-4 py-3 rounded-xl transition-colors">
                <i class="fas fa-users text-sm"></i>
                My Referrals
            </button>
            <button @click="tab = 'summary'"
                :class="tab === 'summary' ? 'bg-[#2FE6DE]/10 text-[#2FE6DE]' : 'hover:bg-[#1A1428] text-gray-400 hover:text-[#2FE6DE]'"
                class="flex-1 flex items-center justify-center gap-2 px-4 py-3 rounded-xl transition-colors">
                <i class="fas fa-chart-pie text-sm"></i>
                Summary
            </button>
        </div>

        <!-- Referred Users Section -->
        <div class="p-6 space-y-4" x-show="tab === 'referrals'">
            <?php
            $user_id = $_SESSION['SESS_USERID'] ?? 0;

            // Get all users who registered through your referral
            $stmt = $pdo->prepare("SELECT * FROM logins WHERE ref = :ref ORDER BY start DESC");
            $stmt->execute(['ref' => $user_id]);
            $referredUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
            ?>

            <?php if (count($referredUsers) === 0): ?>
                <div class="text-center text-gray-400">No users have registered through your link yet.</div>
            <?php else: ?>
                <div class="space-y-4">
                    <?php foreach ($referredUsers as $user): ?>
                        <div class="bg-[#1A1428] rounded-xl p-4 hover:bg-[#2A243B] transition-colors">
                            <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                                <div class="flex items-center gap-4">
                                    <div class="bg-[#2FE6DE]/10 p-3 rounded-xl">
                                        <i class="fas fa-user text-[#2FE6DE] text-xl"></i>
                                    </div>
                                    <div>
                                        <div class="text-lg font-medium"><?= htmlspecialchars($user['fullname'] ?: $user['username']) ?></div>
                                        <div class="text-sm text-gray-400"><?= htmlspecialchars($user['email']) ?></div>
                                        <div class="text-sm text-gray-400"><?= htmlspecialchars($user['phone']) ?></div>
                                        <div class="text-xs text-gray-500">Joined: <?= date("M d, Y h:i A", strtotime($user['start'])) ?></div>
                                    </div>
                                </div>
                                <div class="flex flex-col items-end gap-2">
                                    <div class="text-sm text-gray-400">Invest ID: <?= htmlspecialchars($user['invest_id']) ?></div>
                                    <div class="text-sm text-gray-400">Total Investment: <?= number_format($user['invest'], 2) ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Summary Section -->
        <div class="p-6 space-y-4" x-show="tab === 'summary'" x-cloak>
            <?php
            $totalReferrals = count($referredUsers);
            $totalInvestment = array_sum(array_column($referredUsers, 'invest'));
            ?>
            <div class="bg-[#1A1428] rounded-xl p-6 text-center">
                <div class="text-lg text-gray-400">Total Referred Users</div>
                <div class="text-3xl font-bold text-[#2FE6DE]"><?= $totalReferrals ?></div>
            </div>
            <div class="bg-[#1A1428] rounded-xl p-6 text-center">
                <div class="text-lg text-gray-400">Total Investment by Referrals</div>
                <div class="text-3xl font-bold text-[#2FE6DE]"><?= number_format($totalInvestment, 2) ?></div>
            </div>
        </div>
    </div>

</main>

<?php require("footer.php"); ?>

<!-- Alpine.js -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
