<?php require ("header.php")?>



<main class="flex-1 px-2 py-2 md:p-4 pb-20 md:pb-6 overflow-hidden">
                    <div wire:snapshot="{&quot;data&quot;:{&quot;sort_value&quot;:&quot;All&quot;},&quot;memo&quot;:{&quot;id&quot;:&quot;vNBvrT5jSS3Dh0QKBP8U&quot;,&quot;name&quot;:&quot;user.investment-plan.my-plans&quot;,&quot;path&quot;:&quot;user\/investment\/my-plans&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;children&quot;:[],&quot;scripts&quot;:[],&quot;assets&quot;:[],&quot;errors&quot;:[],&quot;locale&quot;:&quot;en&quot;},&quot;checksum&quot;:&quot;2a0158f8745b25b1540a23d65c6984c5129e00b6ed791879073296473bfb5274&quot;}" wire:effects="[]" wire:id="vNBvrT5jSS3Dh0QKBP8U" class="w-full p-2 mb-5 md:mb-1">
    <div>
<!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->
</div>

    <div>
<!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->
</div>

    
    
    <div class="bg-[#0F0A1F] rounded-2xl p-6 mb-6">
        <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
            <div class="flex items-center gap-4">
                <div class="bg-[#1A1428] p-3 rounded-xl">
                    <i data-lucide="briefcase" class="w-6 h-6 text-[#2FE6DE]"></i>
                </div>
                <div>
                    <h1 class="text-xl font-medium">My Signal</h1>
                    <div class="flex items-center text-sm text-gray-400">
                        <a href="dashboard.php" class="hover:text-[#2FE6DE]">Dashboard</a>
                        <i data-lucide="chevron-right" class="w-4 h-4 mx-2"></i>
                        <span>My Plans</span>
                    </div>
                </div>
            </div>
            <div class="flex items-center gap-4">
                <select 
                    wire:model.live='sort_value'
                    class="bg-[#1A1428] border-2 border-[#2A243B] rounded-xl px-4 py-2 focus:outline-none focus:border-[#2FE6DE] text-sm">
                    <option value="All">All Plans</option>
                    <option value="active">Active</option>
                    <option value="cancelled">Cancelled/Inactive</option>
                    <option value="expired">Expired</option>
                </select>
                <div wire:loading wire:target="sort_value">
                    <i data-lucide="loader-2" class="w-5 h-5 text-[#2FE6DE] animate-spin"></i>
                </div>
            </div>
        </div>
    </div>

    
    <div class="mb-6">
        <!--[if BLOCK]><![endif]-->            <div class="flex items-center gap-3 bg-[#2FE6DE]/10 text-[#2FE6DE] p-4 rounded-xl">
                <i data-lucide="activity" class="w-5 h-5"></i>
                <span>Your Active Signal Trades</span>
            </div>
        <!--[if ENDBLOCK]><![endif]-->
    </div>

    
    <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
        <!--[if BLOCK]><![endif]-->          
        
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
                   
               <?php

// ✅ Fetch trades
$stmt = $pdo->prepare("SELECT * FROM trade WHERE log_id = :log_id ORDER BY id DESC");
$stmt->execute(["log_id" => $userId]);
$trades = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ✅ Helper for status
function tradeStatus($status, $expiry) {
    $now = time();
    if ($status == 1 && strtotime($expiry) > $now) {
        return ['Active', 'green-400'];
    } elseif ($status == 1 && strtotime($expiry) <= $now) {
        return ['Expired', 'red-400'];
    } elseif ($status == 2) {
        return ['Completed', 'blue-400'];
    } else {
        return ['Pending', 'yellow-400'];
    }
}
?>


    <?php foreach ($trades as $trade): 
        [$statusText, $statusColor] = tradeStatus($trade['status'], $trade['expirytime']);
    ?>
    <div class="bg-[#0F0A1F] rounded-2xl hover:shadow-lg hover:shadow-[#2FE6DE]/5 transition-all duration-300">
        
        <!-- Header -->
        <div class="p-6 border-b border-[#1A1428]">
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center gap-3">
                    <div class="bg-[#1A1428] p-2 rounded-lg">
                        <i data-lucide="trending-up" class="w-5 h-5 text-[#2FE6DE]"></i>
                    </div>
                    <h4 class="font-medium"><?= htmlspecialchars($trade['plan']) ?></h4>
                </div>
                <div class="flex items-center gap-2 px-3 py-1 rounded-full bg-<?= $statusColor ?>/10 text-<?= $statusColor ?> text-sm">
                    <i data-lucide="clock" class="w-4 h-4"></i>
                    <span><?= $statusText ?></span>
                </div>
            </div>
            <div class="flex items-baseline gap-2">
                <span class="text-2xl font-medium">
                    <?= htmlspecialchars($trade['user_cur']) ?><?= number_format($trade['invested'], 2) ?>
                </span>
                <span class="text-sm text-gray-400">Invested Amount</span>
            </div>
        </div>

        <!-- Body -->
        <div class="p-6 space-y-4">
            <div class="flex items-center gap-3">
                <div class="bg-[#1A1428] p-2 rounded-lg">
                    <i data-lucide="calendar" class="w-4 h-4 text-[#2FE6DE]"></i>
                </div>
                <div>
                    <div class="text-sm text-gray-400">Started</div>
                    <div><?= date("M d, Y H:i", strtotime($trade['entrytime'])) ?></div>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <div class="bg-[#1A1428] p-2 rounded-lg">
                    <i data-lucide="calendar-x" class="w-4 h-4 text-[#2FE6DE]"></i>
                </div>
                <div>
                    <div class="text-sm text-gray-400">Ends</div>
                    <div><?= date("M d, Y H:i", strtotime($trade['expirytime'])) ?></div>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <div class="bg-[#1A1428] p-2 rounded-lg">
                    <i data-lucide="activity" class="w-4 h-4 text-[#2FE6DE]"></i>
                </div>
                <div>
                    <div class="text-sm text-gray-400">Entry / Close</div>
                    <div><?= number_format($trade['entryrate'], 4) ?> → <?= number_format($trade['closerate'], 4) ?></div>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <div class="bg-[#1A1428] p-2 rounded-lg">
                    <i data-lucide="percent" class="w-4 h-4 text-[#2FE6DE]"></i>
                </div>
                <div>
                    <div class="text-sm text-gray-400">Win Rate</div>
                    <div><?= number_format($trade['Wrate'], 2) ?>%</div>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <div class="bg-[#1A1428] p-2 rounded-lg">
                    <i data-lucide="dollar-sign" class="w-4 h-4 text-[#2FE6DE]"></i>
                </div>
                <div>
                    <div class="text-sm text-gray-400">Profit / Loss</div>
                    <div class="<?= ($trade['returnr'] >= 0) ? 'text-green-400' : 'text-red-400' ?>">
                        <?= htmlspecialchars($trade['user_cur']) ?><?= number_format($trade['returnr'], 2) ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="p-6 border-t border-[#1A1428]">
            <a href="trade_details.php?id=<?= $trade['id'] ?>"
               class="flex items-center justify-between p-3 bg-[#1A1428] text-[#2FE6DE] rounded-xl hover:bg-[#2A243B] transition-colors group">
                <span>View Details</span>
                <i data-lucide="arrow-right" class="w-5 h-5 group-hover:translate-x-1 transition-transform"></i>
            </a>
        </div>
    </div>
    <?php endforeach; ?>
         
            
            
            
            
            
        <!--[if ENDBLOCK]><![endif]-->
    </div>
</div>
            </main>
   
   
   
   <?php require ("footer.php") ?>