<?php
require("header.php"); // Includes session + config.php + PDO ($pdo)

// --- LIVE TRADE SUBMISSION HANDLER ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'openTrade') {
    header('Content-Type: application/json');

    try {
        if (!isset($_SESSION['SESS_USERID'])) {
            throw new Exception("Session expired. Please log in again.");
        }

        $userId = $_SESSION['SESS_USERID'];

        // Get POST data
        $pair = trim($_POST['pair'] ?? '');
        $tp = floatval($_POST['tp'] ?? 0);
        $sl = floatval($_POST['sl'] ?? 0);
        $amount = floatval($_POST['amount'] ?? 0);
        $optionr = strtolower($_POST['optionr'] ?? '');
        $duration = $_POST['duration'] ?? '1m';
        $leverage = intval($_POST['leverage'] ?? 100);

        if (!$pair || !in_array($optionr, ['buy', 'sell']) || $amount <= 0) {
            throw new Exception("Invalid input values.");
        }

        // Get user info
        $stmt = $pdo->prepare("SELECT * FROM logins WHERE id = ?");
        $stmt->execute([$userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            throw new Exception("User not found.");
        }

        if ($user['balance'] < $amount) {
            throw new Exception("Insufficient balance.");
        }

        // Get pair info
        $pairStmt = $pdo->prepare("SELECT * FROM pairs WHERE symbol = ?");
        $pairStmt->execute([$pair]);
        $pairData = $pairStmt->fetch(PDO::FETCH_ASSOC);
        if (!$pairData) {
            throw new Exception("Invalid trading pair selected.");
        }

        // Get live rate
        $entryrate = getLiveMarketRate($pair);
        $entrytime = date('Y-m-d H:i:s');

        // Insert trade
        $insert = $pdo->prepare("
            INSERT INTO trade (
                log_id, signal_id, email, invest_id, system, tp, sl, plan, asset,
                signa, status, optionr, invested, user_cur, user_rate, entryrate,
                entrytime, leverage, date
            ) VALUES (
                :log_id, NULL, :email, :invest_id, 'livetrade', :tp, :sl, :plan, :asset,
                'nosignal', 1, :optionr, :invested, :user_cur, :user_rate, :entryrate,
                :entrytime, :leverage, NOW()
            )
        ");
        $insert->execute([
            'log_id' => $userId,
            'email' => $user['email'],
            'invest_id' => $user['invest_id'],
            'tp' => $tp,
            'sl' => $sl,
            'plan' => $pairData['type'],
            'asset' => $pairData['symbol'],
            'optionr' => $optionr,
            'invested' => $amount,
            'user_cur' => $user['cur_shot_name'],
            'user_rate' => $user['cur_rate'],
            'entryrate' => $entryrate,
            'entrytime' => $entrytime,
            'leverage' => $leverage
        ]);

        // Deduct from balance
        $pdo->prepare("UPDATE logins SET balance = balance - :amt WHERE id = :id")
            ->execute(['amt' => $amount, 'id' => $userId]);

        echo json_encode(['success' => true, 'message' => 'Trade started successfully!']);
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    exit;
}

// --- HELPER FUNCTION TO SIMULATE LIVE RATE ---
function getLiveMarketRate($symbol) {
    $mockRates = [
        "BTC/USD" => 101500.00,
        "ETH/USD" => 2350.00,
        "XAU/USD" => 1950.50
    ];
    return $mockRates[$symbol] ?? 1000.00;
}
?>

<?php require("live_trade_ui.php"); // separate UI file for clarity ?>
