<?php
require("header.php"); // includes session + config.php + $pdo

// --- Helper function to simulate live market rate ---
function getLiveMarketRate($symbol) {
    $mockRates = [
        "BTC/USD" => 101500.00,
        "ETH/USD" => 2350.00,
        "XAU/USD" => 1950.50
    ];
    return $mockRates[$symbol] ?? 1000.00;
}

// --- Fetch user profit and win rate ---
$winRate = 0;
$totalProfit = 0.00;
$email = '';

if (isset($_SESSION['SESS_USERID'])) {
    $userId = $_SESSION['SESS_USERID'];

    $profitStmt = $pdo->prepare("SELECT email, iprofit FROM logins WHERE id = ?");
    $profitStmt->execute([$userId]);
    $profitRow = $profitStmt->fetch(PDO::FETCH_ASSOC);
    if ($profitRow) {
        $email = $profitRow['email'];
        $iprofit = (float)$profitRow['iprofit'];
        $totalProfit = $iprofit;
    }

    $winStmt = $pdo->prepare("
        SELECT ROUND((SUM(CASE WHEN user_iprofit > 0 THEN 1 ELSE 0 END)/COUNT(*))*100, 2) AS Wrate
        FROM trade
        WHERE log_id = ? AND system='livetrade' AND status=1
    ");
    $winStmt->execute([$userId]);
    $winRow = $winStmt->fetch(PDO::FETCH_ASSOC);
    if ($winRow && $winRow['Wrate'] !== null) {
        $winRate = $winRow['Wrate'];
    }
}

$cur_symbol = "$"; // Currency symbol
$cur_rate = 1;     // Currency conversion rate placeholder
?>


<main class="flex-1 px-2 py-2 md:p-4 pb-20 md:pb-6 overflow-hidden">
            <div class="min-h-screen bg-[#0F0A1F]">
                
               
    
    <div class="sticky top-0 z-30 bg-[#0F0A1F]/90 backdrop-blur-md border-b border-gray-800/50 shadow-lg">
        
      <form id="tradeForm" action="trade_execute.php" method="POST">
  <input type="hidden" name="email" value="<?= htmlspecialchars($email) ?>">

        <div class="w-full mx-auto px-2 md:px-4 max-w-full overflow-hidden">
            <div class="flex items-center justify-between h-14 md:h-16 gap-2">
                
                <div class="relative flex-shrink-0">
                    
                    
              
             <div class="flex items-center gap-2 md:gap-3 text-xs">
    <div class="px-2 py-1 bg-[#1A1428] rounded-lg whitespace-nowrap">
        <span class="text-gray-400">Vol:</span>
        <span id="marketVolume" class="break-all"><?= $cur_symbol ?>0</span>
    </div>
    <div class="px-2 py-1 bg-[#1A1428] rounded-lg whitespace-nowrap">
        <span class="text-gray-400">High:</span>
        <span id="marketHigh" class="text-green-500 break-all"><?= $cur_symbol ?>0</span>
    </div>
    <div class="px-2 py-1 bg-[#1A1428] rounded-lg whitespace-nowrap">
        <span class="text-gray-400">Low:</span>
        <span id="marketLow" class="text-red-500 break-all"><?= $cur_symbol ?>0</span>
    </div>
    <div class="px-2 py-1 bg-[#1A1428] rounded-lg whitespace-nowrap">
        <span class="text-gray-400">Open:</span>
        <span id="marketOpen" class="text-blue-500 break-all"><?= $cur_symbol ?>0</span>
    </div>
    <div class="px-2 py-1 bg-[#1A1428] rounded-lg whitespace-nowrap">
        <span class="text-gray-400">Cap:</span>
        <span id="marketCap" class="text-yellow-500 break-all"><?= $cur_symbol ?>0</span>
    </div>
</div>


                
            </div>
        </div>
    </div>

    
    <div class="w-full mx-auto px-1 md:px-4 py-2 md:py-4 max-w-full overflow-hidden">
       
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-2 md:gap-4">
            
            <div class="lg:col-span-8 bg-gradient-to-br from-[#1A1428] to-[#0F0A1F] rounded-xl shadow-xl border border-gray-800/30 overflow-hidden">
                
                <div class="p-3 md:p-4 border-b border-gray-800/30 flex flex-col gap-3">
                    <div class="flex items-center gap-2 md:gap-3 min-w-0">
                    
                    
              <!-- Selected Pair Display -->
<div id="selectedPairDisplay"
    class="flex items-center gap-2 px-2 md:px-3 py-1 md:py-1.5 rounded-lg bg-[#0F0A1F]/50 border border-gray-800/30 flex-shrink-0">
    <img id="pairIcon" src="h" alt="No pair selected" class="w-5 h-5 md:w-6 md:h-6 rounded-full">
    <span id="pairName" class="font-medium text-sm md:text-base">No pair selected</span>
</div>

<!-- Market Info Boxes -->
<div class="grid grid-cols-3 gap-3 md:gap-3 mt-3 md:mt-4">
    <!-- Market Type -->
    <div class="p-2 md:p-3 bg-[#0F0A1F]/50 rounded-lg border border-gray-800/30">
        <span class="text-xs text-gray-400 block mb-1">Market Type</span>
        <span id="marketType" class="text-[#2FE6DE] font-medium text-sm md:text-base break-all">—</span>
    </div>

    <!-- Buying Price -->
    <div class="p-2 md:p-3 bg-[#0F0A1F]/50 rounded-lg border border-gray-800/30">
        <span class="text-xs text-gray-400 block mb-1">Buying @</span>
        <span class="text-green-500 font-medium text-sm md:text-base break-all" id="buyPrice">
            <?= $cur_symbol ?>19,007.00
        </span>
    </div>

    <!-- Selling Price -->
    <div class="p-2 md:p-3 bg-[#0F0A1F]/50 rounded-lg border border-gray-800/30">
        <span class="text-xs text-gray-400 block mb-1">Selling @</span>
        <span class="text-red-500 font-medium text-sm md:text-base break-all" id="sellPrice">
            <?= $cur_symbol ?>17,860.00
        </span>
    </div>
</div>

                      
                
                        
                    </div>
                    
                  
                  
                </div>

                
                <div id="tradingview_chart" style="height:600px;"></div>
                
                
               
            </div>

            
            <div class="lg:col-span-4 space-y-3 md:space-y-4">
                
                <div class="bg-gradient-to-br from-[#1A1428] to-[#0F0A1F] rounded-xl p-3 md:p-4 shadow-xl border border-gray-800/30">
                    <div class="flex items-center justify-between mb-3 md:mb-4">
                        <h3 class="text-base md:text-lg font-medium flex items-center gap-2">
                            <i class="fas fa-wallet text-[#2FE6DE] text-sm md:text-base"></i>
                            <span>P/L Balance</span>
                                                            <span class="px-2 py-1 text-xs bg-green-500/20 text-green-500 rounded-full">Live</span>
                                                    </h3>
                        <div class="text-xs text-gray-400">Available</div>
                    </div>
                    <div class="text-xl md:text-2xl font-bold break-all" >
                        <?= $cur_symbol . number_format($iprofit * $cur_rate, 2) ?>
                    </div>
                    
                    
                                            <div class="mt-3 md:mt-4 p-3 bg-[#0F0A1F]/50 border border-gray-800/30 rounded-lg">
                            <div class="flex items-center justify-between gap-2">
                                <div class="min-w-0 flex-1">
                                    <div class="text-sm font-medium text-green-500">Live Trading Mode</div>
                                    <div class="text-xs text-gray-400">Trading with real funds</div>
                                </div>
                                <button onclick="toggleDemoMode(true)" 
                                    class="px-2 md:px-3 py-1.5 bg-yellow-500/20 text-yellow-500 text-xs rounded-lg hover:bg-yellow-500/30 transition-colors whitespace-nowrap">
                                    Try Demo
                                </button>
                            </div>
                        </div>
                    
                    
                    
                </div>
                
                
                <div class="bg-gradient-to-br from-[#1A1428] to-[#0F0A1F] rounded-xl p-3 md:p-4 shadow-xl border border-gray-800/30">
                   
                   
                   
                   <!-- Pips & Leverage Controls -->
<div id="pipLeverageControls" class="mb-4">

  <label class="block text-gray-400 mb-2 flex items-center">
    <i class="fas fa-arrows-alt-v mr-2 text-[#2FE6DE]"></i>
    Select Pips & Leverage
  </label>

  <div class="flex gap-2 mb-3 items-center">
    <select id="pipSelect" name="pip" class="bg-[#0F0A1F]/50 border border-gray-800/50 rounded px-2 text-white text-xs w-24 focus:border-[#2FE6DE] focus:outline-none">
      <option value="5">5 Pips</option>
      <option value="10">10 Pips</option>
      <option value="20">20 Pips</option>
      <option value="25">25 Pips</option>
      <option value="50">50 Pips</option>
      <option value="100">100 Pips</option>
      <option value="200">200 Pips</option>
      <option value="500">500 Pips</option>
      <option value="1000">1000 Pips</option>
    </select>

    <select id="leverageSelect" name="leverage" class="bg-[#0F0A1F]/50 border border-gray-800/50 rounded px-2 text-white text-xs w-28 focus:border-[#2FE6DE] focus:outline-none">
      <option value="1">1:1</option>
      <option value="5">1:5</option>
      <option value="10">1:10</option>
      <option value="25">1:25</option>
      <option value="50">1:50</option>
      <option value="100">1:100</option>
      <option value="250">1:250</option>
      <option value="500">1:500</option>
      <option value="1000">1:1000</option>
    </select>
  </div>
</div>



                   
            <!-- Trading Pair Selection -->
            <div class="mb-4">
                <label for="pair" class="block text-gray-400 mb-2 flex items-center">
                    <i class="fas fa-exchange-alt mr-2 text-[#2FE6DE]"></i>
                    Select Trading Pair (Symbol)
                </label>
                <div class="relative">
                   <select id="pair" class="w-full bg-[#1A1428] text-white border border-gray-700 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]/50 appearance-none">
    <option value="">Select a pair</option>
    <?php
    $pairs = $pdo->query("SELECT * FROM pairs WHERE status=1 ORDER BY symbol")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($pairs as $p) {
        echo '<option 
            value="'.htmlspecialchars($p['symbol']).'" 
            data-icon="'.htmlspecialchars($p['icon']).'" 
            data-type="'.htmlspecialchars($p['type']).'">'.
            htmlspecialchars($p['symbol']).' ('.$p['type'].')</option>';
    }
    ?>
</select>

                    <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                        <i class="fas fa-chevron-down text-gray-400"></i>
                    </div>
                </div>
            </div>      
                   



                       
                        <br>
                        
                        
                        <label class="block text-sm text-gray-400 mb-2">Amount</label>
                        <div class="relative">
                            <span class="absolute left-3 md:left-4 top-1/2 -translate-y-1/2 text-gray-400"><?= $cur_symbol  ?></span>
                            <input
                                type="number"
                                id="tradeAmount" name="amount"
                                class="w-full bg-[#0F0A1F]/50 border-2 border-gray-800/50 rounded-lg pl-7 md:pl-8 pr-12 md:pr-16 py-2.5 md:py-3 text-white focus:outline-none focus:border-[#2FE6DE] text-sm md:text-base"
                                placeholder="Enter amount"
                                min="1">
                            <button
                                type="button"
                                id="maxAmount"
                                class="absolute right-3 md:right-4 top-1/2 -translate-y-1/2 text-[#2FE6DE] text-xs md:text-sm hover:underline">
                                MAX
                            </button>
                        </div>
                        <span id="amountError" class="text-sm text-red-500 mt-1 hidden"></span>
                    </div>













                    
                    <div class="grid grid-cols-4 gap-1.5 md:gap-2 mb-3 md:mb-4">
                                                <button
                            type="button"
                            class="quick-amount px-2 py-1.5 bg-[#0F0A1F]/50 rounded-lg border border-gray-800/50 text-xs md:text-sm text-gray-400 hover:border-[#2FE6DE] hover:text-[#2FE6DE] transition-colors"
                            data-amount="100">
                            <?= $cur_symbol ?>100
                        </button>
                                                <button
                            type="button"
                            class="quick-amount px-2 py-1.5 bg-[#0F0A1F]/50 rounded-lg border border-gray-800/50 text-xs md:text-sm text-gray-400 hover:border-[#2FE6DE] hover:text-[#2FE6DE] transition-colors"
                            data-amount="250">
                            <?= $cur_symbol ?>250
                        </button>
                                                <button
                            type="button"
                            class="quick-amount px-2 py-1.5 bg-[#0F0A1F]/50 rounded-lg border border-gray-800/50 text-xs md:text-sm text-gray-400 hover:border-[#2FE6DE] hover:text-[#2FE6DE] transition-colors"
                            data-amount="500">
                            <?= $cur_symbol ?>500
                        </button>
                                                <button
                            type="button"
                            class="quick-amount px-2 py-1.5 bg-[#0F0A1F]/50 rounded-lg border border-gray-800/50 text-xs md:text-sm text-gray-400 hover:border-[#2FE6DE] hover:text-[#2FE6DE] transition-colors"
                            data-amount="1000">
                            <?= $cur_symbol ?>1000
                        </button>
                                            </div>

                    
                   <div class="mb-4">
    <label class="block text-gray-400 mb-2">Select Duration</label>
    <div class="grid grid-cols-4 gap-2">
        <button type="button" class="duration-btn px-2 py-1.5 rounded-lg bg-[#0F0A1F]/50 text-xs text-gray-400 hover:bg-[#2FE6DE]/20" data-duration="1m">1m</button>
        <button type="button" class="duration-btn px-2 py-1.5 rounded-lg bg-[#0F0A1F]/50 text-xs text-gray-400 hover:bg-[#2FE6DE]/20" data-duration="5m">5m</button>
        <button type="button" class="duration-btn px-2 py-1.5 rounded-lg bg-[#0F0A1F]/50 text-xs text-gray-400 hover:bg-[#2FE6DE]/20" data-duration="15m">15m</button>
        <button type="button" class="duration-btn px-2 py-1.5 rounded-lg bg-[#0F0A1F]/50 text-xs text-gray-400 hover:bg-[#2FE6DE]/20" data-duration="30m">30m</button>
        <button type="button" class="duration-btn px-2 py-1.5 rounded-lg bg-[#0F0A1F]/50 text-xs text-gray-400 hover:bg-[#2FE6DE]/20" data-duration="1h">1h</button>
        <button type="button" class="duration-btn px-2 py-1.5 rounded-lg bg-[#0F0A1F]/50 text-xs text-gray-400 hover:bg-[#2FE6DE]/20" data-duration="4h">4h</button>
        <button type="button" class="duration-btn px-2 py-1.5 rounded-lg bg-[#0F0A1F]/50 text-xs text-gray-400 hover:bg-[#2FE6DE]/20" data-duration="1d">1d</button>
    </div>
</div>




   <!-- Trade Type Selector -->
<div class="mb-4">
    <label class="block text-gray-400 mb-2">Select Trade Type</label>
    <select id="tradeTypeSelect" class="w-full bg-[#0F0A1F]/50 border border-gray-800/50 rounded-lg px-3 py-2 text-white focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]/50">
         <option>Select Trade</option>
        <option value="normal">Normal Trade</option>
        <option value="limit">Trade Limit</option>
    </select>
</div>

<!-- Limit TP/SL Inputs -->
<div id="limitSettings" class="hidden transition-all duration-300">
  <div class="relative mb-3">
    <input type="number" id="takeprofit" name="tp"
      class="w-full bg-[#0F0A1F]/50 border-2 border-gray-800/50 rounded-lg pl-8 pr-12 py-2.5 text-white focus:outline-none focus:border-[#2FE6DE] text-sm md:text-base"
      placeholder="Take Profit" min="1">
    <button type="button"
      class="absolute right-3 top-1/2 -translate-y-1/2 text-[#22E57E] text-xs md:text-sm hover:underline">T-P</button>
  </div>

  <div class="relative mb-3">
    <input type="number" id="stoplose" name="sl"
      class="w-full bg-[#0F0A1F]/50 border-2 border-gray-800/50 rounded-lg pl-8 pr-12 py-2.5 text-white focus:outline-none focus:border-[#2FE6DE] text-sm md:text-base"
      placeholder="Stop Loss" min="1">
    <button type="button"
      class="absolute right-3 top-1/2 -translate-y-1/2 text-[#FF4D4D] text-xs md:text-sm hover:underline">S-L</button>
  </div>

  <!-- Activate Limit Trade Button -->
  <button id="activateLimitTrade" class="w-full bg-gradient-to-r from-yellow-400 to-yellow-500 text-black font-medium px-4 py-3 md:py-4 rounded-lg hover:brightness-110 transition-all shadow-lg shadow-yellow-400/30 text-sm md:text-base">
    Activate Trade
  </button>
</div>



<div class="p-3 md:p-4 bg-[#0F0A1F]/50 rounded-lg border border-gray-800/50 mb-3 md:mb-4">
    <div class="flex items-center justify-between mb-2">
        <span class="text-xs md:text-sm text-gray-400">Win Rate:</span>
        <span class="text-[#2FE6DE] px-2 py-0.5 rounded bg-[#2FE6DE]/10 text-xs md:text-sm">
            <?= number_format($winRate, 2) ?>%
        </span>
    </div>

    <div class="flex items-center justify-between mb-2 text-lg md:text-xl font-bold text-amber-400 break-all">
        <span class="text-xs md:text-sm text-gray-400">P/L Profit:</span>
        <span>
            <?= $cur_symbol . number_format($iprofit * $cur_rate, 2) ?>
            
        </span>
        
      
    </div>
</div>


<!-- Normal Buy/Sell Buttons -->
<div class="flex gap-4"  id="normalTradeButtons">
  <!-- Buy Button -->
  <button
    type="button"
    id="buyTrade"
    class="w-1/2 bg-gradient-to-r from-green-400 to-green-500 text-black font-medium px-4 py-3 md:py-4 rounded-lg hover:brightness-110 transition-all disabled:opacity-50 disabled:cursor-not-allowed shadow-lg shadow-green-400/30 text-sm md:text-base"
    disabled>
    <span id="buyButtonText">Buy</span>
    <span id="buyButtonLoader" class="hidden">
      <i class="fas fa-spinner fa-spin"></i> Processing...
    </span>
  </button>

  <!-- Sell Button -->
  <button
    type="button"
    id="sellTrade"
    class="w-1/2 bg-gradient-to-r from-red-400 to-red-500 text-black font-medium px-4 py-3 md:py-4 rounded-lg hover:brightness-110 transition-all disabled:opacity-50 disabled:cursor-not-allowed shadow-lg shadow-red-400/30 text-sm md:text-base"
    disabled>
    <span id="sellButtonText">Sell</span>
    <span id="sellButtonLoader" class="hidden">
      <i class="fas fa-spinner fa-spin"></i> Processing...
    </span>
  </button>
</div>


                </div>
            </div>
        </div></div>
       
        </form>
        </div>

        
        
<style>
.scrollbar-hide::-webkit-scrollbar {
    display: none;
}
.scrollbar-hide {
    -ms-overflow-style: none;
    scrollbar-width: none;
}
.scale-95 {
    transform: scale(0.95);
}
.scale-100 {
    transform: scale(1);
}
.opacity-0 {
    opacity: 0;
}
.opacity-100 {
    opacity: 1;
}
</style>


<script>
// --- TradingView Chart Loader ---
let tvWidget;
function loadTradingViewChart(symbol = "BTCUSD") {
    if (tvWidget) tvWidget.remove();
    tvWidget = new TradingView.widget({
        autosize: true,
        symbol: symbol,
        interval: "1",
        timezone: "Etc/UTC",
        theme: "dark",
        style: "1",
        locale: "en",
        toolbar_bg: "#0F0A1F",
        enable_publishing: false,
        allow_symbol_change: false,
        container_id: "tradingview_chart"
    });
}

// --- Load chart when pair changes ---
document.getElementById('pair').addEventListener('change', e => {
    const selectedOption = e.target.selectedOptions[0];
    const symbol = selectedOption.value;
    const icon = selectedOption.getAttribute('data-icon');
    const type = selectedOption.getAttribute('data-type') || '';
    const symbolClean = symbol.replace('/', '');

    // Load TradingView chart
    if (symbol) {
        loadTradingViewChart(symbolClean);
    }

    // Update displayed info
    const pairNameEl = document.getElementById('pairName');
    const pairIconEl = document.getElementById('pairIcon');
    const marketTypeEl = document.getElementById('marketType');

    if (symbol) {
        pairNameEl.textContent = symbol;
        marketTypeEl.textContent = type;
        pairIconEl.src = icon || 'assets/icons/default.png';
        pairIconEl.alt = symbol;
    } else {
        pairNameEl.textContent = "No pair selected";
        marketTypeEl.textContent = "";
        pairIconEl.src = "assets/icons/default.png";
        pairIconEl.alt = "No pair selected";
    }

    // Refresh market data for selected pair
    refreshMarketData();
});






// --- Fetch & update live market data ---
function refreshMarketData() {
    const pairEl = document.getElementById('pair');
    const pair = pairEl && pairEl.value ? pairEl.value : '';
    if (!pair) return;

    fetch('market_data.php?pair=' + encodeURIComponent(pair))
        .then(res => res.json())
        .then(data => {
            if (!data.success) return;

            const cur = data.cur_symbol || "";

            // Update top market info boxes
            document.getElementById('marketVolume').textContent = cur + data.volume;
            document.getElementById('marketHigh').textContent   = cur + data.high;
            document.getElementById('marketLow').textContent    = cur + data.low;
            document.getElementById('marketOpen').textContent   = cur + data.open;
            document.getElementById('marketCap').textContent    = cur + data.marketCap;

            // Update buy/sell display with close price
            if (document.getElementById('buyPrice')) {
                document.getElementById('buyPrice').textContent = cur + data.close;
            }
            if (document.getElementById('sellPrice')) {
                document.getElementById('sellPrice').textContent = cur + data.close;
            }
        })
        .catch(error => console.error("Error fetching market data:", error));
}

// Auto-refresh every 5s
refreshMarketData();
setInterval(refreshMarketData, 5000);

// Initial chart
loadTradingViewChart("BTCUSD");
















// --- SMART LIMIT ORDER LOGIC ---
let selectedLimitType = null;
let currentOpenPrice = 0;

// Elements
const limitControls = document.getElementById('limitControls');
const limitSettings = document.getElementById('limitSettings');
const buyLimitBtn = document.getElementById('buyLimitBtn');
const sellLimitBtn = document.getElementById('sellLimitBtn');
const tpInput = document.getElementById('takeprofit');
const slInput = document.getElementById('stoplose');

// Auto-calc helper
function calculateLimits(type) {
  if (!currentOpenPrice) return;
  const diffPercent = 0.5; // adjust difference here (0.5% default)
  let tp = 0, sl = 0;

  if (type === 'buy') {
    tp = currentOpenPrice * (1 + diffPercent / 100);
    sl = currentOpenPrice * (1 - diffPercent / 100);
  } else if (type === 'sell') {
    tp = currentOpenPrice * (1 - diffPercent / 100);
    sl = currentOpenPrice * (1 + diffPercent / 100);
  }

  tpInput.value = tp.toFixed(2);
  slInput.value = sl.toFixed(2);
}

// Reset visual states
function resetLimitButtons() {
  [buyLimitBtn, sellLimitBtn].forEach(btn => {
    btn.classList.remove('border-green-400', 'text-green-400', 'border-red-400', 'text-red-400');
    btn.classList.add('text-gray-400');
  });
}

// Select Buy Limit
buyLimitBtn.addEventListener('click', () => {
  selectedLimitType = 'buy';
  resetLimitButtons();
  buyLimitBtn.classList.add('border-green-400', 'text-green-400');
  limitSettings.classList.remove('hidden');
  calculateLimits('buy');
});

// Select Sell Limit
sellLimitBtn.addEventListener('click', () => {
  selectedLimitType = 'sell';
  resetLimitButtons();
  sellLimitBtn.classList.add('border-red-400', 'text-red-400');
  limitSettings.classList.remove('hidden');
  calculateLimits('sell');
});

// When pair changes or data refreshes, auto-enable limit options
function updateLimitPrice() {
  const openEl = document.getElementById('marketOpen');
  if (!openEl) return;
  const val = parseFloat(openEl.textContent.replace(/[^0-9.]/g, ''));
  if (!isNaN(val)) {
    currentOpenPrice = val;
    limitControls.classList.remove('hidden');
    if (selectedLimitType) calculateLimits(selectedLimitType);
  }
}

// Hook this into your refresh function
const originalRefresh = refreshMarketData;
refreshMarketData = function() {
  originalRefresh();
  setTimeout(updateLimitPrice, 1000); // update limits after live data updates
};






</script>

 <script>
document.addEventListener("DOMContentLoaded", function () {
  let selectedPips = 10; // default
  let selectedLimitType = null;
  let currentOpenPrice = 0;

  const pipSelect = document.getElementById("pipSelect");
  const leverageSelect = document.getElementById("leverageSelect");
  const tpInput = document.getElementById("takeprofit");
  const slInput = document.getElementById("stoplose");
  const limitSettings = document.getElementById("limitSettings");
  const buyLimitBtn = document.getElementById("buyLimitBtn");
  const sellLimitBtn = document.getElementById("sellLimitBtn");

  // --- Recalculate TP / SL
  function recalcLimits() {
    if (!currentOpenPrice || !selectedPips || !selectedLimitType) return;

    const pipValue = currentOpenPrice > 1000 ? 1 : 0.0001;

    let tp, sl;
    if (selectedLimitType === "buy") {
      tp = currentOpenPrice + selectedPips * pipValue;
      sl = currentOpenPrice - selectedPips * pipValue;
    } else if (selectedLimitType === "sell") {
      tp = currentOpenPrice - selectedPips * pipValue;
      sl = currentOpenPrice + selectedPips * pipValue;
    }

    tpInput.value = tp.toFixed(5);
    slInput.value = sl.toFixed(5);
  }

  // --- Handle pip selection change
  pipSelect.addEventListener("change", function () {
    selectedPips = parseFloat(this.value);
    recalcLimits();
  });

  // --- Handle leverage selection change
  leverageSelect.addEventListener("change", function () {
    // Just store value or update form input if needed
    const leverage = parseInt(this.value);
    console.log("Selected leverage:", leverage);
  });

  // --- Limit-type buttons
  function resetLimitButtons() {
    [buyLimitBtn, sellLimitBtn].forEach((btn) => {
      btn.classList.remove("border-green-400", "text-green-400", "border-red-400", "text-red-400");
      btn.classList.add("text-gray-400");
    });
  }

  buyLimitBtn.addEventListener("click", () => {
    selectedLimitType = "buy";
    resetLimitButtons();
    buyLimitBtn.classList.add("border-green-400", "text-green-400");
    limitSettings.classList.remove("hidden");
    recalcLimits();
  });

  sellLimitBtn.addEventListener("click", () => {
    selectedLimitType = "sell";
    resetLimitButtons();
    sellLimitBtn.classList.add("border-red-400", "text-red-400");
    limitSettings.classList.remove("hidden");
    recalcLimits();
  });

  // --- Update current price
  function updateOpenPrice() {
    const openEl = document.getElementById("marketOpen");
    if (!openEl) return;
    const val = parseFloat(openEl.textContent.replace(/[^0-9.]/g, ""));
    if (!isNaN(val) && val > 0) {
      currentOpenPrice = val;
      recalcLimits();
    }
  }

  // Hook into your existing refreshMarketData
  const originalRefresh = window.refreshMarketData;
  window.refreshMarketData = function () {
    originalRefresh();
    setTimeout(updateOpenPrice, 500);
  };

  setTimeout(updateOpenPrice, 800);
});




document.addEventListener("DOMContentLoaded", function () {

  // --- MAX Amount Button ---
  const maxBtn = document.getElementById("maxAmount");
  const amountInput = document.getElementById("tradeAmount");
  const walletBalanceEl = document.getElementById("walletBalance");

  maxBtn.addEventListener("click", () => {
    let balance = parseFloat(walletBalanceEl.textContent.replace(/[^0-9.]/g, ""));
    if (!isNaN(balance)) {
      amountInput.value = balance.toFixed(2);
    }
  });

  // --- Quick Amount Buttons ---
  const quickBtns = document.querySelectorAll(".quick-amount");
  quickBtns.forEach(btn => {
    btn.addEventListener("click", () => {
      const val = parseFloat(btn.getAttribute("data-amount"));
      if (!isNaN(val)) {
        amountInput.value = val.toFixed(2);
      }
    });
  });

  // --- Duration / Timeframe Buttons ---
  const durationBtns = document.querySelectorAll(".duration-btn");
  durationBtns.forEach(btn => {
    btn.addEventListener("click", () => {
      // Remove active styles from all
      durationBtns.forEach(b => b.classList.remove("border-[#2FE6DE]", "text-[#2FE6DE]"));
      durationBtns.forEach(b => b.classList.add("text-gray-400", "border-transparent"));

      // Add active style to clicked button
      btn.classList.add("border-[#2FE6DE]", "text-[#2FE6DE]");
      btn.classList.remove("text-gray-400", "border-transparent");

      // Store selected duration (optional, for trade submission)
      const selectedDuration = btn.getAttribute("data-duration");
      console.log("Selected Duration:", selectedDuration);
    });
  });

  // --- Timeframe Buttons ---
  const timeframeBtns = document.querySelectorAll(".timeframe-btn");
  timeframeBtns.forEach(btn => {
    btn.addEventListener("click", () => {
      // Remove active styles
      timeframeBtns.forEach(b => b.classList.remove("text-white", "border-gray-600"));
      timeframeBtns.forEach(b => b.classList.add("text-gray-400", "border-gray-800/30"));

      // Add active styles to clicked button
      btn.classList.add("text-white", "border-gray-600");
      btn.classList.remove("text-gray-400", "border-gray-800/30");

      // Optional: trigger chart update based on timeframe
      const tf = btn.getAttribute("data-timeframe");
      console.log("Selected Timeframe:", tf);
    });
  });

});


</script>


<script>
document.addEventListener("DOMContentLoaded", function() {
    const buyBtn = document.getElementById("buyTrade");
    const sellBtn = document.getElementById("sellTrade");
    const amountInput = document.getElementById("tradeAmount");
    const pairSelect = document.getElementById("pair");
    const tpInput = document.getElementById("takeprofit");
    const slInput = document.getElementById("stoplose");
    const leverageSelect = document.getElementById("leverageSelect");
    const durationBtns = document.querySelectorAll(".duration-btn");

    let selectedDuration = "1m"; // default
    durationBtns.forEach(btn => {
        btn.addEventListener("click", () => {
            durationBtns.forEach(b => b.classList.remove("border-[#2FE6DE]", "text-[#2FE6DE]"));
            durationBtns.forEach(b => b.classList.add("text-gray-400", "border-transparent"));
            btn.classList.add("border-[#2FE6DE]", "text-[#2FE6DE]");
            selectedDuration = btn.getAttribute("data-duration");
        });
    });

    function toggleTradeButtons() {
        const hasAmount = parseFloat(amountInput.value) > 0;
        const hasPair = pairSelect.value !== "";
        buyBtn.disabled = !hasAmount || !hasPair;
        sellBtn.disabled = !hasAmount || !hasPair;
    }

    amountInput.addEventListener("input", toggleTradeButtons);
    pairSelect.addEventListener("change", toggleTradeButtons);

    function submitTrade(action) {
        const amount = parseFloat(amountInput.value);
        const pair = pairSelect.value;
        const tp = parseFloat(tpInput.value) || 0; // optional
        const sl = parseFloat(slInput.value) || 0; // optional
        const leverage = parseInt(leverageSelect.value) || 100;

        if (!pair) return alert("Please select a trading pair.");
        if (!amount || amount <= 0) return alert("Please enter a valid amount.");

        const btn = action === "buy" ? buyBtn : sellBtn;
        const btnText = btn.querySelector("span:first-child");
        const btnLoader = btn.querySelector("span:last-child");

        btn.disabled = true;
        btnText.classList.add("hidden");
        btnLoader.classList.remove("hidden");

        fetch("", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: new URLSearchParams({
                action: "openTrade",
                optionr: action,
                amount: amount,
                pair: pair,
                tp: tp,        // 0 means continue until user stops
                sl: sl,        // 0 means continue until user stops
                duration: selectedDuration,
                leverage: leverage
            })
        })
        .then(res => res.json())
        .then(data => {
            btn.disabled = false;
            btnText.classList.remove("hidden");
            btnLoader.classList.add("hidden");

            if (data.success) {
                alert(data.message);
                amountInput.value = "";
                toggleTradeButtons(); // disable buttons after clearing amount
            } else {
                alert(data.message);
            }
        })
        .catch(err => {
            btn.disabled = false;
            btnText.classList.remove("hidden");
            btnLoader.classList.add("hidden");
            console.error(err);
            alert("Trade failed. Please try again.");
        });
    }

    buyBtn.addEventListener("click", () => submitTrade("buy"));
    sellBtn.addEventListener("click", () => submitTrade("sell"));
});
</script>



<script>
document.addEventListener("DOMContentLoaded", function() {
    const buyBtn = document.getElementById("buyTrade");
    const sellBtn = document.getElementById("sellTrade");
    const amountInput = document.getElementById("tradeAmount");
    const pairSelect = document.getElementById("pair");
    const tpInput = document.getElementById("takeprofit");
    const slInput = document.getElementById("stoplose");
    const leverageSelect = document.getElementById("leverageSelect");
    const buyLimitBtn = document.getElementById("buyLimitBtn");
    const sellLimitBtn = document.getElementById("sellLimitBtn");
    const limitSettings = document.getElementById("limitSettings");
    const limitControls = document.getElementById("limitControls");
    const limitModeSwitch = document.getElementById("limitModeSwitch");

    let selectedDuration = "1m";
    let selectedLimitType = null;

    // Toggle limit mode
    limitModeSwitch.addEventListener("change", () => {
        if (limitModeSwitch.checked) {
            limitControls.classList.remove("hidden");
            limitSettings.classList.add("hidden");
            buyBtn.disabled = false;
            sellBtn.disabled = false;
        } else {
            limitControls.classList.add("hidden");
            limitSettings.classList.remove("hidden");
            selectedLimitType = null;
            resetLimitButtons();
        }
    });

    function resetLimitButtons() {
        [buyLimitBtn, sellLimitBtn].forEach(btn => {
            btn.classList.remove("border-green-400", "text-green-400", "border-red-400", "text-red-400");
            btn.classList.add("text-gray-400");
        });
    }

    // Select Limit Type
    buyLimitBtn.addEventListener("click", () => {
        selectedLimitType = "buy";
        resetLimitButtons();
        buyLimitBtn.classList.add("border-green-400", "text-green-400");
        limitSettings.classList.remove("hidden");
    });
    sellLimitBtn.addEventListener("click", () => {
        selectedLimitType = "sell";
        resetLimitButtons();
        sellLimitBtn.classList.add("border-red-400", "text-red-400");
        limitSettings.classList.remove("hidden");
    });

    // Enable/disable Buy/Sell buttons based on amount & pair
    function toggleTradeButtons() {
        const hasAmount = parseFloat(amountInput.value) > 0;
        const hasPair = pairSelect.value !== "";
        buyBtn.disabled = !hasAmount || !hasPair;
        sellBtn.disabled = !hasAmount || !hasPair;
    }
    amountInput.addEventListener("input", toggleTradeButtons);
    pairSelect.addEventListener("change", toggleTradeButtons);

    // Submit trade
    function submitTrade(action) {
        const amount = parseFloat(amountInput.value);
        const pair = pairSelect.value;
        const tp = parseFloat(tpInput.value) || 0;
        const sl = parseFloat(slInput.value) || 0;
        const leverage = parseInt(leverageSelect.value) || 100;

        if (!pair) return alert("Please select a trading pair.");
        if (!amount || amount <= 0) return alert("Please enter a valid amount.");

        const btn = action === "buy" ? buyBtn : sellBtn;
        const btnText = btn.querySelector("span:first-child");
        const btnLoader = btn.querySelector("span:last-child");

        btn.disabled = true;
        btnText.classList.add("hidden");
        btnLoader.classList.remove("hidden");

        // Determine if we use limit type or normal
        const finalOption = (limitModeSwitch.checked && selectedLimitType) ? selectedLimitType : action;

        fetch("", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: new URLSearchParams({
                action: "openTrade",
                optionr: finalOption,
                amount: amount,
                pair: pair,
                tp: tp,
                sl: sl,
                duration: selectedDuration,
                leverage: leverage
            })
        })
        .then(res => res.json())
        .then(data => {
            btn.disabled = false;
            btnText.classList.remove("hidden");
            btnLoader.classList.add("hidden");

            if (data.success) {
                alert(data.message);
                amountInput.value = "";
                toggleTradeButtons();
                if(limitModeSwitch.checked) {
                    selectedLimitType = null;
                    resetLimitButtons();
                    limitSettings.classList.add("hidden");
                }
            } else {
                alert(data.message);
            }
        })
        .catch(err => {
            btn.disabled = false;
            btnText.classList.remove("hidden");
            btnLoader.classList.add("hidden");
            console.error(err);
            alert("Trade failed. Please try again.");
        });
    }

    buyBtn.addEventListener("click", () => submitTrade("buy"));
    sellBtn.addEventListener("click", () => submitTrade("sell"));
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const tradeTypeSelect = document.getElementById("tradeTypeSelect");
    const limitSettings = document.getElementById("limitSettings");
    const normalTradeButtons = document.getElementById("normalTradeButtons");
    const buyTradeBtn = document.getElementById("buyTrade");
    const sellTradeBtn = document.getElementById("sellTrade");

    tradeTypeSelect.addEventListener("change", () => {
        if (tradeTypeSelect.value === "limit") {
            // Show TP/SL inputs
            limitSettings.classList.remove("hidden");
            // Disable normal buy/sell buttons
            buyTradeBtn.disabled = true;
            sellTradeBtn.disabled = true;
        } else {
            // Hide TP/SL inputs
            limitSettings.classList.add("hidden");
            // Enable normal buy/sell buttons
            buyTradeBtn.disabled = false;
            sellTradeBtn.disabled = false;
        }
    });
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const tradeTypeSelect = document.getElementById("tradeTypeSelect");
    const limitSettings = document.getElementById("limitSettings");
    const normalTradeButtons = document.getElementById("normalTradeButtons");
    const buyTradeBtn = document.getElementById("buyTrade");
    const sellTradeBtn = document.getElementById("sellTrade");
    const durationButtons = document.querySelectorAll(".duration-btn");
    let selectedDuration = "1m"; // Default duration

    // Handle trade type selection
    tradeTypeSelect.addEventListener("change", () => {
        if (tradeTypeSelect.value === "limit") {
            limitSettings.classList.remove("hidden");
            buyTradeBtn.disabled = true;
            sellTradeBtn.disabled = true;
        } else {
            limitSettings.classList.add("hidden");
            buyTradeBtn.disabled = false;
            sellTradeBtn.disabled = false;
        }
    });

    // Handle duration selection
    durationButtons.forEach(btn => {
        btn.addEventListener("click", () => {
            // Remove active class from all buttons
            durationButtons.forEach(b => b.classList.remove("bg-[#2FE6DE]/20", "text-[#2FE6DE]"));
            // Add active class to selected button
            btn.classList.add("bg-[#2FE6DE]/20", "text-[#2FE6DE]");
            selectedDuration = btn.dataset.duration;
            console.log("Selected duration:", selectedDuration);
        });
    });

    // Example: you can use selectedDuration when submitting the trade
    // buyTradeBtn.addEventListener("click", () => submitTrade("buy", selectedDuration));
    // sellTradeBtn.addEventListener("click", () => submitTrade("sell", selectedDuration));
});
</script>

<!--========Close=Live================================== -->
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
        
        
        <div class="mt-3 md:mt-4 bg-gradient-to-br from-[#1A1428] to-[#0F0A1F] rounded-xl overflow-hidden shadow-xl border border-gray-800/30">
            <div class="p-3 md:p-4 border-b border-gray-800/30 flex items-center justify-between">
              
              
              
                <h2 class="text-base md:text-lg font-medium flex items-center gap-2">
                    <i class="fas fa-history text-[#2FE6DE] text-sm md:text-base"></i>
                    Recent Trades
                </h2>
                <a href="" class="text-[#2FE6DE] text-xs md:text-sm hover:underline flex items-center gap-1 px-2 md:px-3 py-1 rounded-lg bg-[#0F0A1F]/50 border border-gray-800/30">
                    View All
                    <i class="fas fa-arrow-right text-xs"></i>
                </a>
            </div>

            
          <?php
// Fetch last 8 trades for this user
$stmt = $pdo->prepare("SELECT * FROM trade WHERE log_id = :log_id ORDER BY id DESC LIMIT 1000");
$stmt->execute(['log_id' => $userId]);
$trades = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="bg-[#0F0A1F] rounded-xl p-6 border border-gray-800/30 shadow-lg">

    <!-- Desktop View -->
    <div class="hidden md:block overflow-x-auto scrollbar-hide">
        <table class="w-full min-w-[900px]">
            <thead>
                <tr class="text-left text-gray-400 text-sm border-b border-gray-800/50">
                    <th class="pb-4">Trading Pair</th>
                    <th class="pb-4">Trading Type</th>
                    <th class="pb-4">Amount</th>
                    <th class="pb-4">Direction</th>
                    <th class="pb-4">Entry/Close</th>
                    <th class="pb-4">Time</th>
                    <th class="pb-4">Status</th>
                    <th class="pb-4">Result</th>
                    <th class="pb-4">Profit/Loss</th>
                    <th class="pb-4 text-right pr-2">Details</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($trades as $trade): 
                    $direction = strtolower($trade['optionr']) === 'buy' ? 'Buy' : 'Sell';
                    $directionColor = $direction === 'Buy' ? 'green-400' : 'red-400';
                    $statusText = $trade['status'] == 1 ? 'Pending' : 'Completed';
                    $statusColor = $trade['status'] == 1 ? 'yellow-400' : 'green-400';

                    // Result logic based on returnr
                    $result = ($trade['returnr'] > 1) ? 'Win' : 'Trading..';
                    $resultColor = ($trade['returnr'] > 1) ? 'green-400' : 'red-400';

                    // Profit/Loss shows returnr
                    $profitLoss = (float)$trade['returnr'];
                    $wrate = $trade['Wrate'] ?? 0;
                ?>
                <tr class="border-b border-gray-800/30 text-white hover:bg-[#191023]/50 transition-colors">
                    <!--<td class="py-4 pl-2">-->
                    <!--    <div class="flex items-center">-->
                    <!--        <div class="w-8 h-8 rounded-full bg-[#2A243B] flex items-center justify-center mr-2">-->
                    <!--            <i class="fas fa-robot text-[#2FE6DE]"></i>-->
                    <!--        </div>-->
                    <!--        <span class="font-medium"><?= htmlspecialchars($trade['signa']) ?></span>-->
                    <!--    </div>-->
                    <!--</td>-->
                    <td class="py-4"><?= htmlspecialchars($trade['asset']) ?></td>
                    <td class="py-4"><?= htmlspecialchars($trade['plan']) ?></td>
                    <td class="py-4"><?= htmlspecialchars($trade['user_cur']) ?><?= number_format($trade['invested'], 2) ?></td>
                    <td class="py-4">
                        <span class="px-2 py-1 rounded-full text-xs bg-<?= $directionColor ?>/20 text-<?= $directionColor ?>">
                            <i class="fas fa-arrow-<?= $direction === 'Buy' ? 'up' : 'down' ?> mr-1"></i>
                            <?= $direction ?>
                        </span>
                    </td>
                    <td class="py-4">
                        <div class="text-sm"><?= $trade['user_cur'] ?><?= number_format($trade['entryrate'], 2) ?></div>
                        <div class="text-xs text-green-400"><?= $trade['user_cur'] ?><?= number_format($trade['closerate'], 2) ?></div>
                    </td>
                    <td class="py-4">
                        <div class="text-sm"><?= date("M d, Y H:i", strtotime($trade['entrytime'])) ?></div>
                        <div class="text-xs text-gray-400"><?= date("M d, Y H:i", strtotime($trade['expirytime'])) ?></div>
                    </td>
                    <td class="py-4">
                        <span class="px-2 py-1 rounded-full text-xs bg-<?= $statusColor ?>/20 text-<?= $statusColor ?>">
                            <i class="fas fa-check-circle mr-1"></i> <?= $statusText ?>
                        </span>
                    </td>
                    <td class="py-4">
                        <span class="px-2 py-1 rounded-full text-xs bg-<?= $resultColor ?>/20 text-<?= $resultColor ?>">
                            <i class="fas fa-trophy mr-1"></i> <?= $result ?>
                        </span>
                    </td>
                    <td class="py-4">
                        <?php if ($trade['status'] == 1): ?>
                            <span class="text-yellow-400 font-medium">-- --</span>
                        <?php else: ?>
                            <span class="text-<?= $resultColor ?> font-medium">
                                <?= $trade['user_cur'] ?><?= number_format($profitLoss, 2) ?>
                                <span class="text-xs opacity-75">(<?= number_format($wrate, 2) ?>%)</span>
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="py-4 text-right pr-2">
                        <a href="trade_details.php?id=<?= $trade['id'] ?>" class="px-3 py-1.5 bg-[#2A243B] text-[#2FE6DE] rounded-lg hover:bg-[#382f50] transition-colors inline-flex items-center">
                            <i class="fas fa-eye mr-1.5"></i> Details
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

   <!-- Mobile horizontal scrollable table -->
<div id="scrollableTable" class="md:hidden overflow-x-auto scrollbar-thick scrollbar-thumb-[#2FE6DE] scrollbar-track-[#0F0A1F] rounded-lg border border-gray-800/30">
    <table class="min-w-[800px] w-full text-white text-sm border-collapse">
        <thead>
            <tr class="bg-[#191023] border-b border-gray-800/50 text-left">
                <th class="px-4 py-2 whitespace-nowrap">Type</th>
                <th class="px-4 py-2 whitespace-nowrap">Pair</th>
                <th class="px-4 py-2 whitespace-nowrap">Amount</th>
                <th class="px-4 py-2 whitespace-nowrap">Direction</th>
                <th class="px-4 py-2 whitespace-nowrap">Entry Price</th>
                <th class="px-4 py-2 whitespace-nowrap">Close Price</th>
                <th class="px-4 py-2 whitespace-nowrap">Time</th>
                <th class="px-4 py-2 whitespace-nowrap">Duration</th>
                <th class="px-4 py-2 whitespace-nowrap">Status</th>
                <th class="px-4 py-2 whitespace-nowrap">Result</th>
                <th class="px-4 py-2 whitespace-nowrap">Profit/Loss</th>
                <th class="px-4 py-2 whitespace-nowrap">Details</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($trades as $trade):
                $direction = strtolower($trade['optionr']) === 'buy' ? 'Buy' : 'Sell';
                $directionColor = $direction === 'Buy' ? 'green-400' : 'red-400';
                $statusText = $trade['status'] == 1 ? 'Pending' : 'Completed';
                $statusColor = $trade['status'] == 1 ? 'yellow-400' : 'green-400';

                $result = ($trade['returnr'] > 1) ? 'Win' : 'Loss';
                $resultColor = ($trade['returnr'] > 1) ? 'green-400' : 'red-400';

                $profitLoss = (float)$trade['returnr'];
                $wrate = $trade['Wrate'] ?? 0;

                // Duration calculation
                $entryTime = new DateTime($trade['entrytime']);
                $expiryTime = new DateTime($trade['expirytime']);
                $interval = $entryTime->diff($expiryTime);
                $durationStr = '';
                if ($interval->d > 0) $durationStr .= $interval->d . 'd ';
                if ($interval->h > 0) $durationStr .= $interval->h . 'h ';
                if ($interval->i > 0) $durationStr .= $interval->i . 'm';
                $durationStr = trim($durationStr);
                if ($durationStr === '') $durationStr = '0m';
            ?>
            <tr class="border-b border-gray-800/30 hover:bg-[#191023]/60 transition-colors">
                <!--<td class="px-4 py-2 whitespace-nowrap flex items-center">-->
                <!--    <div class="w-6 h-6 rounded-full bg-[#2A243B] flex items-center justify-center mr-2">-->
                <!--        <i class="fas fa-robot text-[#2FE6DE]"></i>-->
                <!--    </div>-->
                <!--    <?= htmlspecialchars($trade['signa']) ?>-->
                <!--</td>-->
                 <td class="px-4 py-2 whitespace-nowrap"><?= htmlspecialchars($trade['plan']) ?></td>
                 <td class="px-4 py-2 whitespace-nowrap"><?= htmlspecialchars($trade['asset']) ?></td>
                <td class="px-4 py-2 whitespace-nowrap"><?= htmlspecialchars($trade['user_cur']) ?><?= number_format($trade['invested'], 2) ?></td>
                <td class="px-4 py-2 whitespace-nowrap">
                    <span class="px-2 py-0.5 rounded-full text-xs bg-<?= $directionColor ?>/20 text-<?= $directionColor ?>">
                        <i class="fas fa-arrow-<?= $direction === 'Buy' ? 'up' : 'down' ?> mr-1"></i> <?= $direction ?>
                    </span>
                </td>
                <td class="px-4 py-2 whitespace-nowrap"><?= $trade['user_cur'] ?><?= number_format($trade['entryrate'], 2) ?></td>
                <td class="px-4 py-2 whitespace-nowrap text-green-400"><?= $trade['user_cur'] ?><?= number_format($trade['closerate'], 2) ?></td>
                <td class="px-4 py-2 whitespace-nowrap"><?= date("M d, Y H:i", strtotime($trade['entrytime'])) ?></td>
                <td class="px-4 py-2 whitespace-nowrap"><?= $durationStr ?></td>
                <td class="px-4 py-2 whitespace-nowrap">
                    <span class="px-2 py-0.5 rounded-full text-xs bg-<?= $statusColor ?>/20 text-<?= $statusColor ?>">
                        <?= $statusText ?>
                    </span>
                </td>
                <td class="px-4 py-2 whitespace-nowrap">
                    <span class="px-2 py-0.5 rounded-full text-xs bg-<?= $resultColor ?>/20 text-<?= $resultColor ?>">
                        <?= $result ?>
                    </span>
                </td>
                <td class="px-4 py-2 whitespace-nowrap font-medium">
                    <?php if ($trade['status'] == 1): ?>
                        <span class="text-yellow-400">-- --</span>
                    <?php else: ?>
                        <span class="text-<?= $resultColor ?>">
                            <?= $trade['user_cur'] ?><?= number_format($profitLoss, 2) ?>
                            <span class="text-xs opacity-75">(<?= number_format($wrate, 2) ?>%)</span>
                        </span>
                    <?php endif; ?>
                </td>
                <td class="px-4 py-2 whitespace-nowrap">
                    <a href="trade_details.php?id=<?= $trade['id'] ?>" class="px-3 py-1 bg-[#2A243B] text-[#2FE6DE] rounded-lg hover:bg-[#382f50] transition-colors inline-flex items-center">
                        <i class="fas fa-eye mr-1"></i> Details
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
  document.addEventListener("DOMContentLoaded", function() {
    const container = document.getElementById('scrollableTable');
    if (!container) return;

    let direction = 1; // 1 = right, -1 = left
    const speed = 0.5; // pixels per frame
    let animationId;

    function scrollStep() {
      container.scrollLeft += direction * speed;

      // Reverse direction when reaching scroll ends
      if (container.scrollLeft + container.clientWidth >= container.scrollWidth) {
        direction = -1;
      } else if (container.scrollLeft <= 0) {
        direction = 1;
      }

      animationId = requestAnimationFrame(scrollStep);
    }

    // Intersection Observer to start scrolling only when visible
    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          if (!animationId) animationId = requestAnimationFrame(scrollStep);
        } else {
          if (animationId) {
            cancelAnimationFrame(animationId);
            animationId = null;
          }
        }
      });
    }, { threshold: 0.1 });

    observer.observe(container);
  });
</script>
</div>
        </div>
 </main>
   
   
   
   <?php require ("footer.php") ?>