<?php
session_start();
require '../config.php'; // database connection

// Check if user is logged in
$id = $_SESSION['SESS_USERID'] ?? null;

if (!$id) {
    header("Location: login.php");
    exit();
}

// Fetch user KYC verification status
// $stmt = $pdo->prepare("SELECT verified FROM logins WHERE id = :id");
// $stmt->execute(['id' => $id]);
// $user = $stmt->fetch(PDO::FETCH_ASSOC);

// $verified = $user['verified'] ?? 0;

// // ✅ Redirect BEFORE loading header.php
// if ($verified == 3) {
//     header("Location: dashboard.php");
//     exit();
// }



// if ((float)($user['verified'] ?? 0) != 2) {
//  echo "<script>window.location.href='index.php';</script>";
// exit();
// exit;
//         }




// Check if service3 (KYC2) is enabled
$stmt = $pdo->query("SELECT service3 and service4 FROM settings LIMIT 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);
$kyc_enabled3 = $settings && $settings['service3'] == 1;
$kyc_enabled4 = $settings && $settings['service4'] == 1;

// Redirect if disabled
if (!$kyc_enabled3 || !$kyc_enabled4) {
    echo "<script>window.location.href='index.php?id=" . ($_GET['id'] ?? '') . "';</script>";
    exit;
}

// At this point, verified < 3 → show awaiting page
require("header_cur.php");
?>

<div class="main-panel">
  <div class="content-wrapper d-flex align-items-center justify-content-center min-vh-100" style="background: url('../assets/bg-blur.jpg') no-repeat center center/cover;">
    <div class="card shadow-lg border-0 bg-white bg-opacity-75" style="max-width: 600px; width: 100%; border-radius: 16px; animation: fadeIn 1s ease-in-out;">
      <div class="card-body text-center">
        <div class="mb-3">
          <i class="fas fa-user-check fa-4x text-warning animate-pulse"></i>
        </div>
        <h3 class="mb-3 text-dark">KYC Verification Pending</h3>
        <p class="text-muted">
          Your submitted documents (Address & ID) are under review by our support team.  
          Once verified, your account will be fully activated and redirected to your dashboard.
        </p>
        <div class="spinner-border text-primary mt-3" role="status">
          <span class="sr-only">Loading...</span>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
  @keyframes fadeIn {
    0% { opacity: 0; transform: translateY(20px); }
    100% { opacity: 1; transform: translateY(0); }
  }
  .animate-pulse {
    animation: pulse 2s infinite;
  }
  @keyframes pulse {
    0% { transform: scale(1); opacity: 0.8; }
    50% { transform: scale(1.1); opacity: 1; }
    100% { transform: scale(1); opacity: 0.8; }
  }
</style>

<?php require("footer.php"); ?>
