<?php require("header_cur.php"); ?>

<?php
// Check if service4 (KYC3) is enabled
$stmt = $pdo->query("SELECT service4 FROM settings LIMIT 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);
$kyc_enabled = $settings && $settings['service4'] == 1;

// Redirect if disabled
if (!$kyc_enabled) {
    echo "<script>window.location.href='kyc_await.php?id=" . ($_GET['id'] ?? '') . "';</script>";
    exit;
}

$id = $_SESSION['SESS_USERID'] ?? null;
if (!$id) {
    header("Location: logout.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $mode = $_POST['id_mode'] ?? '';
    $id_number = $_POST['id_number'] ?? '';
    $uploads = [];

    $target_dir = __DIR__ . "/upload/doc/";
    if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);

    $extensions_arr = ["jpg", "jpeg", "png", "pdf"];
    $maxsize = 104857600; // 100MB

    foreach ($_FILES as $key => $file) {
        if (!empty($file["name"])) {
            $extension = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));
            $filename = time() . "_" . $key . "_" . basename($file["name"]);
            $target_file = $target_dir . $filename;
            $db_file_path = "accounts/upload/doc/" . $filename;

            if (in_array($extension, $extensions_arr)) {
                if ($file["size"] < $maxsize && $file["size"] > 0) {
                    if (move_uploaded_file($file["tmp_name"], $target_file)) {
                        $uploads[$key] = $db_file_path;
                    } else {
                        echo "<script>alert('❌ Upload failed for {$key}.');</script>";
                    }
                } else {
                    echo "<script>alert('❌ File too large for {$key}. Max 100MB allowed.');</script>";
                }
            } else {
                echo "<script>alert('❌ Invalid file type for {$key}. Allowed: JPG, JPEG, PNG, PDF');</script>";
            }
        }
    }

    if (!empty($uploads['frontFile']) && !empty($uploads['backFile'])) {
        $stmt = $pdo->prepare("UPDATE logins SET 
            id_card = :id_mode,
            id_no = :id_number,
            frontcard_location = :id_front,
            backcard_location = :id_back,
            verified = 2
            WHERE id = :id");

        $stmt->bindParam(':id_mode', $mode);
        $stmt->bindParam(':id_number', $id_number);
        $stmt->bindParam(':id_front', $uploads['frontFile']);
        $stmt->bindParam(':id_back', $uploads['backFile']);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            echo "<script>alert('✅ Documents uploaded successfully!'); window.location.href='kyc_await.php';</script>";
            exit();
        }
    }
}
?>

<div wire:snapshot="{&quot;data&quot;:{&quot;subject&quot;:null,&quot;message&quot;:null,&quot;search&quot;:&quot;&quot;},&quot;memo&quot;:{&quot;id&quot;:&quot;V6kSc3a2Zc4A4AdWtQNv&quot;,&quot;name&quot;:&quot;user.contact-support&quot;,&quot;path&quot;:&quot;user\/contact-support&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;children&quot;:[],&quot;scripts&quot;:[],&quot;assets&quot;:[],&quot;errors&quot;:[],&quot;locale&quot;:&quot;en&quot;},&quot;checksum&quot;:&quot;449e4d3fd1c77f434a1f266473766dc0fc4545a4a7a6c2c0967344509f9a2120&quot;}" wire:effects="[]" wire:id="V6kSc3a2Zc4A4AdWtQNv" class="space-y-6 mb-5 md:mb-1">
<div class="flex items-center justify-center min-h-screen bg-[#0A0714] text-white px-4">

    <style>
      .verify-card {
        max-width: 850px;
        width: 95%;
        background: #161223;
        color: #fff;
        border-radius: 20px;
        border: 1px solid rgba(47,230,222,0.4);
        box-shadow: 0 8px 25px rgba(0,0,0,0.6);
        overflow: hidden;
        animation: fadeInUp 0.8s ease-in-out;
        margin: 20px auto;
      }
      .status-header {
        text-align: center;
        padding: 18px;
        font-weight: bold;
        font-size: 18px;
        animation: pulse 2s infinite;
        border-bottom: 2px solid rgba(255,255,255,0.1);
      }
      .not-verified { background: #e74c3c; }
      .under-review { background: #f39c12; }
      .verified { background: #27ae60; }

      @keyframes fadeInUp {
        from { opacity:0; transform:translateY(50px); }
        to { opacity:1; transform:translateY(0); }
      }
      @keyframes pulse {
        0% { box-shadow:0 0 0 0 rgba(255,255,255,0.4); }
        70% { box-shadow:0 0 20px 10px rgba(255,255,255,0); }
        100% { box-shadow:0 0 0 0 rgba(255,255,255,0); }
      }

      .verify-body {
        padding: 2px;
        display: flex;
        flex-direction: column;
        gap: 18px;
      }
      .form-control { background:#0A0714; color:#fff; border:1px solid #444; }
      .dropzone {
        border: 2px dashed #2FE6DE;
        border-radius: 12px;
        padding: 24px;
        text-align: center;
        background: rgba(255,255,255,0.05);
        transition: all 0.3s ease;
        cursor: pointer;
      }
      .dropzone:hover { background: rgba(47,230,222,0.1); }
      .dropzone.dragover { border-color: #1BC4B7; background: rgba(27,196,183,0.15); }
      .preview-img {
        max-height: 150px;
        margin-top: 10px;
        border-radius: 10px;
      }
      .btn-upload {
        display: block;
        width: 100%;
        padding: 16px;
        margin-top: 10px;
        margin-bottom: 15px; /* ✅ ensures it's not cut on mobile */
        border-radius: 12px;
        background: linear-gradient(45deg, #2FE6DE, #1BC4B7);
        color: #0A0714;
        font-weight: bold;
        text-align: center;
        transition: all 0.3s ease;
      }
      .btn-upload:hover {
        transform: scale(1.03);
        box-shadow: 0 0 12px rgba(47,230,222,0.8);
      }

      @media (max-width:768px) {
        .verify-body { padding: 16px; gap: 14px; }
        .dropzone { padding: 18px; }
        .btn-upload { font-size: 16px; padding: 14px; }
      }
    </style>
    
    

    <div class="verify-card">
      <?php
      $status_class = "not-verified";
      $status_text = "NOT VERIFIED";

      $stmt = $pdo->prepare("SELECT verified FROM logins WHERE id = :id");
      $stmt->execute(['id' => $id]);
      $user = $stmt->fetch(PDO::FETCH_ASSOC);

      if ($user) {
          $status = (int) $user['verified'];
          if ($status === 0) { $status_class = "not-verified"; $status_text = "NOT VERIFIED"; }
          elseif ($status === 1) { $status_class = "under-review"; $status_text = "UNDER REVIEW"; }
          elseif ($status === 2) { $status_class = "verified"; $status_text = "VERIFIED"; }
      }
      ?>
      <div class="status-header <?= $status_class ?>">
        <?= $status_text ?>
      </div>



      <div class="verify-body">
        <h4 class="mb-3 text-center">Upload Identity Verification Documents</h4>
        <p class="text-center text-info mb-3">
          📑 Upload both sides of your Government-issued ID card.<br>
          Formats: <strong>JPG, JPEG, PNG, PDF</strong>. Max size: <strong>100MB</strong>.
        </p>

        <form method="POST" enctype="multipart/form-data">

          <label class="block text-sm text-gray-400 mb-2">Upload Front Side of ID*</label>
          <div class="dropzone" id="frontDrop">
            <input type="file" name="frontFile" id="frontFile" accept="image/*,application/pdf" hidden required>
            <p>📤 Drag & Drop front ID here or click to upload</p>
            <img id="frontPreview" class="preview-img" style="display:none;">
          </div><hr>

          <label class="block text-sm text-gray-400 mb-2">Upload Back Side of ID*</label>
          <div class="dropzone" id="backDrop">
            <input type="file" name="backFile" id="backFile" accept="image/*,application/pdf" hidden required>
            <p>📤 Drag & Drop back ID here or click to upload</p>
            <img id="backPreview" class="preview-img" style="display:none;">
          </div><hr>

          <div class="form-group">
            <label class="block text-sm text-gray-400 mb-2" for="id_mode">Mode of Identification *</label>
            <select name="id_mode"  class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors" required>
              <option value="National ID">National ID</option>
              <option value="Driver's License">Driver's License</option>
              <option value="Passport">Passport</option>
              <option value="Voter's Card">Voter's Card</option>
            </select>
          </div><hr>

          <div class="form-group">
            <label for="id_number">ID Card Number *</label>
            <input type="text" name="id_number"  class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors" placeholder="Enter your ID number" required>
          </div><hr>

          <button type="submit" class="btn-upload">📤 Submit Documents</button>
        </form>
      </div>
      
<br>
<br>
<br>

      
      
    </div>
    
  </div>
  
  
</div>

<script>
function setupDropzone(dropId, inputId, previewId) {
  const drop = document.getElementById(dropId);
  const input = document.getElementById(inputId);
  const preview = document.getElementById(previewId);

  drop.addEventListener("click", () => input.click());
  drop.addEventListener("dragover", e => {
    e.preventDefault();
    drop.classList.add("dragover");
  });
  drop.addEventListener("dragleave", () => drop.classList.remove("dragover"));
  drop.addEventListener("drop", e => {
    e.preventDefault();
    drop.classList.remove("dragover");
    input.files = e.dataTransfer.files;
    showPreview(input, preview);
  });
  input.addEventListener("change", () => showPreview(input, preview));
}

function showPreview(input, preview) {
  if (input.files && input.files[0]) {
    const reader = new FileReader();
    reader.onload = e => {
      preview.src = e.target.result;
      preview.style.display = "block";
    };
    reader.readAsDataURL(input.files[0]);
  }
}

setupDropzone("frontDrop", "frontFile", "frontPreview");
setupDropzone("backDrop", "backFile", "backPreview");
</script>

<?php require("footer.php"); ?>
