<?php require("header_cur.php"); ?>

<?php

//  if ((float)($user['cur_rate'] ?? 0) != 0) {
//           echo "<script>window.location.href='index.php';</script>";
// exit();
//             exit;
//         }
        
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action_cur'])) {
    // Collect and sanitize input
    $sex      = $_POST['sex'] ?? '';
    $fullname = $_POST['fullname'] ?? '';
    $dob      = $_POST['dob'] ?? '';
    $state    = $_POST['state'] ?? '';
    $city     = $_POST['city'] ?? '';
    $street1  = $_POST['street1'] ?? '';
    $street2  = $_POST['street2'] ?? '';
    $verified  = $_POST['verified'] ?? '';
     $confirmPAY  = $_POST['confirmPAY'] ?? '';

    // Currency data from hidden fields
    $currency      = $_POST['currency'] ?? '';
    $cur_rate      = $_POST['cur_rate'] ?? '';
    $cur_symbol    = $_POST['cur_symbol'] ?? '';
    $cur_shot_name = $_POST['cur_shot_name'] ?? '';

    try {
        // Update both currency + KYC details
        $sql = $pdo->prepare("UPDATE logins SET 
            currency = :currency, 
            cur_rate = :cur_rate, 
            cur_shot_name = :cur_shot_name, 
            cur_symbol = :cur_symbol,
            sex = :sex,
            fullname = :fullname,
            dob = :dob,
            state = :state,
            city = :city,
            street1 = :street1,
            street2 = :street2,
            verified = :verified,
            confirmPAY = :confirmPAY
            WHERE id = :id");

        $success = $sql->execute([
            'currency'      => $currency,
            'cur_rate'      => $cur_rate,
            'cur_shot_name' => $cur_shot_name,
            'cur_symbol'    => $cur_symbol,
            'sex'           => $sex,
            'fullname'      => $fullname,
            'dob'           => $dob,
            'state'         => $state,
            'city'          => $city,
            'street1'       => $street1,
            'street2'       => $street2,
            'verified'       => $verified,
            'confirmPAY'       => $confirmPAY,
            'id'            => $user['id'] // logged-in user
        ]);

        if ($success) {
            echo "<script>
                alert('KYC 1 and Currency Successfully Updated!');
                window.location.href = 'kyc2.php';
            </script>";
            exit;
        } else {
            $error_cur = "<div class='alert alert-danger'>Failed to update KYC 1. Please try again.</div>";
        }
    } catch (PDOException $e) {
        die("Error updating KYC: " . $e->getMessage());
    }
}
?>


<main class="flex-1 px-2 py-2 md:p-4 pb-20 md:pb-6 overflow-hidden">
                    <div wire:snapshot="{&quot;data&quot;:{&quot;subject&quot;:null,&quot;message&quot;:null,&quot;search&quot;:&quot;&quot;},&quot;memo&quot;:{&quot;id&quot;:&quot;V6kSc3a2Zc4A4AdWtQNv&quot;,&quot;name&quot;:&quot;user.contact-support&quot;,&quot;path&quot;:&quot;user\/contact-support&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;children&quot;:[],&quot;scripts&quot;:[],&quot;assets&quot;:[],&quot;errors&quot;:[],&quot;locale&quot;:&quot;en&quot;},&quot;checksum&quot;:&quot;449e4d3fd1c77f434a1f266473766dc0fc4545a4a7a6c2c0967344509f9a2120&quot;}" wire:effects="[]" wire:id="V6kSc3a2Zc4A4AdWtQNv" class="space-y-6 mb-5 md:mb-1">
    

    <div>
<!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->
</div>

    <div>
<!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->
</div>


    
    <div class="grid lg:grid-cols-3 gap-6">
        
        <div class="lg:col-span-2">
            <div class="bg-[#0F0A1F] rounded-2xl">
                <div class="p-6 border-b border-gray-800/50">
                     <p class="text-muted mb-0 hover-cursor"> 
                            <i class="far fa-money-bill-alt menu-icon"></i> &nbsp;&nbsp; CURRENCY
                        </p>
                </div>
  <?php
    // Validate and sanitize input
    if (!isset($_GET['method']) || !is_numeric($_GET['method'])) {
        die("<div class='alert alert-danger'>Invalid Currency ID.</div>");
    }

    $id = intval($_GET['method']); 

    // Fetch currency details securely using PDO
    $stmt = $pdo->prepare("SELECT * FROM currencies WHERE id = ?");
    $stmt->execute([$id]);
    $ordrow = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$ordrow) {
        die("<div class='alert alert-danger'>Currency not found.</div>");
    }
    ?>
                <div class="p-6">
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    <form method="POST" onsubmit="return confirmUpdate()">
                        <h4>KYC 1 Confirmation</h4>

                        <!-- Gender -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="sex">Gender</label>
                          <select name="sex" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors" required>
                              <option value=''>---Select Gender---</option>
                            <option value="1" <?= ($user['sex'] == 1) ? 'selected' : ''; ?>>MALE</option>
                            <option value="2" <?= ($user['sex'] == 2) ? 'selected' : ''; ?>>FEMALE</option>
                          </select>
                        </div>

                        <!-- Full Name -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="fullname">Full Name</label>
                          <input type="text" name="fullname" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['fullname']) ?>" required>
                        </div>

                        <!-- Username -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="username">Username</label>
                          <input type="text" name="username" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['username']) ?>" readonly>
                        </div>

                        <!-- Email -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="email">Email</label>
                          <input type="email" name="email" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['email']) ?>" readonly>
                        </div>

                        <!-- Phone -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="phone">Phone</label>
                          <input type="tel" name="phone" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['phone']) ?>" readonly>
                        </div>

                        <!-- DOB -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="dob">DOB</label>
                          <input type="date" name="dob" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['dob'] ?? '') ?>" required>
                        </div>

                        <!-- State -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="state">State</label>
                          <input type="text" name="state" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['state'] ?? '') ?>" required>
                        </div>

                        <!-- City -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="city">City</label>
                          <input type="text" name="city" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['city'] ?? '') ?>" required>
                        </div>

                        <!-- Address 1 -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="street1">Address 1</label>
                          <input type="text" name="street1" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['street1'] ?? '') ?>" required>
                        </div>

                        <!-- Address 2 -->
                        <div class="form-group">
                          <label class="text-sm text-gray-400" for="street2">Address 2</label>
                          <input type="text" name="street2" class="w-full bg-[#1A1428] border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-[#2FE6DE] transition-colors"
                            value="<?= htmlspecialchars($user['street2'] ?? '') ?>">
                        </div>

                        <!-- Hidden fields for currency -->
                        <input type="hidden" name="currency" value="<?= htmlspecialchars($ordrow['cur_name']) ?>">
                        
                        <input type="hidden" name="verified" value="0">
                        
                        
                        <input type="hidden" name="confirmPAY" value="3">
                        
                        
                        
                        <input type="hidden" name="cur_shot_name" value="<?= htmlspecialchars($ordrow['cur_shot_name']) ?>">
                        <input type="hidden" name="cur_rate" value="<?= htmlspecialchars($ordrow['cur_rate']) ?>">
                        <input type="hidden" name="cur_symbol" value="<?= htmlspecialchars($ordrow['cur_symbol']) ?>">

                        <div class="flex justify-center gap-4 mt-4">
  <button 
    class="bg-gradient-to-r from-[#2FE6DE] to-[#2FE6DE]/80 text-black font-medium px-6 py-4 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-3 disabled:opacity-50"
    name="action_cur" 
    type="submit"
  >
    Confirm KYC 1
  </button>

  <a 
    class="bg-gradient-to-r from-[#2FE6DE] to-[#2FE6DE]/80 text-black font-medium px-6 py-4 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-3 disabled:opacity-50"
    name="action_cur" 
    href="kyc1.php"
  >
    Back
  </a>
</div>

                    </form>
                </div>
            </div>
        </div>

        
        <div class="lg:col-span-1">
            <div class="bg-[#0F0A1F] rounded-2xl">
                <div class="p-6 border-b border-gray-800/50">
                    <h3 class="text-lg font-medium">Curency Details</h3>
                </div>

                <div class="p-6 space-y-6">
                    
                    <div class="bg-[#1A1428] rounded-xl p-4">
                        <div class="flex items-start gap-4">
                            <div class="w-10 h-10 flex items-center justify-center bg-[#2FE6DE]/10 rounded-lg flex-shrink-0">
                                <i class="fas fa-dollar-sign text-[#2FE6DE]"></i>
                            </div>
                            <div>
                                <h4 class="font-medium mb-1">Name of Currency</h4>
                                <span class='text-primary small'><?= htmlspecialchars($ordrow['cur_name']) ?></span>
                            </div>
                        </div>
                    </div>

                    
                    <div class="bg-[#1A1428] rounded-xl p-4">
                        <div class="flex items-start gap-4">
                            <div class="w-10 h-10 flex items-center justify-center bg-[#2FE6DE]/10 rounded-lg flex-shrink-0">
                                <i class="fas fa-dollar-sign text-[#2FE6DE]"></i>
                            </div>
                            <div>
                                <h4 class="font-medium mb-1">Currency Rate</h4>
                               <span class='text-primary small'><?= htmlspecialchars($ordrow['cur_rate']) ?></span>
                            </div>
                        </div>
                    </div>

                    
                    <div class="bg-[#1A1428] rounded-xl p-4">
                        <div class="flex items-start gap-4">
                            <div class="w-10 h-10 flex items-center justify-center bg-[#2FE6DE]/10 rounded-lg flex-shrink-0">
                                <i class="fas fa-dollar-sign text-[#2FE6DE]"></i>
                            </div>
                            <div>
                                <h4 class="font-medium mb-1">Currency Short Name</h4>
                                <span class='text-primary small'><?= htmlspecialchars($ordrow['cur_shot_name']) ?></span>
                            </div>
                        </div>
                    </div>
                    
                    
                    
                    
                    <div class="bg-[#1A1428] rounded-xl p-4">
                        <div class="flex items-start gap-4">
                            <div class="w-10 h-10 flex items-center justify-center bg-[#2FE6DE]/10 rounded-lg flex-shrink-0">
                               <i class="fas fa-dollar-sign text-[#2FE6DE]"></i>
                            </div>
                            <div>
                                <h4 class="font-medium mb-1">Currency Symbol</h4>
                               <span class='text-primary small'><?= htmlspecialchars($ordrow['cur_symbol']) ?></span>
                            </div>
                        </div>
                    </div>
                    
                    
                    
                    
                    
                    
                </div>
            </div>
        </div>
        
        
        
        
        
        
        
        
        
        
        
        
    </div>
</div>

            </main>
  <?php require ("footer.php") ?>