<?php
// Debugging mode (disable on production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// session_start();




// At the very top of header.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}


require '../config.php'; // Your PDO connection file







// ================== AUTO-CURRENCY CHECK & UPDATE ================== //
$userId = $_SESSION['SESS_USERID'] ?? 0;

if ($userId) {
    $stmt = $pdo->prepare("SELECT id, currency, cur_rate FROM logins WHERE id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        $userCurrency = trim($user['currency']); // could be name, symbol, or short code
        $db_rate      = (float)($user['cur_rate'] ?? 1);

        // 🔹 Try to match with currency table
        $stmtCur = $pdo->prepare("
            SELECT cur_name, cur_symbol, cur_shot_name, cur_rate
            FROM currencies 
            WHERE cur_name = :c 
               OR cur_symbol = :c 
               OR cur_shot_name = :c
            LIMIT 1
        ");
        $stmtCur->execute([':c' => $userCurrency]);
        $curRow = $stmtCur->fetch(PDO::FETCH_ASSOC);

        if ($curRow) {
            $global_rate = (float)$curRow['cur_rate'];

            // Update only if different
            if ($db_rate != $global_rate) {
                $upd = $pdo->prepare("UPDATE logins SET cur_rate = ? WHERE id = ?");
                $upd->execute([$global_rate, $userId]);
                $db_rate = $global_rate;
            }

            // Final values always synced with currency table
            $cur_rate      = $db_rate;
            $cur_symbol    = $curRow['cur_symbol'];
            $cur_shot_name = $curRow['cur_shot_name'];
            $currency      = $curRow['cur_name'];
        }
    }
}
// ==================END AUTO-CURRENCY CHECK & UPDATE================ //





// Redirect to logout if no valid session is found
if (!isset($_SESSION['user']) && !isset($_SESSION['SESS_USERID'])) {
    header("Location: logout.php");
    exit;
}

// Get user ID
$userId = $_SESSION['SESS_USERID'] ?? null;

if (!$userId) {
    $email = $_SESSION['user'] ?? null;

    if ($email) {
        try {
            $stmt = $pdo->prepare("SELECT id FROM logins WHERE email = :email");
            $stmt->execute(['email' => $email]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($result) {
                $userId = $result['id'];
                $_SESSION['SESS_USERID'] = $userId;
            } else {
                header("Location: logout.php");
                exit;
            }
        } catch (PDOException $e) {
            die("Database error: " . $e->getMessage());
        }
    } else {
        header("Location: logout.php");
        exit;
    }
}






// ✅ Fetch service3 & service4 settings (KYC switches)
$stmt = $pdo->query("SELECT service3, service4 FROM settings LIMIT 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

$requireKYC2 = $settings && $settings['service3'] == 1;
$requireKYC3 = $settings && $settings['service4'] == 1;




try {
    // Fetch user data
    $stmt = $pdo->prepare("SELECT * FROM logins WHERE id = :id");
    $stmt->execute(['id' => $userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // If no currency set, redirect
       
       
       
       
       
        if ((float)($user['cur_rate'] ?? 0) == 0) {
            header("Location: kyc1.php");
            exit;
        } 
        
        
        
        
        
        //  if ((float)($user['verified'] ?? 0) == 0) {
        //     header("Location: kyc2.php");
        //     exit;
        // }
        
        
        //  if ((float)($user['verified'] ?? 0) == 1) {
        //     header("Location: kyc3.php");
        //     exit;
        // }
        
        
        //  if ((float)($user['verified'] ?? 0) == 2) {
        //     header("Location: kyc_await.php");
        //     exit;
        // }
        
        
        
        

        // Currency
        $currency       = $user['currency']       ?? '';
        $cur_rate       = (float)($user['cur_rate'] ?? 1);
        $cur_symbol     = $user['cur_symbol']     ?? '';
        $cur_shot_name  = $user['cur_shot_name']  ?? '';

        // Financials (cast to float)
        $ibalance       = (float)($user['ibalance'] ?? 0);
        $balance        = (float)($user['balance'] ?? 0);
        $userbill       = (float)($user['userbill'] ?? 0);
        $profit         = (float)($user['profit'] ?? 0);
        $iprofit        = (float)($user['iprofit'] ?? 0);
        $deposit        = (float)($user['deposit'] ?? 0);
        $invest         = (float)($user['invest'] ?? 0);
        $tot_withdraw   = (float)($user['tot_withdraw'] ?? 0);
        $refcom         = (float)($user['refcom'] ?? 0);
        $tot_invest     = (float)($user['tot_invest'] ?? 0);
        $tot_percent    = (float)($user['tot_percent'] ?? 0);
        $trade_amt      = (float)($user['trade_amt'] ?? 0);

        // Bank details
        $bnm    = $user['bnm']    ?? '';
        $acn    = $user['acn']    ?? '';
        $acnm   = $user['acnm']   ?? '';
        $swift  = $user['swift']  ?? '';
        $bvn    = $user['bvn']    ?? '';

        // User status
        $stat        = $user['status'] ?? '';
        $status      = $user['status'] ?? '';
        $confirmPAY  = $user['confirmPAY'] ?? '';
        $confirmINVEST = $user['confirmINVEST'] ?? '';

        // Wallets
        $wallet1 = $user['wallet1'] ?? '';
        $wallet2 = $user['wallet2'] ?? '';
        $wallet3 = $user['wallet3'] ?? '';
        $wallet4 = $user['wallet4'] ?? '';

        // Methods
        $method1 = $user['method1'] ?? '';
        $method2 = $user['method2'] ?? '';
        $method3 = $user['method3'] ?? '';
        $method4 = $user['method4'] ?? '';

        // Misc
        $class       = $user['class'] ?? '';
        $cwithdraw   = (float)($user['cwithdraw'] ?? 0);
        $cdeposit    = (float)($user['cdeposit'] ?? 0);
        $withdraw    = (float)($user['withdraw'] ?? 0);
        $tot_deposit = (float)($user['tot_deposit'] ?? 0);

        $curren  = $user['currency'] ?? '';
        $app_id  = $user['app_id'] ?? '';
        $plan    = $user['plan'] ?? '';
        $switch  = $user['switch'] ?? '';
        $dbalc   = (float)($user['dbalance'] ?? 0);
        $ivest   = (float)($user['ivest'] ?? 0);

        // Personal info
        $fullname = $user['fullname'] ?? '';
        $username = $user['username'] ?? '';
        $add1     = $user['country'] ?? '';
        $add3     = $user['state'] ?? '';
        $city     = $user['city'] ?? '';
        $postcode = $user['postcode'] ?? '';
        $phone    = $user['phone'] ?? '';
        $email    = $user['email'] ?? '';
        $id_card  = $user['id_card'] ?? '';
        $id_no    = $user['id_no'] ?? '';
        $frontcard_location = $user['frontcard_location'] ?? '';
        $backcard_location  = $user['backcard_location'] ?? '';
        $sex      = $user['sex'] ?? '';
        $street1  = $user['street1'] ?? '';
        $street2  = $user['street2'] ?? '';

        // Identifiers
        $id      = $user['id'];
        $user_id = $user['id'];
        $account = $user['account'] ?? '';
        $P_location = $user['P_location'] ?? '';
        $reftot  = (int)($user['reftot'] ?? 0);
        $refact  = (int)($user['refact'] ?? 0);

        // More
        $pack   = $user['pack'] ?? '';
        $fee    = (float)($user['fee'] ?? 0);
        $auto   = $user['auto'] ?? '';
        $mine   = $user['mine'] ?? '';
        $start  = $user['start'] ?? '';
        $trade  = $user['trade'] ?? '';
        $no_sigfee = $user['no_sigfee'] ?? '';
        $tnx_code  = $user['tnx_code'] ?? '';

        // Counters
        $icount = (int)($user['icount'] ?? 0);
        $wcount = (int)($user['wcount'] ?? 0);
        $dcount = (int)($user['dcount'] ?? 0);

        // Withdrawal
        $withdrw_pin    = $user['withdrw_pin'] ?? '';
        $withdrw_status = $user['withdrw_status'] ?? '';
        $withdrw_fee    = (float)($user['withdrw_fee'] ?? 0);

        // Tax
        $tax_pin    = $user['tax_pin'] ?? '';
        $tax_status = $user['tax_status'] ?? '';
        $tax_fee    = (float)($user['tax_fee'] ?? 0);

        // Swift
        $swift_pin    = $user['swift_pin'] ?? '';
        $swift_status = $user['swift_status'] ?? '';
        $swift_fee    = (float)($user['swift_fee'] ?? 0);

        // Upgrade
        $upgrade_pin    = $user['upgrade_pin'] ?? '';
        $upgrade_status = $user['upgrade_status'] ?? '';
        $upgrade_fee    = (float)($user['upgrade_fee'] ?? 0);

        // Commission
        $commission_pin    = $user['commission_pin'] ?? '';
        $commission_status = $user['commission_status'] ?? '';
        $commission_fee    = (float)($user['commission_fee'] ?? 0);

        // Signal
        $signal_pin    = $user['signal_pin'] ?? '';
        $signal_status = $user['signal_status'] ?? '';
        $signal_fee    = (float)($user['signal_fee'] ?? 0);
        $signa         = $user['signa'] ?? '';

        // Other
        $type     = $user['type'] ?? '';
        $locked   = $user['locked'] ?? '';
        $bitcoin  = $user['bitcoin'] ?? '';
        $ethereum = $user['ethereum'] ?? '';
        $litecoin = $user['litecoin'] ?? '';
        $binance  = $user['binance'] ?? '';
        $hash     = $user['hash'] ?? '';

        // News
        $nztitle = $user['nztitle'] ?? '';
        $nznote  = $user['nznote'] ?? '';
        $newz    = $user['newz'] ?? '';

        // Verification
        $verified = $user['verified'] ?? '';
        $confirm  = $user['confirm'] ?? '';
        $vcode    = $user['vcode'] ?? '';

        // Trading
        $asset  = $user['asset'] ?? '';
        $optionr = $user['optionr'] ?? '';
        $lots   = (float)($user['lots'] ?? 0);
        $icopy  = $user['icopy'] ?? '';

        $pack_id       = $user['pack_id'] ?? '';
        $Pack_location = $user['Pack_location'] ?? '';

        // Convert amounts
        $ibalc      = number_format($ibalance * $cur_rate, 2);
        $balc       = number_format($balance * $cur_rate, 2);
        $prof       = number_format($profit * $cur_rate, 2);
        $iprof      = number_format($iprofit * $cur_rate, 2);
        $depos      = number_format($deposit * $cur_rate, 2);
        $tot_withdr = number_format($tot_withdraw * $cur_rate, 2);
        $tot_inve   = number_format($tot_invest * $cur_rate, 2);
        $trade_amt  = number_format($trade_amt * $cur_rate, 2);
        $refc       = number_format($refcom * $cur_rate, 2);

        $user_bal   = $balance * $cur_rate;

        // ===== REFERRALS =====
        $referral_link = "register.php?ref=" . urlencode($username);

        try {
            $stmtRef = $pdo->prepare("SELECT username, email, phone, date 
                                      FROM ref WHERE userid = :userid ORDER BY id DESC");
            $stmtRef->execute([':userid' => $userId]);
            $my_referrals = $stmtRef->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            $my_referrals = [];
        }

    } else {
        header("Location: logout.php");
        exit;
    }
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>


<!--===========START====SETPLAN===========================-->
<?php
if (isset($_POST['action_P'])) {
    $plan = $_POST['plan'];

    $sql = $pdo->prepare("SELECT * FROM logins WHERE id = :id");
    $sql->execute(['id' => $id]);
    $srow = $sql->fetch(PDO::FETCH_ASSOC);

    if ($srow && $balc > $tamount && $signa != 404) {
        $update = $pdo->prepare("UPDATE logins SET plan = :plan WHERE id = :id");
        if ($update->execute(['plan' => $plan, 'id' => $id])) {
            echo "<script>
                alert('ERROR IN TRANSACTION!!...PLEASE CHECK YOUR ACCOUNT BALANCE..');
                window.location.href = 'index.php';
            </script>";
        }
    }
}
?>
<!--===========END====SETPLAN===============================-->





















<!DOCTYPE html>
<html lang="en">

<head>
    <script type="text/javascript" src="https://js.stripe.com/v3/"></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <!--<meta name="csrf-token" content="ZYX5TIZgMGxCAhfOsH5GKhGqRe3HCsXusJ2EeNQd">-->
    <meta name="locale" content="en">
    <meta name="content-language" content="en">
    <title><?php echo $domain_name ?> | Dashboard</title>
    <link rel="icon" href="../img/favicon.png" type="image/png" />
    <script src="cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/dark.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/pako@2.1.0/dist/pako.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
    
    
    
    
    
    
    
    

<?php

// Fetch the site name from the database
$stmt = $pdo->prepare("SELECT * FROM settings WHERE id = 21"); // Change ID if needed
$stmt->execute();
$row = $stmt->fetch();

$siteName = $row ? $row['domain_name'] : 'MySite';
?>

<style>
    /* Logo container */
    .logo-container {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-top: 4px;
    }

    /* Dynamic logo styling */
    .logo {
        font-family: 'Poppins', sans-serif;
        font-size: 1rem;
        font-weight: 800;
        background: linear-gradient(135deg, #42f5d4, #4242f5);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        text-shadow: 2px 2px 15px rgba(0,0,0,0.2);
        letter-spacing: 2px;
        transition: transform 0.3s, text-shadow 0.3s;
        cursor: default;
    }

    /* Hover effect */
    .logo:hover {
        transform: scale(1.1) rotate(-2deg);
        text-shadow: 4px 4px 25px rgba(0,0,0,0.4);
    }
</style>

  


    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');

        body {
            font-family: 'Inter', sans-serif;
        }

        /* Custom Scrollbar Styling */
        * {
            scrollbar-width: thin;
            /* For Firefox */
            scrollbar-color: #2FE6DE/20 #1A1428;
            /* Thumb color and track color */
        }

        /* Webkit Browsers (Chrome, Safari, newer versions of Opera) */
        *::-webkit-scrollbar {
            width: 8px;
            /* Thin scrollbar */
        }

        *::-webkit-scrollbar-track {
            background: #1A1428;
            /* Dark background for the track */
            border-radius: 10px;
        }

        *::-webkit-scrollbar-thumb {
            background-color: rgba(47, 230, 222, 0.2);
            /* Teal color with opacity */
            border-radius: 10px;
            border: 2px solid transparent;
            background-clip: content-box;
        }

        *::-webkit-scrollbar-thumb:hover {
            background-color: rgba(47, 230, 222, 0.4);
            /* Slightly more opaque on hover */
        }

        .opacity-0 {
            opacity: 0;
        }

        .opacity-100 {
            opacity: 1;
        }

        .transition-opacity {
            transition-property: opacity;
        }

        .duration-300 {
            transition-duration: 300ms;
        }
    </style>
    
    
    <style>
    #site-loader {
    transition: opacity 0.5s ease-in-out;
}

@keyframes pulse {
    0% { opacity: 0.6; transform: scale(0.98); }
    50% { opacity: 1; transform: scale(1); }
    100% { opacity: 0.6; transform: scale(0.98); }
}

.animate-pulse {
    animation: pulse 2s infinite;
}

    </style>
    
    <style>
        
        
        .alert-box {
  position: fixed;
  top: 8px; /* distance from top */
  left: 40%;
  transform: translateX(-50%);
  z-index: 9999;

  background: #161223;
  border: 2px solid #2FE6DE;
  border-radius: 10px;   /* curved rectangle */
  padding: 5px 8px;
  max-width: 500px;
  width: 60%;
  text-align: left;

  color: #fff;
  font-size: 11px;
  font-weight: 500;

  box-shadow: 0 6px 20px rgba(0,0,0,0.5);
  animation: fadeInDown 0.6s ease;
}

.alert-box p {
  margin: 0;
}

.alert-link {
  color: #2FE6DE;
  font-weight: bold;
  margin-left: 6px;
  text-decoration: underline;
}

@keyframes fadeInDown {
  from { opacity: 0; transform: translate(-50%, -30px); }
  to { opacity: 1; transform: translate(-50%, 0); }
}

.reflect-btn {
  display: inline-block;
  padding: 8px 16px;
  border-radius: 5px;
  background: linear-gradient(45deg, #2FE6DE, #1BC4B7);
  color: #0A0714;
  font-size: 11px;
  font-weight: bold;
  text-decoration: none;
  position: relative;
  overflow: hidden;
  box-shadow: 0 4px 12px rgba(0,0,0,0.4);
  transition: transform 0.2s ease, box-shadow 0.2s ease;
}

/* Hover bounce + glow */
.reflect-btn:hover {
  transform: translateY(-2px) scale(1.05);
  box-shadow: 0 6px 18px rgba(47,230,222,0.6);
}

/* Reflection shine effect */
.reflect-btn::before {
  content: "";
  position: absolute;
  top: 0;
  left: -75%;
  width: 30%;
  height: 50%;
  background: linear-gradient(
    120deg,
    rgba(255,255,255,0.6) 0%,
    rgba(255,255,255,0.1) 60%,
    transparent 100%
  );
  transform: skewX(-20deg);
}

/* Animate shine */
.reflect-btn:hover::before {
  animation: shine 0.8s forwards;
}

@keyframes shine {
  0% { left: -75%; }
  100% { left: 125%; }
}


/*.alert-box {*/
/*    position: relative;*/
/*    background: #fff8e5;*/
/*    border: 1px solid #f5c518;*/
/*    padding: 15px 20px;*/
/*    margin: 15px 0;*/
/*    border-radius: 6px;*/
/*    font-family: Arial, sans-serif;*/
/*    box-shadow: 0 2px 6px rgba(0,0,0,0.1);*/
/*}*/

/* Success style for KYC submitted */
/*.alert-box#kyc-pending {*/
/*    background: #e8fbe8;*/
/*    border-color: #4CAF50;*/
/*}*/

/* Close button – fixed at edge */
.close-btn {
    position: absolute;
    top: -10px;   /* moves it outside the box */
    right: -10px; /* pushes to the edge */
    background: orange;
    color: #fff;
    font-size: 16px;
    font-weight: bold;
    width: 24px;
    height: 24px;
    line-height: 22px;
    text-align: center;
    border-radius: 50%;
    cursor: pointer;
    transition: 0.2s;
    z-index: 10000;
}

.close-btn:hover {
    background: #000;
}


    </style>
        <!-- Livewire Styles --><style >[wire\:loading][wire\:loading], [wire\:loading\.delay][wire\:loading\.delay], [wire\:loading\.inline-block][wire\:loading\.inline-block], [wire\:loading\.inline][wire\:loading\.inline], [wire\:loading\.block][wire\:loading\.block], [wire\:loading\.flex][wire\:loading\.flex], [wire\:loading\.table][wire\:loading\.table], [wire\:loading\.grid][wire\:loading\.grid], [wire\:loading\.inline-flex][wire\:loading\.inline-flex] {display: none;}[wire\:loading\.delay\.none][wire\:loading\.delay\.none], [wire\:loading\.delay\.shortest][wire\:loading\.delay\.shortest], [wire\:loading\.delay\.shorter][wire\:loading\.delay\.shorter], [wire\:loading\.delay\.short][wire\:loading\.delay\.short], [wire\:loading\.delay\.default][wire\:loading\.delay\.default], [wire\:loading\.delay\.long][wire\:loading\.delay\.long], [wire\:loading\.delay\.longer][wire\:loading\.delay\.longer], [wire\:loading\.delay\.longest][wire\:loading\.delay\.longest] {display: none;}[wire\:offline][wire\:offline] {display: none;}[wire\:dirty]:not(textarea):not(input):not(select) {display: none;}:root {--livewire-progress-bar-color: #ffffff;}[x-cloak] {display: none !important;}</style>
        
        
</head>

<body class="bg-[#0A0714] text-white min-h-screen">
    <!-- Add this loader HTML right after the body tag -->
<div id="site-loader" class="fixed inset-0 flex items-center justify-center bg-[#0A0714] z-50">
    <div class="flex flex-col items-center">
        <div class="w-32 h-32 mb-4">
              
<div class="logo-container">
    <h3 class="logo"><?php echo htmlspecialchars($siteName); ?></h3>
</div>
        </div>
        
    </div>
</div>
    <header class="w-full flex items-center justify-between p-4 bg-[#0F0A1F] border-b border-gray-800/50">
    
    <div class="flex items-center gap-4">
        
<div class="logo-container">
    <h3 class="logo"><?php echo htmlspecialchars($siteName); ?></h3>
</div>
    </div>

    
    <div class="flex items-center gap-2">
        
        
        
        
        
        
      
      
      
      
      
      
      
      
      
      
      
      
       <?php
$user_id = $user['id'] ?? $_SESSION['user_id'] ?? 0;

// Count unread messages (status=2, marked=0)
$countStmt = $pdo->prepare("SELECT COUNT(*) FROM message WHERE status=2  AND log_id=?");
$countStmt->execute([$user_id]);
$unreadCount = $countStmt->fetchColumn();

// Fetch last 5 messages
$msgStmt = $pdo->prepare("SELECT * FROM message WHERE status=2 AND log_id=? ORDER BY date DESC LIMIT 5");
$msgStmt->execute([$user_id]);
$latestMessages = $msgStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="relative" id="notificationDropdown">
    <!-- Bell Button -->
    <button id="notificationButton"
            class="relative p-2 text-gray-400 hover:text-gray-300 transition-colors rounded-xl hover:bg-[#1A1428]">
        <i class="fas fa-bell w-5 h-5"></i>
        <?php if ($unreadCount > 0): ?>
            <span class="absolute -top-1 -right-1 px-1.5 py-0.5 text-xs bg-red-500 text-white rounded-full">
                <?= $unreadCount ?>
            </span>
        <?php endif; ?>
    </button>

    <!-- Dropdown -->
    <div id="notificationMenu"
         class="absolute right-0 mt-2 w-80 bg-[#1A1428] rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">

        <div class="p-4">
            <div class="space-y-4">
                <?php if ($latestMessages): ?>
                    <?php foreach ($latestMessages as $msg): ?>
                        <div class="flex items-start gap-3 pb-4 border-b border-gray-800/50 last:border-0 last:pb-0">
                            <div class="w-8 h-8 flex-shrink-0 bg-[#2FE6DE]/10 rounded-xl flex items-center justify-center">
                                <i class="fas fa-bell text-[#2FE6DE] w-4 h-4"></i>
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm text-gray-300 truncate">
                                    <?= htmlspecialchars($msg['title'] ?? 'No title') ?>
                                </p>
                                <span class="text-xs text-gray-500">
                                    <?= htmlspecialchars(date("M d, Y H:i", strtotime($msg['date']))) ?>
                                </span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-gray-400 text-sm">No new messages</p>
                <?php endif; ?>
            </div>

            <div class="mt-4 pt-4 border-t border-gray-800/50">
                <a href="inbox.php"
                   class="block w-full bg-[#1A1428] text-[#2FE6DE] text-center text-sm font-medium px-4 py-2.5 rounded-xl hover:bg-[#2A243B] transition-colors">
                    View All Messages
                </a>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById("notificationButton").addEventListener("click", function(e) {
    e.stopPropagation();
    document.getElementById("notificationMenu").classList.toggle("hidden");
});

// Close dropdown if clicked outside
document.addEventListener("click", function(e) {
    const dropdown = document.getElementById("notificationMenu");
    if (!document.getElementById("notificationDropdown").contains(e.target)) {
        dropdown.classList.add("hidden");
    }
});
</script>










        
        <div class="relative" id="userDropdown">
            <button class="p-2 text-gray-400 hover:text-gray-300 transition-colors rounded-xl hover:bg-[#1A1428]">
                <i class="fas fa-user w-5 h-5"></i>
            </button>
            <div id="userMenu" 
                class="absolute right-0 mt-2 w-64 bg-[#1A1428] rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4 border-b border-gray-800/50">
                    <h3 class="font-medium truncate"><?php echo $fullname ?></h3>
                    <p class="text-sm text-gray-400 truncate"><?php echo $email?></p>
                </div>
                
                
                                <div class="p-4 border-b border-gray-800/50 bg-[#2A243B]/50">
                    <div class="flex items-center justify-between gap-2">
                        <span class="text-sm text-gray-400">Account Status</span>
                                                    <span class="text-xs font-medium px-2 py-1 bg-[#2FE6DE]/10 text-[#2FE6DE] rounded-lg">Verified</span>
                                            </div>
                </div>
                
                <div class="p-2">
                    <a href="profile.php" 
                                                class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:text-gray-300 rounded-lg hover:bg-[#2A243B] transition-colors">
                        <i class="fas fa-cog w-4 h-4"></i>
                        Settings
                    </a>
                    
                    
                    <a href="referals.php" 
                                                class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:text-gray-300 rounded-lg hover:bg-[#2A243B] transition-colors">
                        <i class="fas fa-cog w-4 h-4"></i>
                        My referrals
                    </a>
                   
                   
                    <form action="logout.php" method="POST">
                                            <button type="submit" 
                            class="w-full flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:text-gray-300 rounded-lg hover:bg-[#2A243B] transition-colors">
                            <i class="fas fa-sign-out-alt w-4 h-4"></i>
                            Logout
                        </button>
                    </form>
                </div>
                
                
                
            </div>
        </div>
    </div>
</header>





<?php if ($requireKYC2 && (int)$verified < 1): ?>
<div class="alert-box" id="kyc2-alert">
  <span class="close-btn" onclick="this.parentElement.style.display='none';">&times;</span>
  <p>⚠️ You must complete <strong>KYC Level 2</strong> to continue using your account. <br> 
     <a href="kyc2.php" class="reflect-btn">👉 Complete Now</a>
  </p>
</div>
<?php endif; ?>

<?php if ($requireKYC3 && (int)$verified == 1): ?>
<div class="alert-box" id="kyc3-alert">
  <span class="close-btn" onclick="this.parentElement.style.display='none';">&times;</span>
  <p>⚠️ You must complete <strong>KYC Level 3</strong> to continue using your account. <br> 
     <a href="kyc3.php" class="reflect-btn">👉 Complete Now</a>
  </p>
</div>
<?php endif; ?>

<?php if ((int)$verified == 2): ?>
<div class="alert-box" id="kyc-pending">
  <span class="close-btn" onclick="this.parentElement.style.display='none';">&times;</span>
 <p>✅ <strong>KYC Submitted.</strong><br>
     Your documents for <strong>KYC verification</strong> have been successfully submitted and are currently under review by our compliance team.</p>
    <p> Please allow some time for verification. If you would like to follow up, you may contact support below.   </p>
   
     <a href="support.php" class="reflect-btn">👉 Contact Support</a>
</div>
<?php endif; ?>



<script>
    // Dropdown toggles
    function setupDropdown(triggerId, menuId) {
        const trigger = document.getElementById(triggerId);
        const menu = document.getElementById(menuId);
        
        if (trigger && menu) {
            trigger.addEventListener('click', (e) => {
                e.stopPropagation();
                menu.classList.toggle('hidden');
            });

            document.addEventListener('click', () => {
                menu.classList.add('hidden');
            });
        }
    }

    // Setup all dropdowns
    document.addEventListener('DOMContentLoaded', function() {
        setupDropdown('reportsDropdown', 'reportsMenu');
    });
    
</script>
    
    
    
    
    
    
    
    
    
    
    <div class="flex">
        <aside class="hidden md:flex flex-col w-72 bg-[#0F0A1F] border-r border-gray-800/50 min-h-screen overflow-y-auto">
    
   
   
   
 <div class="p-6 border-b border-gray-800/50">
    <div class="flex items-center gap-4">
        <div class="w-12 h-12 rounded-xl bg-[#1A1428] flex-shrink-0 overflow-hidden flex items-center justify-center">
            <?php if (!empty($userRow['P_location']) && file_exists(__DIR__ . "/upload/photo/" . $userRow['P_location'])): ?>
                <!-- Show uploaded photo -->
                <img 
                    src="accounts/upload/photo/<?php echo htmlspecialchars($userRow['P_location']); ?>" 
                    alt="<?php echo htmlspecialchars($fullname); ?>"
                    class="w-full h-full object-cover">
            <?php else: ?>
                <!-- Show AI/Default avatar icon -->
                <i class="fas fa-user-circle text-gray-500 text-4xl"></i>
            <?php endif; ?>
        </div>
        <div class="flex-1 min-w-0">
            <h3 class="font-medium truncate"><?php echo htmlspecialchars($fullname); ?></h3>
            <p class="text-sm text-gray-400 truncate"><?php echo htmlspecialchars($email); ?></p>
        </div>
    </div>
</div>

    
    
    
    
    <div class="p-4 flex-1">
        <nav class="space-y-1">
            
            <div class="space-y-1 mb-6">
                
                
                           
                   <?php
$user_id = $user['id'] ?? $_SESSION['user_id'] ?? 0;

// Count unread messages (status=2, marked=0)
$countStmt = $pdo->prepare("SELECT COUNT(*) FROM message WHERE status=2 AND log_id=?");
$countStmt->execute([$user_id]);
$unreadCount = $countStmt->fetchColumn();

// Fetch only the most recent message
$msgStmt = $pdo->prepare("SELECT * FROM message WHERE status=2 AND log_id=? ORDER BY date DESC LIMIT 1");
$msgStmt->execute([$user_id]);
$latestMessage = $msgStmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="p-4 border-t border-gray-800/50">
    <?php if ($latestMessage): ?>
        <div class="bg-gradient-to-br from-[#2FE6DE]/20 to-transparent p-4 rounded-xl mb-4">
            <h4 class="font-medium text-[#2FE6DE] mb-2">
                <a href="support.php?id=<?= (int)$latestMessage['id'] ?>" 
                   class="hover:underline">
                    <?= htmlspecialchars($latestMessage['title'] ?? 'No title') ?>
                </a>
            </h4>
            <p class="text-sm text-gray-400 mb-3">
                <?= htmlspecialchars(mb_strimwidth($latestMessage['note'] ?? 'No message', 0, 100, '...')) ?>
            </p>
            <a href="inbox.php" 
               class="block w-full bg-gradient-to-r from-[#2FE6DE] to-[#2FE6DE]/80 text-black text-sm font-medium py-2.5 px-4 rounded-lg hover:brightness-110 transition-all text-center">
                View Inbox
            </a>
        </div>
    <?php else: ?>
        <p class="text-gray-400 text-sm">No recent messages.</p>
    <?php endif; ?>
</div>

                
                <a href="dashboard.php" 
                                        class="flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all bg-gradient-to-r from-[#2FE6DE]/10 to-transparent text-[#2FE6DE]">
                    <i class="fas fa-th-large w-5 h-5"></i>
                   <span>Dashboard</span>
                </a>

                
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Finance Management</p>
                    
                                        <a href="deposit.php" 
                                                class="flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all text-gray-400 hover:bg-[#1A1428] hover:text-gray-100">
                        <i class="fas fa-arrow-down w-5 h-5"></i>
                        <span>Deposit</span>
                    </a>
                    
                                        <a href="withdraw.php" 
                                                class="flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all text-gray-400 hover:bg-[#1A1428] hover:text-gray-100">
                        <i class="fas fa-arrow-up w-5 h-5"></i>
                        <span>Withdraw</span>
                    </a>
                    
                                        <a href="transactions.php" 
                                                class="flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all text-gray-400 hover:bg-[#1A1428] hover:text-gray-100">
                        <i class="fas fa-receipt w-5 h-5"></i>
                        <span>Transactions</span>
                    </a>
                    
                                    </div>









 
                
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Live/Demo Trade</p>

                                        <div x-data="{ open: false }">
                                            
                                            
                        <button @click="open = !open" 
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                            :class="{'bg-gradient-to-r from-[#2FE6DE]/10 to-transparent text-[#2FE6DE]': open, 'text-gray-400 hover:bg-[#1A1428] hover:text-gray-100': !open}">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-chart-line w-5 h-5"></i>
                                <span>Live/Demo Trade</span>
                            </div>
                            <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        
                        
                        
                        <div x-show="open" 
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 -translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            class="pl-12 mt-1 space-y-1">
                                            <a href="live_trade.php" 
                                                                class="flex items-center gap-3 px-4 py-2 rounded-xl transition-all text-gray-400 hover:text-gray-100">
                                Live Trade
                            </a>
                                                                                    <a href="demo_trade.php" 
                                                                class="flex items-center gap-3 px-4 py-2 rounded-xl transition-all text-gray-400 hover:text-gray-100">
                                Demo Trade
                            </a>
                            
                            
                             <a href="trade_logs.php" 
                                                                class="flex items-center gap-3 px-4 py-2 rounded-xl transition-all text-gray-400 hover:text-gray-100">
                                Trade History
                            </a>
                                                    </div>
                    </div>
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Trading &amp; Signals</p>

                                        <div x-data="{ open: false }">
                                            
                                            
                        <button @click="open = !open" 
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                            :class="{'bg-gradient-to-r from-[#2FE6DE]/10 to-transparent text-[#2FE6DE]': open, 'text-gray-400 hover:bg-[#1A1428] hover:text-gray-100': !open}">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-chart-line w-5 h-5"></i>
                                <span>Signal Plans</span>
                            </div>
                            <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        
                        
                        
                        <div x-show="open" 
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 -translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            class="pl-12 mt-1 space-y-1">
                                            <a href="buy_signal.php" 
                                                                class="flex items-center gap-3 px-4 py-2 rounded-xl transition-all text-gray-400 hover:text-gray-100">
                                Buy Signals
                            </a>
                                                                                    <a href="my_signals.php" 
                                                                class="flex items-center gap-3 px-4 py-2 rounded-xl transition-all text-gray-400 hover:text-gray-100">
                                My Signals
                            </a>
                            
                            
                             <a href="trade_logs.php" 
                                                                class="flex items-center gap-3 px-4 py-2 rounded-xl transition-all text-gray-400 hover:text-gray-100">
                                Trade History
                            </a>
                                                    </div>
                    </div>
                    
                     
                <!--                <div x-data="{ open: false }">-->
                <!--    <button @click="open = !open" -->
                <!--     class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"-->
                <!--    :class="{'bg-gradient-to-r from-[#2FE6DE]/10 to-transparent text-[#2FE6DE]': open, 'text-gray-400 hover:bg-[#1A1428] hover:text-gray-100': !open}">-->
                <!--        <div class="flex items-center gap-3">-->
                <!--            <i data-lucide="repeat" class="w-5 h-5"></i>-->
                <!--           Swap Crypto-->
                <!--        </div>-->
                <!--        <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>-->
                <!--    </button>-->
                <!--    <div x-show="open" class="pl-11 mt-1 space-y-1" x-collapse>-->
                <!--        <a href="assets.php" -->
                <!--                                        class="block px-3 py-2 text-gray-400 rounded-lg hover:bg-[#1A1428] transition-colors">-->
                <!--             Assets-->
                <!--        </a>-->
                <!--        <a href="swap_transactions.php" -->
                <!--                                        class="block px-3 py-2 text-gray-400 rounded-lg hover:bg-[#1A1428] transition-colors">-->
                <!--            Swap History-->
                <!--        </a>-->
                <!--    </div>-->
                <!--</div>-->
                
                
                <!--<div x-data="{ open: false }">-->
                <!--    <button @click="open = !open" -->
                <!--        class="w-full flex items-center justify-between px-4 py-2.5 rounded-xl transition-all text-gray-400 hover:bg-[#1A1428] hover:text-gray-100">-->
                <!--        <div class="flex items-center gap-3">-->
                <!--            <i class="fas fa-chart-line w-5 h-5"></i>-->
                <!--            <span>Trading</span>-->
                <!--        </div>-->
                <!--        <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>-->
                <!--    </button>-->
                    
                <!--    <div x-show="open" -->
                <!--        x-transition:enter="transition ease-out duration-200"-->
                <!--        x-transition:enter-start="opacity-0 -translate-y-2"-->
                <!--        x-transition:enter-end="opacity-100 translate-y-0"-->
                <!--        x-transition:leave="transition ease-in duration-150"-->
                <!--        x-transition:leave-start="opacity-100 translate-y-0"-->
                <!--        x-transition:leave-end="opacity-0 -translate-y-2"-->
                <!--        class="pl-12 mt-1 space-y-1">-->
                        
                <!--        <a href="trading.php" -->
                <!--                                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all text-gray-400 hover:bg-[#1A1428]/50 hover:text-gray-100">-->
                <!--            Overview-->
                <!--        </a>-->
                        
                <!--        <a href="trade.php" -->
                <!--                                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all text-gray-400 hover:bg-[#1A1428]/50 hover:text-gray-100">-->
                <!--            Trade-->
                <!--        </a>-->
                        
                <!--        <a href="copy.php" -->
                <!--                                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all text-gray-400 hover:bg-[#1A1428]/50 hover:text-gray-100">-->
                <!--            Copy Trading-->
                <!--        </a>-->
                        
                <!--        <a href="bots.php" -->
                <!--                                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all text-gray-400 hover:bg-[#1A1428]/50 hover:text-gray-100">-->
                <!--            Signal Trading-->
                <!--        </a>-->
                        
                <!--        <a href="history.php" -->
                <!--                                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all text-gray-400 hover:bg-[#1A1428]/50 hover:text-gray-100">-->
                <!--            History-->
                <!--        </a>-->
                <!--    </div>-->
                <!--</div>-->
                

                
                
               <div class="space-y-1">
                            <p class="px-4 text-xs font-medium text-gray-400 uppercase mb-2">Account</p>

                                                        <a href="referral.php" 
                                                                class="flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all text-gray-400 hover:bg-[#1A1428] hover:text-gray-100">
                                <i class="fas fa-users w-5 h-5"></i>
                                <span>Referrals</span>
                            </a>
                             
                
                
                
                
                 <div x-data="{ open: false }">
                    <button @click="open = !open" 
                        class="w-full flex items-center justify-between px-4 py-2.5 rounded-xl transition-all text-gray-400 hover:bg-[#1A1428] hover:text-gray-100">
                        <div class="flex items-center gap-3">
                            <i class="fas fa-bell w-5 h-5"></i>
                            <span>Notifications</span>
                        </div>
                        <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                    </button>
                    
                    <div x-show="open" 
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2"
                        class="pl-12 mt-1 space-y-1">
                        
                        <a href="inbox.php" 
                                                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all text-gray-400 hover:bg-[#1A1428]/50 hover:text-gray-100">
                            Inbox
                        </a>
                        
                        <a href="outbox.php" 
                                                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all text-gray-400 hover:bg-[#1A1428]/50 hover:text-gray-100">
                            Outbox
                        </a>
                        
                        
                        
                        <a href="support.php" 
                                                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all text-gray-400 hover:bg-[#1A1428]/50 hover:text-gray-100">
                            Compose
                        </a>
                    </div>
                </div>


            <div x-data="{ open: false }">
                <form action="logout.php" method="POST">
                      <button type="submit" 
                        class="block w-full bg-gradient-to-r from-[red] to-[#2FE6DE]/80 text-black text-sm font-medium py-2.5 px-4 rounded-lg hover:brightness-110 transition-all text-center">
                        <i class="fas fa-sign-out-alt w-5 h-5"></i>
                        <span>Logout</span>
                    </button>
                </form> </div>




                                                       
                                                    </div>
                                                    
                
                
                
                
                
                
                
                          
                              
                                </div>

                
              
            </div>
             
    
        </nav>
    </div>
</aside>  

