<?php
require '../config.php';
require 'header.php';

$user_id = $_SESSION['SESS_USERID'] ?? 0;

// Fetch available payment methods
$stmt = $pdo->prepare("SELECT * FROM payment_methods WHERE status = 1 ORDER BY name ASC");
$stmt->execute();
$methods = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<main class="flex-1 px-4 py-6">
    <main class="flex-1 px-2 py-2 md:p-4 pb-20 md:pb-6 overflow-hidden">
        <div class="bg-[#0F0A1F] rounded-xl sm:rounded-2xl">
            <div class="p-3 sm:p-6 border-b border-gray-800/50">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg sm:text-xl font-medium">Make a Deposit</h2>
                    <a href="transactions.php" 
                       class="flex items-center gap-1 sm:gap-2 text-xs sm:text-sm text-gray-400 hover:text-[#2FE6DE] transition-colors group">
                        <i data-lucide="history" class="w-3 h-3 sm:w-4 sm:h-4"></i>
                        <span class="hidden sm:inline">Transaction History</span>
                        <span class="sm:hidden">History</span>
                        <i data-lucide="arrow-right" class="w-3 h-3 sm:w-4 sm:h-4 group-hover:translate-x-1 transition-transform"></i>
                    </a>
                </div>
            </div>

          <form action="deposit_details.php" method="GET" class="space-y-6" id="depositForm">

                <!-- Amount -->
                <div>
                    <label class="block text-sm text-gray-400 mb-2">Amount to Deposit</label>
                    <div class="relative bg-[#1A1428] rounded-xl p-3">
                        <span class="absolute left-4 top-1/2 -translate-y-1/2 text-lg font-medium text-[#2FE6DE]"><?php echo $user['cur_symbol'] ?? '$'; ?></span>
                        <input 
                            type="number" 
                            name="amount"
                            min="100.00"
                            placeholder="Enter amount..."
                            class="w-full bg-transparent pl-8 pr-4 py-3 text-lg font-medium focus:outline-none placeholder-gray-600"
                            required
                        >
                        <div class="absolute right-4 top-1/2 -translate-y-1/2 text-xs px-2 py-1 bg-[#2FE6DE]/10 text-[#2FE6DE] rounded-lg">
                            Min: <?php echo $user['cur_symbol'] ?? '$'; ?>100.00
                        </div>
                    </div>
                </div>



              <!-- Payment Methods -->
<div>
    <label class="block text-sm text-gray-400 mb-3">Select Payment Method</label>
    <div class="grid gap-4 sm:grid-cols-2">
        <?php foreach ($methods as $method): ?>
            <label class="relative block w-full cursor-pointer group">
                <input type="radio" name="method_id" value="<?= $method['id'] ?>" class="sr-only peer" required>
                <div class="rounded-xl border border-gray-700 bg-[#0F0A1F] p-4 transition-all 
                            peer-checked:border-[#2FE6DE] peer-checked:bg-[#2FE6DE]/10 
                            peer-checked:ring-2 peer-checked:ring-[#2FE6DE]/40 
                            peer-checked:shadow-lg peer-checked:shadow-[#2FE6DE]/20 
                            peer-checked:scale-[1.02]">
                    <div class="flex items-center gap-4">
                        <!-- Logo -->
                        <div class="w-12 h-12 flex items-center justify-center bg-gray-800/50 rounded-lg">
                            <img src="../<?= htmlspecialchars($method['logo']) ?>" alt="<?= htmlspecialchars($method['name']) ?>" class="w-8 h-8">
                        </div>
                        <!-- Name + Rate -->
                        <div class="flex-1">
                            <p class="font-medium text-base text-white"><?= htmlspecialchars($method['name']) ?></p>
                            <div class="flex items-center gap-1 text-xs text-gray-400">
                                <i class="fas fa-bolt"></i>
                                Instant Processing
                            </div>
                            <div class="flex items-center gap-2 text-xs text-gray-400 mt-1">
                                <i class="fas fa-exchange-alt"></i>
                                1 USD ≈ 
                                <span class="font-mono text-[#2FE6DE]">
                                    <?= number_format($method['rate_in_usd'], 8) ?> <?= htmlspecialchars($method['name']) ?>
                                </span>
                            </div>
                        </div>
                        <!-- Custom Circle -->
                        <div class="w-5 h-5 rounded-full border-2 border-gray-600 flex items-center justify-center peer-checked:border-[#2FE6DE]">
                            <div class="w-3 h-3 rounded-full bg-[#2FE6DE] hidden peer-checked:block"></div>
                        </div>
                    </div>
                </div>
            </label>
        <?php endforeach; ?>
    </div>
</div>


                <!-- Submit -->
                <div>
                    <button type="submit" id="submitBtn"
                        class="w-full bg-gradient-to-r from-[#2FE6DE] to-[#2FE6DE]/80 text-black font-medium py-4 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-2 disabled:opacity-50 disabled:cursor-not-allowed"
                        disabled>
                        Continue to Payment
                        <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </form>

            <!-- Recent Activity -->
            <div class="bg-[#0F0A1F] rounded-xl sm:rounded-2xl mt-3 sm:mt-6 mb-6 sm:mb-10 md:mb-1">
                <div class="flex flex-wrap">
                    <div class="w-full md:w-1/2 p-3 sm:p-6">
                        <div class="flex items-center gap-2 sm:gap-4">
                            <div class="w-10 h-10 sm:w-14 sm:h-14 flex items-center justify-center bg-[#1A1428] rounded-lg sm:rounded-xl">
                                <i class="fas fa-history text-lg sm:fa-2x text-[#2FE6DE]"></i>
                            </div>
                            <div>
                                <h3 class="text-base sm:text-lg font-medium">Recent Activity</h3>
                                <a href="transactions.php" 
                                   class="text-sm sm:text-base text-[#2FE6DE] hover:underline">
                                    <span class="hidden sm:inline">View All Transactions</span>
                                    <span class="sm:hidden">View All</span>
                                    →
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</main>

<script>
    // Enable submit only when a method is selected
    const radios = document.querySelectorAll('input[name="method_id"]');
    const submitBtn = document.getElementById('submitBtn');

    radios.forEach(radio => {
        radio.addEventListener('change', () => {
            submitBtn.disabled = false;
        });
    });
</script>

<?php require 'footer.php'; ?>
