<?php
// demo_trade.php
require("header.php");
?>
<main class="p-6 bg-[#0F0A1F] min-h-screen text-white">
    <div class="max-w-3xl mx-auto bg-[#1A1428] rounded-xl p-6">
        <h2 class="text-xl mb-4">Demo Trading</h2>
        <p class="mb-4">This is demo mode: trades are simulated locally and will not affect your real account.</p>

        <label class="block mb-2">Pair</label>
        <select id="demoPair" class="w-full mb-3 p-2 bg-[#0F0A1F] rounded">
            <option>BTC/USD</option>
            <option>ETH/USD</option>
        </select>

        <div class="grid grid-cols-2 gap-2 mb-3">
            <input id="demoTP" placeholder="T-P" class="p-2 bg-[#0F0A1F] rounded" />
            <input id="demoSL" placeholder="S-L" class="p-2 bg-[#0F0A1F] rounded" />
        </div>

        <label class="block mb-2">Amount</label>
        <input id="demoAmount" type="number" class="w-full p-2 mb-3 bg-[#0F0A1F] rounded" />

        <div class="flex gap-2">
            <button id="demoBuy" class="bg-green-500 text-black px-4 py-2 rounded">Buy (Demo)</button>
            <button id="demoSell" class="bg-red-500 text-black px-4 py-2 rounded">Sell (Demo)</button>
        </div>

        <div id="demoLog" class="mt-4 text-sm"></div>
    </div>

<script>
document.getElementById('demoBuy').addEventListener('click', () => runDemo('buy'));
document.getElementById('demoSell').addEventListener('click', () => runDemo('sell'));

function runDemo(side) {
    const pair = document.getElementById('demoPair').value;
    const tp = parseFloat(document.getElementById('demoTP').value) || 0;
    const sl = parseFloat(document.getElementById('demoSL').value) || 0;
    const amount = parseFloat(document.getElementById('demoAmount').value) || 0;
    const now = new Date().toISOString();
    const log = document.getElementById('demoLog');
    if (!amount || amount <= 0) { alert('Enter amount'); return; }
    log.innerHTML = `<div>Demo ${side.toUpperCase()} ${pair} amount $${amount} at ${now} (TP:${tp} SL:${sl})</div>` + log.innerHTML;
}
</script>
</main>
<?php require("footer.php"); ?>
