 <?php require ("header.php") ?>



<!--============START====SELL===========================-->

<?php


if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action_S'])) { 

    // Ensure user is logged in
    if (!isset($_SESSION['SESS_USERID'])) {
        echo "Error: User not logged in!";
        exit();
    }

    $userId = $_SESSION['SESS_USERID'];

    // Fetch user balance and email
    $stmt = $pdo->prepare("SELECT balance, email FROM logins WHERE id = :id");
    $stmt->execute(['id' => $userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo "Error: User not found!";
        exit();
    }

    // Assign balance and email
    $user_bal = floatval($user['balance']);
    $email = $user['email'];

    // Sanitize & validate input
    $tamount = isset($_POST['tamount']) ? floatval($_POST['tamount']) : 0;
    $plan = $_POST['plan'] ?? '';
    $asset = $_POST['asset'] ?? '';
    $lots = intval($_POST['lots'] ?? 0);
    $time = $_POST['time'] ?? '';
    $signa = $_POST['signa'] ?? '';
    $optionr = $_POST['optionr'] ?? '';
    $entrytime = $_POST['date'] ?? '';
    $expiryt = $_POST['expiryt'] ?? '';
    $user_rate = isset($_POST['user_rate']) ? floatval($_POST['user_rate']) : 1;
    $user_cur = $_POST['user_cur'] ?? '';
    $user_iprofit = isset($_POST['user_iprofit']) ? floatval($_POST['user_iprofit']) : 0;

    // Ensure all required values are provided
    // if ($tamount <= 0 || empty($asset) || empty($plan) || empty($entrytime) || empty($expiryt)) {
    //     echo "<script>alert('Invalid input values!'); window.location.href = 'index.php';</script>";
    //     exit();
    // }

    // Debugging: Print values
    // echo "<pre>";
    // echo "User ID: $userId\n";
    // echo "Balance: $user_bal\n";
    // echo "Trade Amount: $tamount\n";
    // echo "User Rate: $user_rate\n";
    // echo "</pre>";

    // Generate random rates
    $renterr = mt_rand(100000, 150000) / 100000;
    $rrate = mt_rand(100000, 150000) / 100000;

    // Calculate new balance
    $bala = $user_bal - $tamount;

    if ($user_bal >= $tamount) {
        try {
            // Begin transaction
            $pdo->beginTransaction();

            // Insert trade record
            $sql = $pdo->prepare("INSERT INTO trade (log_id, email, asset, lot, optionr, invested, duratn, entryrate, rate, entrytime, expirytime, status, user_cur, user_bal, user_iprofit, signa, returnr, plan, date, user_rate) 
                VALUES (:id, :email, :asset, :lots, :optionr, :tamount, :time, :renterr, :rrate, :entrytime, :expiryt, 0, :user_cur, :bala, :user_iprofit, :signa, 0.00, :plan, :entrytime, :user_rate)");

            $tradeSuccess = $sql->execute([
                'id' => $userId,
                'email' => $email,
                'asset' => $asset,
                'lots' => $lots,
                'optionr' => $optionr,
                'tamount' => $tamount,
                'time' => $time,
                'renterr' => $renterr,
                'rrate' => $rrate,
                'entrytime' => $entrytime,
                'expiryt' => $expiryt,
                'user_cur' => $user_cur,
                'bala' => $bala,
                'user_iprofit' => $user_iprofit,
                'signa' => $signa,
                'plan' => $plan,
                'user_rate' => $user_rate
            ]);

            if ($tradeSuccess) {
                // Update user balance
                $update = $pdo->prepare("UPDATE logins SET balance = :bala, trade_amt = :tamount WHERE id = :id");
                $update->execute([
                    'bala' => $bala,
                    'tamount' => $tamount,
                    'id' => $userId
                ]);

                // Commit transaction
                $pdo->commit();

                echo "<script>
                    alert('You have (SOLD) a Trade successfully!!!');
                    window.location.href = 'trade_history.php';
                </script>";
            } else {
                throw new Exception("Trade insertion failed.");
            }
        } catch (Exception $e) {
            $pdo->rollBack();
            echo "<script>alert('Error: " . $e->getMessage() . "');</script>";
        }
    } else {
        echo "<script>
            alert('Insufficient balance!');
            window.location.href = 'index.php';
        </script>";
    }
}
?>



<!--============END====SELL===========================-->




<!--============START====BUY===========================-->

<?php


if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action_B'])) { 

    // Ensure user is logged in
    if (!isset($_SESSION['SESS_USERID'])) {
        echo "Error: User not logged in!";
        exit();
    }

    $userId = $_SESSION['SESS_USERID'];

    // Fetch user balance and email
    $stmt = $pdo->prepare("SELECT balance, email FROM logins WHERE id = :id");
    $stmt->execute(['id' => $userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo "Error: User not found!";
        exit();
    }

    // Assign balance and email
    $user_bal = floatval($user['balance']);
    $email = $user['email'];

    // Sanitize & validate input
    $tamount = isset($_POST['tamount']) ? floatval($_POST['tamount']) : 0;
    $plan = $_POST['plan'] ?? '';
    $asset = $_POST['asset'] ?? '';
    $lots = intval($_POST['lots'] ?? 0);
    $time = $_POST['time'] ?? '';
    $signa = $_POST['signa'] ?? '';
    $optionr = $_POST['optionr'] ?? '';
    $entrytime = $_POST['date'] ?? '';
    $expiryt = $_POST['expiryt'] ?? '';
    $user_rate = isset($_POST['user_rate']) ? floatval($_POST['user_rate']) : 1;
    $user_cur = $_POST['user_cur'] ?? '';
    $user_iprofit = isset($_POST['user_iprofit']) ? floatval($_POST['user_iprofit']) : 0;

    // Ensure all required values are provided
    // if ($tamount <= 0 || empty($asset) || empty($plan) || empty($entrytime) || empty($expiryt)) {
    //     echo "<script>alert('Invalid input values!'); window.location.href = 'index.php';</script>";
    //     exit();
    // }

    // Debugging: Print values
    // echo "<pre>";
    // echo "User ID: $userId\n";
    // echo "Balance: $user_bal\n";
    // echo "Trade Amount: $tamount\n";
    // echo "User Rate: $user_rate\n";
    // echo "</pre>";

    // Generate random rates
    $renterr = mt_rand(100000, 150000) / 100000;
    $rrate = mt_rand(100000, 150000) / 100000;

    // Calculate new balance
    $bala = $user_bal - $tamount;

    if ($user_bal >= $tamount) {
        try {
            // Begin transaction
            $pdo->beginTransaction();

            // Insert trade record
            $sql = $pdo->prepare("INSERT INTO trade (log_id, email, asset, lot, optionr, invested, duratn, entryrate, rate, entrytime, expirytime, status, user_cur, user_bal, user_iprofit, signa, returnr, plan, date, user_rate) 
                VALUES (:id, :email, :asset, :lots, :optionr, :tamount, :time, :renterr, :rrate, :entrytime, :expiryt, 0, :user_cur, :bala, :user_iprofit, :signa, 0.00, :plan, :entrytime, :user_rate)");

            $tradeSuccess = $sql->execute([
                'id' => $userId,
                'email' => $email,
                'asset' => $asset,
                'lots' => $lots,
                'optionr' => $optionr,
                'tamount' => $tamount,
                'time' => $time,
                'renterr' => $renterr,
                'rrate' => $rrate,
                'entrytime' => $entrytime,
                'expiryt' => $expiryt,
                'user_cur' => $user_cur,
                'bala' => $bala,
                'user_iprofit' => $user_iprofit,
                'signa' => $signa,
                'plan' => $plan,
                'user_rate' => $user_rate
            ]);

             if ($tradeSuccess) {
                // Update user balance
                $update = $pdo->prepare("UPDATE logins SET balance = :bala, trade_amt = :tamount WHERE id = :id");
                $update->execute([
                    'bala' => $bala,
                    'tamount' => $tamount,
                    'id' => $userId
                ]);

                // Commit transaction
                $pdo->commit();

                echo "<script>
                    alert('You have (BOUGHT) a Trade successfully!!!');
                    window.location.href = 'trade_history.php';
                </script>";
            } else {
                throw new Exception("Trade insertion failed.");
            }
        } catch (Exception $e) {
            $pdo->rollBack();
            echo "<script>alert('Error: " . $e->getMessage() . "');</script>";
        }
    } else {
        echo "<script>
            alert('Insufficient balance!');
            window.location.href = 'index.php';
        </script>";
    }
}
?>


<!--============END==BUY=================================-->







 <main class="flex-1 px-2 py-2 md:p-4 pb-20 md:pb-6 overflow-hidden">
                    <div wire:snapshot="{&quot;data&quot;:[],&quot;memo&quot;:{&quot;id&quot;:&quot;6KkP9w28Qxekv3zojj2M&quot;,&quot;name&quot;:&quot;user.dashboard&quot;,&quot;path&quot;:&quot;user\/dashboard&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;children&quot;:[],&quot;scripts&quot;:[],&quot;assets&quot;:[],&quot;errors&quot;:[],&quot;locale&quot;:&quot;en&quot;},&quot;checksum&quot;:&quot;77c0c890687fb9b1d844fa6d892046d87b4aee4c20d2c8699d89a0c346fa2139&quot;}" wire:effects="[]" wire:id="6KkP9w28Qxekv3zojj2M" class="md:mt-3 mt-2 md:mb-2 mb-4 max-w-full overflow-hidden"></div>
    
    <div>
<!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->
</div>

    <div>
<!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->
</div>











        <!--================ALERT==BOARD=======================-->

 <?php
// Ensure user session is set
if (!isset($_SESSION['SESS_USERID'])) {
    die("Unauthorized access!");
}

$id = $_SESSION['SESS_USERID'];

// Fetch user details securely
$stmt = $pdo->prepare("SELECT nztitle, nznote, newz FROM logins WHERE id = :id");
$stmt->execute(['id' => $id]);
$userData = $stmt->fetch(PDO::FETCH_ASSOC);

if ($userData) {
    $nztitle = htmlspecialchars($userData['nztitle']);
    $nznote = htmlspecialchars($userData['nznote']);
    $newz = $userData['newz'];
}
?>

<!-- Include the news widget script only if newz == 1 -->
<?php if (!empty($newz) && $newz == 1): ?>
    <script type="text/javascript" src="news/embede/sttwidget.min.js"></script>
<?php endif; ?>


    
<div id="SttHeadlineNews_unique_ID"></div>
<script type="text/javascript">
        new SttHeadlineNews().create({
            width: "100%",
            height: "20px",
            title: "<?php echo ($nztitle) ?>", // Banner Title portion
            titleBackground: "e31238", // Background color of the title
            titleColor: "fff", // Text color of the title
            headline: "<?php echo ($nznote) ?>", // Banner content portion
            headlineBackground: "blue", // Background color of the Headline title
            headlineColor: "000", // Text color of the Headline title
            // textLink: "index.php", 
            // Target link to send visitors to
            asynchTarget: "SttHeadlineNews_unique_ID", // ID of the HTML element where this widget get displayed
        });
</script>    


<!--============END=============================================-->









<?php

// Ensure user is logged in
if (!isset($_SESSION['SESS_USERID'])) {
    echo "<script>alert('Error: User not logged in!'); window.location.href='dashboard.php';</script>";
    exit();
}

$userId = $_SESSION['SESS_USERID'];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    try {
        // Fetch user info
        $stmt = $pdo->prepare("SELECT username, balance, iprofit, cur_symbol, `switch` FROM logins WHERE id = ?");
        $stmt->execute([$userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            echo "<script>alert('Error: User not found.'); window.location.href='dashboard.php';</script>";
            exit();
        }
        $username = htmlspecialchars($user['username']);
        $balance  = floatval($user['balance']);
        $iprofit  = floatval($user['iprofit']);
        $currency = $user['cur_symbol'];
        $locked   = intval($user['switch']); // 1 = blocked, 0 = allowed

        // SweetAlert helper function
        function showAlert($icon, $title, $text, $redirect = 'dashboard.php') {
            echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";
            echo "<script>
                Swal.fire({
                    icon: '{$icon}',
                    title: '{$title}',
                    text: '{$text}',
                    confirmButtonText: 'OK'
                }).then(() => { window.location.href = '{$redirect}'; });
            </script>";
        }

        // Case: blocked by system → two buttons: Cancel / Support
        if ($locked === 1) {
            echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Transfer Blocked',
                    text: 'Hello {$username}, your profit transfer is blocked by the system.',
                    showCancelButton: true,
                    confirmButtonText: 'Support',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href='support.php';
                    } else {
                        window.location.href='dashboard.php';
                    }
                });
            </script>";
            exit();
        }
      // ==========================
        // SWITCH = 0 → Allowed
        // ==========================
        if ($locked === 0) {

            // No profit to transfer
            if ($iprofit <= 0) {
                echo "<script>
                    Swal.fire({
                        icon: 'info',
                        title: 'No Profit',
                        text: 'Hello {$username}, you have no locked profits to transfer.',
                        confirmButtonText: 'OK'
                    }).then(() => { window.location.href='dashboard.php'; });
                </script>";
                exit();
            }

            // Transfer all iprofit → balance
            $new_balance = $balance + $iprofit;
            $update = $pdo->prepare("UPDATE logins SET balance = ?, iprofit = 0 WHERE id = ?");
            $update->execute([$new_balance, $userId]);

            // Show success popup
            echo "<script>
                Swal.fire({
                    icon: 'success',
                    title: 'Transfer Successful',
                    text: 'Hello {$username}, transferred {$currency}" . number_format($iprofit, 2) . " from locked profits to balance.',
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#FF9800'
                }).then(() => { window.location.href='dashboard.php'; });
            </script>";
            exit();
        }

    } catch (Exception $e) {
        error_log('Transfer Error: ' . $e->getMessage());
        showAlert('error', 'Error', 'An unexpected error occurred. Please try again.');
        exit();
    }
}
?>






<!--==========END=TRANSFER=============================-->
    
    <!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><!--[if ENDBLOCK]><![endif]-->

    
    <div class="grid gap-3 md:gap-4 lg:grid-cols-12">
        
        <div class="lg:col-span-5 space-y-4 md:space-y-6">
            
            <div class="bg-[#0F0A1F]/80 backdrop-blur-sm rounded-2xl p-3 md:p-4 shadow-lg border border-gray-800/20 hover:border-[#2FE6DE]/10 transition-all duration-300">
                
                
                
         <div class="bg-gradient-to-r from-[#2FE6DE]/10 to-transparent rounded-xl p-3 md:p-4 mb-4 md:mb-6 relative overflow-hidden">
    <div class="relative z-10">
        <!-- Header -->
        <div class="flex items-center justify-between mb-2">
            <div class="min-w-0 flex-1">
                <div class="text-xs md:text-sm text-gray-400">Account Overview</div>
                <div class="text-lg md:text-xl font-medium truncate">
                    Hello <?php echo htmlspecialchars($fullname); ?>!
                </div>
            </div>
            <button id="toggleBalance" class="text-gray-400 hover:text-[#2FE6DE] transition-colors p-1.5 md:p-2 rounded-full hover:bg-[#2FE6DE]/10 flex-shrink-0">
                <i id="toggleIcon" class="fas fa-eye w-4 h-4 md:w-5 md:h-5"></i>
            </button>
        </div>

        <!-- Balance Section -->
        <div class="mt-3 md:mt-4">
            <div class="flex items-center justify-between">
                <div>
                    <div class="text-xs md:text-sm text-gray-400">Available Balance</div>
                    <div class="text-2xl md:text-3xl font-bold text-[#2FE6DE] break-all">
                        <span id="balanceAmount"><?php echo htmlspecialchars($cur_symbol) ?> <?php echo htmlspecialchars($balc) ?></span>
                        <span id="balanceHidden" class="hidden">******</span>
                    </div>
                </div>
                <!-- Withdraw Button -->
                 <form method="POST" action="withdraw.php">
                <button class="ml-4 bg-[#2FE6DE] text-black text-sm md:text-base px-4 py-2 rounded-lg hover:bg-[#27c5be] transition-colors flex items-center gap-2">
                    <i class="fas fa-wallet"></i>
                    Withdraw
                </button>
                </form>
            </div>
        </div>

        <!-- Locked Profit Section -->
        <div class="mt-3">
            <div class="flex items-center justify-between">
                
                
                <div>
                    <div class="text-xs md:text-sm text-gray-400 flex items-center">
                        <i class="fas fa-lock text-amber-400 mr-1 text-xs"></i>
                        P/L Balance
                    </div>
                    <div class="text-lg md:text-xl font-bold text-amber-400 break-all">
                        <span id="lockedBalanceAmount"><?php echo $cur_symbol ?><?php echo $iprof ?></span>
                        <span id="lockedBalanceHidden" class="hidden">******</span>
                    </div>
                </div>
                <!-- Transfer Button -->
               
                
                
            <form method="POST" action="">
    <button type="submit"
        class="ml-4 bg-orange-500 text-white text-sm md:text-base px-4 py-2 rounded-lg hover:bg-orange-600 transition-colors flex items-center gap-2">
        <i class="fas fa-exchange-alt"></i>
        Transfer
    </button>
</form>

            </div>
            
            <p class="text-gray-300">Press confirm to transfer all your locked profit to balance.</p>
            
        </div>
    </div>
</div>




<?php
// Assuming session already started in header.php
$userId   = $_SESSION['SESS_USERID'] ?? 0;

// Fetch logged in user info
$stmt = $pdo->prepare("SELECT id, username FROM logins WHERE id = ?");
$stmt->execute([$userId]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Base URL (update to your domain root dynamically if needed)
$url = "{$url}auth/"; 

// Build referral link -> register.php?id={username}
$refLink = $user ? $url . "register.php?id=" . urlencode($user['username']) : $url . "register.php";
?>

<h3 class="text-base font-medium mb-3 flex items-center gap-2">
    <i class="fas fa-link text-[#2FE6DE]"></i>
    Your referral link
</h3>
<div class="p-3 bg-[#1A1428] rounded-xl">
    <div class="flex items-center gap-2">
        <input
            id="referralInput"
            type="text"
            value="<?= htmlspecialchars($refLink) ?>"
            readonly
            class="flex-1 bg-[#2A243B] rounded-lg px-3 py-2 text-xs border border-gray-800 focus:ring-[#2FE6DE] focus:border-[#2FE6DE] min-w-0"
        >
        <button 
            id="copyReferralBtn"
            type="button"
            class="bg-gradient-to-r from-[#2FE6DE] to-[#2FE6DE]/80 text-black px-3 py-2 rounded-lg hover:brightness-110 transition-all flex items-center gap-1 whitespace-nowrap shadow-md shadow-[#2FE6DE]/10 flex-shrink-0"
        >
            <i class="fas fa-copy text-sm"></i>
            <span class="text-sm">Copy</span>
        </button>
    </div>
</div>

<script>
document.getElementById('copyReferralBtn').addEventListener('click', function() {
    let input = document.getElementById('referralInput');
    input.select();
    input.setSelectionRange(0, 99999); // For mobile devices
    navigator.clipboard.writeText(input.value).then(function() {
        alert("Referral link copied: " + input.value);
    });
});
</script>




                
                <div class="grid grid-cols-2 gap-2 md:gap-4">
                    <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 hover:bg-[#2A243B] transition-all duration-300 group border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex items-center gap-2 md:gap-3 mb-2">
                            <div class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center bg-[#2FE6DE]/10 rounded-lg group-hover:scale-110 transition-transform flex-shrink-0">
                                <i class="fas fa-chart-line text-[#2FE6DE] text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-gray-400 min-w-0">Total Profit</span>
                        </div>
                        <div class="text-lg md:text-xl font-medium break-all"><?php echo $cur_symbol ?><?php echo $iprof ?></div>
                    </div>
                 
                    <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 hover:bg-[#2A243B] transition-all duration-300 group border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex items-center gap-2 md:gap-3 mb-2">
                            <div class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center bg-[#2FE6DE]/10 rounded-lg group-hover:scale-110 transition-transform flex-shrink-0">
                                <i class="fas fa-arrow-up text-[#2FE6DE] text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-gray-400 min-w-0">Deposits</span>
                        </div>
                        <div class="text-lg md:text-xl font-medium break-all"><?php echo $cur_symbol ?><?php echo $ibalc ?></div>
                    </div>
                    
                    <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 hover:bg-[#2A243B] transition-all duration-300 group border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex items-center gap-2 md:gap-3 mb-2">
                            <div class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center bg-[#2FE6DE]/10 rounded-lg group-hover:scale-110 transition-transform flex-shrink-0">
                                <i class="fas fa-users text-[#2FE6DE] text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-gray-400 min-w-0">Referral Bonus</span>
                        </div>
                        <div class="text-lg md:text-xl font-medium break-all"><?php echo $cur_symbol ?><?php echo $refc ?></div>
                    </div>
                    <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 hover:bg-[#2A243B] transition-all duration-300 group border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex items-center gap-2 md:gap-3 mb-2">
                            <div class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center bg-[#2FE6DE]/10 rounded-lg group-hover:scale-110 transition-transform flex-shrink-0">
                                <i class="fas fa-arrow-down text-[#2FE6DE] text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-gray-400 min-w-0">Withdrawals</span>
                        </div>
                        <div class="text-lg md:text-xl font-medium break-all"><?php echo $cur_symbol ?><?php echo $tot_withdr ?></div>
                    </div>
                </div>

                
                <div class="mt-6">
                    <a href="live_trade.php" 
                        class="block w-full bg-gradient-to-r from-[#2FE6DE] to-[#2FE6DE]/80 text-black font-medium px-6 py-3 rounded-xl hover:brightness-110 transition-all text-center transform hover:scale-[1.02] shadow-md shadow-[#2FE6DE]/20">
                        LIVE TRADE
                    </a>
                </div>
            </div>

            
            <div class="bg-[#0F0A1F]/80 backdrop-blur-sm rounded-2xl p-3 md:p-4 shadow-lg border border-gray-800/20 hover:border-[#2FE6DE]/10 transition-all duration-300">
                <h3 class="text-base md:text-lg font-medium mb-4 md:mb-6 flex items-center gap-2">
                    <i class="fas fa-bolt text-[#2FE6DE]"></i>
                    Quick Actions
                </h3>
                <div class="grid grid-cols-3 gap-2 md:gap-4">
                    <a href="deposit.php" 
                       class="group bg-[#1A1428] rounded-xl p-2 md:p-4 hover:bg-[#2A243B] transition-all hover:scale-[1.02] border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex flex-col items-center gap-2 md:gap-3">
                            <div class="w-8 h-8 md:w-12 md:h-12 flex items-center justify-center bg-[#2FE6DE]/10 rounded-xl group-hover:bg-[#2FE6DE]/20 transition-colors">
                                <i class="fas fa-arrow-down text-[#2FE6DE] group-hover:scale-110 transition-transform text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-center">Deposit</span>
                        </div>
                    </a>
                    <a href="withdraw.php" 
                       class="group bg-[#1A1428] rounded-xl p-2 md:p-4 hover:bg-[#2A243B] transition-all hover:scale-[1.02] border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex flex-col items-center gap-2 md:gap-3">
                            <div class="w-8 h-8 md:w-12 md:h-12 flex items-center justify-center bg-[#2FE6DE]/10 rounded-xl group-hover:bg-[#2FE6DE]/20 transition-colors">
                                <i class="fas fa-wallet text-[#2FE6DE] group-hover:scale-110 transition-transform text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-center">Withdraw</span>
                        </div>
                    </a>
                    <a href="transactions.php" 
                       class="group bg-[#1A1428] rounded-xl p-2 md:p-4 hover:bg-[#2A243B] transition-all hover:scale-[1.02] border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex flex-col items-center gap-2 md:gap-3">
                            <div class="w-8 h-8 md:w-12 md:h-12 flex items-center justify-center bg-[#2FE6DE]/10 rounded-xl group-hover:bg-[#2FE6DE]/20 transition-colors">
                                <i class="fas fa-file-alt text-[#2FE6DE] group-hover:scale-110 transition-transform text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-center">Transactions</span>
                        </div>
                    </a>
                    <a href="referral.php" 
                       class="group bg-[#1A1428] rounded-xl p-2 md:p-4 hover:bg-[#2A243B] transition-all hover:scale-[1.02] border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex flex-col items-center gap-2 md:gap-3">
                            <div class="w-8 h-8 md:w-12 md:h-12 flex items-center justify-center bg-[#2FE6DE]/10 rounded-xl group-hover:bg-[#2FE6DE]/20 transition-colors">
                                <i class="fas fa-users text-[#2FE6DE] group-hover:scale-110 transition-transform text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-center">Referrals</span>
                        </div>
                    </a>
                    <a href="buy_signal.php" 
                       class="group bg-[#1A1428] rounded-xl p-2 md:p-4 hover:bg-[#2A243B] transition-all hover:scale-[1.02] border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex flex-col items-center gap-2 md:gap-3">
                            <div class="w-8 h-8 md:w-12 md:h-12 flex items-center justify-center bg-[#2FE6DE]/10 rounded-xl group-hover:bg-[#2FE6DE]/20 transition-colors">
                                <i class="fas fa-chart-line text-[#2FE6DE] group-hover:scale-110 transition-transform text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-center">Signals</span>
                        </div>
                    </a>
                    <a href="support.php" 
                       class="group bg-[#1A1428] rounded-xl p-2 md:p-4 hover:bg-[#2A243B] transition-all hover:scale-[1.02] border border-transparent hover:border-[#2FE6DE]/20">
                        <div class="flex flex-col items-center gap-2 md:gap-3">
                            <div class="w-8 h-8 md:w-12 md:h-12 flex items-center justify-center bg-[#2FE6DE]/10 rounded-xl group-hover:bg-[#2FE6DE]/20 transition-colors">
                                <i class="fas fa-headset text-[#2FE6DE] group-hover:scale-110 transition-transform text-sm md:text-base"></i>
                            </div>
                            <span class="text-xs md:text-sm text-center">Support</span>
                        </div>
                    </a>
                </div>
            </div>

            
            <!--[if BLOCK]><![endif]-->               
            
            <div class="hidden md:block bg-[#0F0A1F]/80 backdrop-blur-sm rounded-2xl mt-6 shadow-lg border border-gray-800/20 hover:border-[#2FE6DE]/10 transition-all duration-300">
                    <div class="p-4 border-b border-gray-800/50">
                        <div class="flex items-center justify-between">
                            <h3 class="text-lg font-medium flex items-center gap-2">
                                <i class="fas fa-box text-[#2FE6DE]"></i>
                                Active Plan(s)
                            </h3>
                            <a href="my_signals.php" 
                               class="text-[#2FE6DE] hover:brightness-110 transition-all flex items-center gap-2 hover:underline">
                                View my Signals
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                    
                    <div class="p-4">
                        <div class="grid gap-4">
                            <!--[if BLOCK]><![endif]-->                                <div class="text-center py-8">
                                    <div class="w-16 h-16 mx-auto mb-4 flex items-center justify-center bg-[#1A1428] rounded-2xl">
                                        <i class="fas fa-box text-[#2FE6DE] text-2xl"></i>
                                    </div>
                                    <p class="text-gray-400 mb-4">No Active Plans</p>
                                    <a href="buy_signal.php"
                                       class="inline-flex items-center gap-2 bg-[#2FE6DE] text-black px-6 py-2 rounded-xl hover:brightness-110 transition-all shadow-md shadow-[#2FE6DE]/20">
                                        <i class="fas fa-plus"></i>
                                        Signals
                                    </a>
                                </div>
                            <!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            <!--[if ENDBLOCK]><![endif]-->
        </div>

        
        <div class="lg:col-span-7 space-y-4 md:space-y-6">
            
            <div class="bg-[#0F0A1F]/80 backdrop-blur-sm rounded-2xl overflow-hidden shadow-lg border border-gray-800/20 hover:border-[#2FE6DE]/10 transition-all duration-300 relative">
                <div class="absolute inset-0 bg-gradient-to-br from-[#2FE6DE]/5 to-transparent opacity-50 pointer-events-none"></div>
                
                <div class="p-3 md:p-4 border-b border-gray-800/50 relative">
                    <div class="flex items-center justify-between">
                        <h3 class="text-base md:text-lg font-medium flex items-center gap-2">
                            <i class="fas fa-chart-bar text-[#2FE6DE]"></i>
                            Market Overview
                        </h3>
                        <div class="flex items-center gap-2 md:gap-3">
                            <div class="hidden md:flex items-center gap-2">
                                <div class="flex bg-[#1A1428] rounded-full p-1" id="timeframe-selector">
                                    <button class="text-xs px-2 md:px-3 py-1 rounded-full bg-[#2FE6DE] text-black font-medium" data-timeframe="24h">24h</button>
                                    <button class="text-xs px-2 md:px-3 py-1 rounded-full text-gray-400 hover:text-white" data-timeframe="7d">7d</button>
                                    <button class="text-xs px-2 md:px-3 py-1 rounded-full text-gray-400 hover:text-white" data-timeframe="30d">30d</button>
                                </div>
                            </div>
                            <div class="md:hidden flex bg-[#1A1428] rounded-full p-0.5" id="timeframe-selector-mobile">
                                <button class="text-xs px-2 py-1 rounded-full bg-[#2FE6DE] text-black font-medium" data-timeframe="24h">24h</button>
                                <button class="text-xs px-2 py-1 rounded-full text-gray-400" data-timeframe="7d">7d</button>
                                <button class="text-xs px-2 py-1 rounded-full text-gray-400" data-timeframe="30d">30d</button>
                            </div>
                            <button class="text-gray-400 hover:text-[#2FE6DE] transition-colors p-1.5 md:p-2 rounded-full hover:bg-[#2FE6DE]/10" id="expand-chart">
                                <i class="fas fa-expand-alt text-sm"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="p-3 md:p-4 relative">
                    
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-2 md:gap-4 mb-4 md:mb-6" id="crypto-cards">
                        <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 border border-gray-800/20 hover:border-[#2FE6DE]/20 transition-colors group hover:bg-[#1A1428]/80 crypto-card" data-crypto="BTC">
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-xs text-gray-400 flex items-center gap-1">
                                    <img src="https://assets.coingecko.com/coins/images/1/small/bitcoin.png" alt="Bitcoin" class="w-3 h-3 md:w-4 md:h-4 rounded-full">
                                    <span class="hidden sm:inline">BTC/USD</span>
                                    <span class="sm:hidden">BTC</span>
                                </span>
                                <div class="flex items-center gap-1 text-green-400 text-xs crypto-change">
                                    <i class="fas fa-caret-up text-xs"></i>
                                    <span>0.0%</span>
                                </div>
                            </div>
                            <div class="text-sm md:text-lg font-bold group-hover:text-[#2FE6DE] transition-colors crypto-price break-all">$0.00</div>
                        </div>
                        <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 border border-gray-800/20 hover:border-[#2FE6DE]/20 transition-colors group hover:bg-[#1A1428]/80 crypto-card" data-crypto="ETH">
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-xs text-gray-400 flex items-center gap-1">
                                    <img src="https://assets.coingecko.com/coins/images/279/small/ethereum.png" alt="Ethereum" class="w-3 h-3 md:w-4 md:h-4 rounded-full">
                                    <span class="hidden sm:inline">ETH/USD</span>
                                    <span class="sm:hidden">ETH</span>
                                </span>
                                <div class="flex items-center gap-1 text-green-400 text-xs crypto-change">
                                    <i class="fas fa-caret-up text-xs"></i>
                                    <span>0.0%</span>
                                </div>
                            </div>
                            <div class="text-sm md:text-lg font-bold group-hover:text-[#2FE6DE] transition-colors crypto-price break-all">$0.00</div>
                        </div>
                        <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 border border-gray-800/20 hover:border-[#2FE6DE]/20 transition-colors group hover:bg-[#1A1428]/80 crypto-card" data-crypto="SOL">
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-xs text-gray-400 flex items-center gap-1">
                                    <img src="https://assets.coingecko.com/coins/images/4128/small/solana.png" alt="Solana" class="w-3 h-3 md:w-4 md:h-4 rounded-full">
                                    <span class="hidden sm:inline">SOL/USD</span>
                                    <span class="sm:hidden">SOL</span>
                                </span>
                                <div class="flex items-center gap-1 text-green-400 text-xs crypto-change">
                                    <i class="fas fa-caret-up text-xs"></i>
                                    <span>0.0%</span>
                                </div>
                            </div>
                            <div class="text-sm md:text-lg font-bold group-hover:text-[#2FE6DE] transition-colors crypto-price break-all">$0.00</div>
                        </div>
                        <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 border border-gray-800/20 hover:border-[#2FE6DE]/20 transition-colors group hover:bg-[#1A1428]/80 crypto-card" data-crypto="XRP">
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-xs text-gray-400 flex items-center gap-1">
                                    <img src="https://assets.coingecko.com/coins/images/44/small/xrp-symbol-white-128.png" alt="XRP" class="w-3 h-3 md:w-4 md:h-4 rounded-full">
                                    <span class="hidden sm:inline">XRP/USD</span>
                                    <span class="sm:hidden">XRP</span>
                                </span>
                                <div class="flex items-center gap-1 text-green-400 text-xs crypto-change">
                                    <i class="fas fa-caret-up text-xs"></i>
                                    <span>0.0%</span>
                                </div>
                            </div>
                            <div class="text-sm md:text-lg font-bold group-hover:text-[#2FE6DE] transition-colors crypto-price break-all">$0.00</div>
                        </div>
                    </div>
                    
                    
                    <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 border border-gray-800/20 mb-4 md:mb-6 relative overflow-hidden group">
                        <div class="absolute inset-0 bg-gradient-to-br from-[#2FE6DE]/5 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500 pointer-events-none"></div>
                        
                        <div class="flex flex-col gap-3 mb-4">
                            <div class="flex items-center gap-2 md:gap-3 overflow-x-auto">
                                <div class="flex items-center gap-2 flex-shrink-0">
                                    <img src="https://assets.coingecko.com/coins/images/1/small/bitcoin.png" alt="Bitcoin" class="w-6 h-6 md:w-8 md:h-8 rounded-full">
                                    <span class="font-medium text-sm md:text-base">Bitcoin</span>
                                </div>
                                <div class="text-lg md:text-2xl font-bold break-all" id="main-crypto-price">$0.00</div>
                                <div class="flex items-center gap-1 text-green-400 text-xs md:text-sm bg-green-400/10 px-2 py-0.5 rounded-full flex-shrink-0" id="main-crypto-change-container">
                                    <i class="fas fa-caret-up text-xs" id="main-crypto-change-icon"></i>
                                    <span id="main-crypto-change">0.0%</span>
                                </div>
                            </div>
                            <div class="flex items-center gap-1 md:gap-2 overflow-x-auto pb-1" id="chart-type-selector">
                                <button class="text-xs px-2 md:px-3 py-1 rounded-md bg-[#2FE6DE]/10 text-[#2FE6DE] whitespace-nowrap" data-type="line">
                                    <i class="fas fa-chart-line mr-1"></i> Line
                                </button>
                                <button class="text-xs px-2 md:px-3 py-1 rounded-md bg-[#2A243B] text-gray-300 hover:bg-[#2FE6DE]/10 transition-colors whitespace-nowrap" data-type="candle">
                                    <i class="fas fa-chart-bar mr-1"></i> Candles
                                </button>
                                <button class="text-xs px-2 md:px-3 py-1 rounded-md bg-[#2A243B] text-gray-300 hover:bg-[#2FE6DE]/10 transition-colors whitespace-nowrap" data-type="area">
                                    <i class="fas fa-chart-area mr-1"></i> Area
                                </button>
                            </div>
                        </div>
                        
                        <div class="h-[200px] md:h-[250px] relative">
                            <canvas id="cryptoChart" class="w-full h-full"></canvas>
                            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 text-center" id="chartLoader">
                                <div class="w-8 h-8 md:w-10 md:h-10 border-4 border-[#2FE6DE]/20 border-t-[#2FE6DE] rounded-full animate-spin mb-2"></div>
                                <span class="text-xs md:text-sm text-gray-400">Loading chart data...</span>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="grid md:grid-cols-2 gap-4">
                        
                        <div class="bg-[#1A1428] rounded-xl p-4 border border-gray-800/20 hover:border-[#2FE6DE]/20 transition-colors">
                            <div class="flex items-center justify-between mb-4">
                                <h4 class="font-medium flex items-center gap-2">
                                    <i class="fas fa-poll text-[#2FE6DE]"></i>
                                    Market Sentiment
                                </h4>
                                <div class="text-xs text-white bg-green-500 px-2 py-0.5 rounded-full" id="fear-greed-label">Neutral</div>
                            </div>
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-xs text-gray-400">Fear & Greed Index</span>
                                <span class="text-xs text-gray-400" id="fear-greed-value">50/100</span>
                            </div>
                            <div class="w-full bg-[#0F0A1F] rounded-full h-2 mb-4">
                                <div class="bg-gradient-to-r from-red-500 via-yellow-500 to-green-500 h-2 rounded-full" style="width: 50%" id="fear-greed-indicator"></div>
                            </div>
                            <div class="flex justify-between text-xs text-gray-500">
                                <span>Extreme Fear</span>
                                <span>Neutral</span>
                                <span>Extreme Greed</span>
                            </div>
                        </div>
                        
                        
                        <div class="bg-[#1A1428] rounded-xl p-4 border border-gray-800/20 hover:border-[#2FE6DE]/20 transition-colors">
                            <div class="flex items-center justify-between mb-4">
                                <h4 class="font-medium flex items-center gap-2">
                                    <i class="fas fa-bolt text-[#2FE6DE]"></i>
                                    Top Movers
                                </h4>
                            </div>
                            <div class="space-y-3" id="top-movers-container">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-2">
                                        <img src="https://assets.coingecko.com/coins/images/5/small/dogecoin.png" alt="Dogecoin" class="w-6 h-6 rounded-full">
                                        <span class="text-sm">DOGE</span>
                                    </div>
                                    <div class="text-green-400 text-sm">+7.2%</div>
                                </div>
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-2">
                                        <img src="https://assets.coingecko.com/coins/images/12559/small/Avalanche_Circle_RedWhite_Trans.png" alt="Avalanche" class="w-6 h-6 rounded-full">
                                        <span class="text-sm">AVAX</span>
                                    </div>
                                    <div class="text-green-400 text-sm">+4.5%</div>
                                </div>
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-2">
                                        <img src="https://assets.coingecko.com/coins/images/12171/small/polkadot.png" alt="Polkadot" class="w-6 h-6 rounded-full">
                                        <span class="text-sm">DOT</span>
                                    </div>
                                    <div class="text-red-400 text-sm">-2.1%</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                
                <div class="p-3 md:p-4 border-t border-gray-800/50">
                    <h4 class="font-medium mb-3 md:mb-4 flex items-center gap-2 text-sm md:text-base">
                        <i class="fas fa-fire text-[#2FE6DE]"></i>
                        Trending Assets
                    </h4>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-2 md:gap-4" id="trending-assets">
                        <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 hover:bg-[#2A243B] transition-colors flex items-center justify-between group border border-transparent hover:border-[#2FE6DE]/20">
                            <div class="flex items-center gap-2 md:gap-3 min-w-0">
                                <img src="https://assets.coingecko.com/coins/images/279/small/ethereum.png" alt="Ethereum" class="w-8 h-8 md:w-10 md:h-10 rounded-full group-hover:scale-110 transition-transform flex-shrink-0">
                                <div class="min-w-0">
                                    <div class="font-medium text-sm md:text-base truncate">Ethereum</div>
                                    <div class="text-xs text-gray-400">ETH</div>
                                </div>
                            </div>
                            <div class="text-right flex-shrink-0">
                                <div class="font-medium text-sm md:text-base trending-price break-all">$0.00</div>
                                <div class="text-xs text-green-400 trending-change">+0.0%</div>
                            </div>
                        </div>
                        <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 hover:bg-[#2A243B] transition-colors flex items-center justify-between group border border-transparent hover:border-[#2FE6DE]/20">
                            <div class="flex items-center gap-2 md:gap-3 min-w-0">
                                <img src="https://assets.coingecko.com/coins/images/4128/small/solana.png" alt="Solana" class="w-8 h-8 md:w-10 md:h-10 rounded-full group-hover:scale-110 transition-transform flex-shrink-0">
                                <div class="min-w-0">
                                    <div class="font-medium text-sm md:text-base truncate">Solana</div>
                                    <div class="text-xs text-gray-400">SOL</div>
                                </div>
                            </div>
                            <div class="text-right flex-shrink-0">
                                <div class="font-medium text-sm md:text-base trending-price break-all">$0.00</div>
                                <div class="text-xs text-green-400 trending-change">+0.0%</div>
                            </div>
                        </div>
                        <div class="bg-[#1A1428] rounded-xl p-3 md:p-4 hover:bg-[#2A243B] transition-colors flex items-center justify-between group border border-transparent hover:border-[#2FE6DE]/20">
                            <div class="flex items-center gap-2 md:gap-3 min-w-0">
                                <img src="https://assets.coingecko.com/coins/images/44/small/xrp-symbol-white-128.png" alt="XRP" class="w-8 h-8 md:w-10 md:h-10 rounded-full group-hover:scale-110 transition-transform flex-shrink-0">
                                <div class="min-w-0">
                                    <div class="font-medium text-sm md:text-base truncate">Ripple</div>
                                    <div class="text-xs text-gray-400">XRP</div>
                                </div>
                            </div>
                            <div class="text-right flex-shrink-0">
                                <div class="font-medium text-sm md:text-base trending-price break-all">$0.00</div>
                                <div class="text-xs text-green-400 trending-change">+0.0%</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
          <?php
$userId = $_SESSION['SESS_USERID'] ?? 0;

// Get last 10 transactions (deposits + withdrawals)
$sql = "
     SELECT cur, amount, date, 'Credit' as type 
    FROM deposit 
    WHERE log_id = :uid AND status = '2'
    UNION ALL
    SELECT cur, amount, date, 'Debit' as type 
    FROM withdraw 
    WHERE log_id = :uid AND status = '2'
    ORDER BY date DESC 
    LIMIT 10
";
$stmt = $pdo->prepare($sql);
$stmt->execute(['uid' => $userId]);
$transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="bg-[#0F0A1F]/80 backdrop-blur-sm rounded-2xl shadow-lg border border-gray-800/20 hover:border-[#2FE6DE]/10 transition-all duration-300">
    <div class="p-3 md:p-4 border-b border-gray-800/50">
        <div class="flex items-center justify-between">
            <h3 class="text-base md:text-lg font-medium flex items-center gap-2">
                <i class="fas fa-history text-[#2FE6DE]"></i>
                Recent Transactions
            </h3>
            <a href="transactions.php" 
               class="text-[#2FE6DE] hover:brightness-110 transition-all flex items-center gap-1 md:gap-2 hover:underline text-sm md:text-base">
                View All
                <i class="fas fa-arrow-right text-xs"></i>
            </a>
        </div>
    </div>
    
    <div class="p-3 md:p-4">
        <div class="overflow-x-auto -mx-1">
            <table class="w-full min-w-[300px]">
                <thead>
                    <tr class="text-left text-xs md:text-sm text-gray-400 border-b border-gray-800/50">
                        <th class="pb-3 md:pb-4 font-medium">Amount</th>
                        <th class="pb-3 md:pb-4 font-medium hidden sm:table-cell">Date</th>
                        <th class="pb-3 md:pb-4 font-medium">Type</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-800/50">
                    <?php if ($transactions): ?>
                        <?php foreach ($transactions as $tx): ?>
                            <tr class="hover:bg-[#1A1428]/30 transition-colors">
                                <td class="py-3 md:py-4">
                                    <div>
                                        <?php if ($tx['type'] === 'Credit'): ?>
                                            <span class="font-medium text-sm md:text-base text-[#2FE6DE] break-all">
                                                <?=($tx['cur'])?><?= number_format($tx['amount'], 2) ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="font-medium text-sm md:text-base text-red-400 break-all">
                                                -<?=($tx['cur'])?><?= number_format($tx['amount'], 2) ?>
                                            </span>
                                        <?php endif; ?>
                                        <div class="text-xs text-gray-400 sm:hidden mt-1">
                                            <?= date("M d, Y", strtotime($tx['date'])) ?>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-3 md:py-4 text-xs md:text-sm text-gray-400 hidden sm:table-cell">
                                    <?= date("D, M d, Y g:i A", strtotime($tx['date'])) ?>
                                </td>
                                <td class="py-3 md:py-4">
                                    <?php if ($tx['type'] === 'Credit'): ?>
                                        <span class="inline-flex items-center px-2 md:px-2.5 py-0.5 rounded-full text-xs font-medium
                                            bg-[#2FE6DE]/10 text-[#2FE6DE]">
                                            Credit
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-2 md:px-2.5 py-0.5 rounded-full text-xs font-medium
                                            bg-red-400/10 text-red-400">
                                            Debit
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" class="py-4 text-center text-gray-400 text-sm">
                                No recent transactions
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


            
            <!--<div class="md:hidden bg-[#0F0A1F]/80 backdrop-blur-sm rounded-2xl p-3 shadow-lg border border-gray-800/20 hover:border-[#2FE6DE]/10 transition-all duration-300">-->
            <!--    <h3 class="text-base font-medium mb-3 flex items-center gap-2">-->
            <!--        <i class="fas fa-link text-[#2FE6DE]"></i>-->
            <!--        Your referral link-->
            <!--    </h3>-->
            <!--    <div class="p-3 bg-[#1A1428] rounded-xl">-->
            <!--        <div class="flex items-center gap-2">-->
            <!--            <input-->
            <!--                id="referralInput"-->
            <!--                type="text"-->
            <!--                value="https://trade.helplabs.cloud/ref/demo21"-->
            <!--                readonly-->
            <!--                class="flex-1 bg-[#2A243B] rounded-lg px-3 py-2 text-xs border border-gray-800 focus:ring-[#2FE6DE] focus:border-[#2FE6DE] min-w-0"-->
            <!--            >-->
            <!--            <button -->
            <!--                id="copyReferralBtn"-->
            <!--                class="bg-gradient-to-r from-[#2FE6DE] to-[#2FE6DE]/80 text-black px-3 py-2 rounded-lg hover:brightness-110 transition-all flex items-center gap-1 whitespace-nowrap shadow-md shadow-[#2FE6DE]/10 flex-shrink-0"-->
            <!--            >-->
            <!--                <i class="fas fa-copy text-sm"></i>-->
            <!--                <span class="text-sm">Copy</span>-->
            <!--            </button>-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
    </div>

    
    
    
    
    <div class="md:hidden bg-[#0F0A1F]/80 backdrop-blur-sm rounded-2xl mt-6 shadow-lg border border-gray-800/20 hover:border-[#2FE6DE]/10 transition-all duration-300">
            <div class="p-4 border-b border-gray-800/50">
                <div class="flex items-center justify-between">
                    <h3 class="text-lg font-medium flex items-center gap-2">
                        <i class="fas fa-box text-[#2FE6DE]"></i>
                        Active Plan(s)
                    </h3>
                    <a href="my_signals.php" 
                       class="text-[#2FE6DE] hover:brightness-110 transition-all flex items-center gap-2 hover:underline">
                        View All Signals
                        <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
            
            <div class="p-4">
                <div class="grid md:grid-cols-2 gap-4">
                    <!--[if BLOCK]><![endif]-->                        <div class="text-center py-8 col-span-2">
                            <div class="w-16 h-16 mx-auto mb-4 flex items-center justify-center bg-[#1A1428] rounded-2xl">
                                <i class="fas fa-box text-[#2FE6DE] text-2xl"></i>
                            </div>
                            <p class="text-gray-400 mb-4">No Active Plans</p>
                            <a href="buy_signal.php"
                               class="inline-flex items-center gap-2 bg-[#2FE6DE] text-black px-6 py-2 rounded-xl hover:brightness-110 transition-all shadow-md shadow-[#2FE6DE]/20">
                                <i class="fas fa-plus"></i>
                                Signals
                            </a>
                        </div>
                    <!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
    <!--[if ENDBLOCK]><![endif]-->
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        // Balance visibility toggle
        const toggleButton = document.getElementById('toggleBalance');
        const balanceAmount = document.getElementById('balanceAmount');
        const balanceHidden = document.getElementById('balanceHidden');
        const toggleIcon = document.getElementById('toggleIcon');

        // Check localStorage for visibility state
        let isBalanceVisible = localStorage.getItem('balanceVisible') === 'true';

        // Apply initial visibility state
        if (isBalanceVisible) {
            balanceAmount.classList.remove('hidden');
            balanceHidden.classList.add('hidden');
            toggleIcon.classList.remove('fa-eye-slash');
            toggleIcon.classList.add('fa-eye');
        } else {
            balanceAmount.classList.add('hidden');
            balanceHidden.classList.remove('hidden');
            toggleIcon.classList.remove('fa-eye');
            toggleIcon.classList.add('fa-eye-slash');
        }

        // Toggle visibility and cache the state
        toggleButton.addEventListener('click', () => {
            isBalanceVisible = !isBalanceVisible;

            balanceAmount.classList.toggle('hidden');
            balanceHidden.classList.toggle('hidden');
            
            // Toggle the icon
            toggleIcon.classList.toggle('fa-eye');
            toggleIcon.classList.toggle('fa-eye-slash');

            // Save the visibility state in localStorage
            localStorage.setItem('balanceVisible', isBalanceVisible);
        });

        // Copy referral link
        const copyButton = document.getElementById('copyReferralBtn');
        const referralInput = document.getElementById('referralInput');

        copyButton.addEventListener('click', () => {
            referralInput.select();
            navigator.clipboard.writeText(referralInput.value).then(() => {
                const originalContent = copyButton.innerHTML;
                copyButton.innerHTML = `<i class="fas fa-check"></i><span>Copied!</span>`;
                
                setTimeout(() => {
                    copyButton.innerHTML = originalContent;
                }, 2000);
            });
        });
        
        // Crypto data and chart variables
        let mainChart;
        let currentTimeframe = '24h';
        let currentChartType = 'line';
        let selectedCrypto = 'BTC';
        
        // CryptoCompare API endpoint
        const CRYPTOCOMPARE_API_BASE = 'https://min-api.cryptocompare.com/data';
        const CRYPTO_SYMBOLS = ['BTC', 'ETH', 'SOL', 'XRP'];
        const CRYPTO_NAMES = {
            'BTC': 'Bitcoin',
            'ETH': 'Ethereum',
            'SOL': 'Solana',
            'XRP': 'Ripple'
        };
        
        // Initialize everything
        initCryptoData();
        
        // Timeframe selector (desktop)
        document.querySelectorAll('#timeframe-selector button').forEach(button => {
            button.addEventListener('click', () => {
                // Update active button
                document.querySelectorAll('#timeframe-selector button').forEach(btn => {
                    btn.classList.remove('bg-[#2FE6DE]', 'text-black');
                    btn.classList.add('text-gray-400');
                });
                button.classList.remove('text-gray-400');
                button.classList.add('bg-[#2FE6DE]', 'text-black');
                
                // Update timeframe and fetch data
                currentTimeframe = button.getAttribute('data-timeframe');
                updateChartData(selectedCrypto, currentTimeframe);
            });
        });
        
        // Timeframe selector (mobile)
        document.querySelectorAll('#timeframe-selector-mobile button').forEach(button => {
            button.addEventListener('click', () => {
                // Update active button
                document.querySelectorAll('#timeframe-selector-mobile button').forEach(btn => {
                    btn.classList.remove('bg-[#2FE6DE]', 'text-black');
                    btn.classList.add('text-gray-400');
                });
                button.classList.remove('text-gray-400');
                button.classList.add('bg-[#2FE6DE]', 'text-black');
                
                // Update timeframe and fetch data
                currentTimeframe = button.getAttribute('data-timeframe');
                updateChartData(selectedCrypto, currentTimeframe);
            });
        });
        
        // Chart type selector
        document.querySelectorAll('#chart-type-selector button').forEach(button => {
            button.addEventListener('click', () => {
                // Update active button
                document.querySelectorAll('#chart-type-selector button').forEach(btn => {
                    btn.classList.remove('bg-[#2FE6DE]/10', 'text-[#2FE6DE]');
                    btn.classList.add('bg-[#2A243B]', 'text-gray-300');
                });
                button.classList.remove('bg-[#2A243B]', 'text-gray-300');
                button.classList.add('bg-[#2FE6DE]/10', 'text-[#2FE6DE]');
                
                // Update chart type
                currentChartType = button.getAttribute('data-type');
                updateChartType(currentChartType);
            });
        });
        
        // Crypto card click handler
        document.querySelectorAll('.crypto-card').forEach(card => {
            card.addEventListener('click', () => {
                selectedCrypto = card.getAttribute('data-crypto');
                updateChartData(selectedCrypto, currentTimeframe);
                
                // Update main crypto info
                const cryptoName = CRYPTO_NAMES[selectedCrypto];
                document.querySelector('.flex.items-center.gap-2 span.font-medium').textContent = cryptoName;
                
                // Update icon
                let iconClass = 'fa-bitcoin';
                let gradientClass = 'from-orange-500 to-yellow-500';
                
                if (selectedCrypto === 'ETH') {
                    iconClass = 'fa-ethereum';
                    gradientClass = 'from-blue-500 to-indigo-500';
                } else if (selectedCrypto === 'SOL') {
                    iconClass = 'fa-chart-pie';
                    gradientClass = 'from-purple-500 to-pink-500';
                } else if (selectedCrypto === 'XRP') {
                    iconClass = 'fa-wave-square';
                    gradientClass = 'from-blue-400 to-cyan-400';
                }
                
                const iconElement = document.querySelector('.flex.items-center.gap-2 .w-8.h-8 i');
                iconElement.className = '';
                iconElement.classList.add(selectedCrypto === 'BTC' || selectedCrypto === 'ETH' ? 'fab' : 'fas', iconClass, 'text-white');
                
                const iconContainer = document.querySelector('.flex.items-center.gap-2 .w-8.h-8');
                iconContainer.className = 'w-8 h-8 rounded-full bg-gradient-to-r flex items-center justify-center';
                iconContainer.classList.add(gradientClass.split(' ')[0], gradientClass.split(' ')[1]);
            });
        });
        
        // Fetch crypto data from CryptoCompare
        async function initCryptoData() {
            try {
                // Show loading indicators
                document.getElementById('chartLoader').style.display = 'block';
                
                // Fetch current prices
                const priceResponse = await fetch(`${CRYPTOCOMPARE_API_BASE}/pricemultifull?fsyms=${CRYPTO_SYMBOLS.join(',')}&tsyms=USD`);
                const priceData = await priceResponse.json();
                
                if (priceData.RAW) {
                    // Update crypto cards
                    CRYPTO_SYMBOLS.forEach(crypto => {
                        if (priceData.RAW[crypto] && priceData.RAW[crypto].USD) {
                            const card = document.querySelector(`.crypto-card[data-crypto="${crypto}"]`);
                            if (card) {
                                const priceElement = card.querySelector('.crypto-price');
                                const changeElement = card.querySelector('.crypto-change span');
                                const changeIcon = changeElement.previousElementSibling;
                                const changeContainer = changeElement.parentElement;
                                
                                const price = priceData.RAW[crypto].USD.PRICE;
                                const change = priceData.RAW[crypto].USD.CHANGEPCT24HOUR;
                                
                                // Format price based on value
                                let formattedPrice;
                                if (price >= 1000) {
                                    formattedPrice = `$${price.toLocaleString('en-US', {maximumFractionDigits: 2})}`;
                                } else if (price >= 1) {
                                    formattedPrice = `$${price.toLocaleString('en-US', {maximumFractionDigits: 2})}`;
                                } else {
                                    formattedPrice = `$${price.toLocaleString('en-US', {maximumFractionDigits: 6})}`;
                                }
                                
                                priceElement.textContent = formattedPrice;
                                changeElement.textContent = `${change >= 0 ? '+' : ''}${change.toFixed(2)}%`;
                                
                                // Update change color
                                if (change >= 0) {
                                    changeContainer.classList.remove('text-red-400');
                                    changeContainer.classList.add('text-green-400');
                                    changeIcon.classList.remove('fa-caret-down');
                                    changeIcon.classList.add('fa-caret-up');
                                } else {
                                    changeContainer.classList.remove('text-green-400');
                                    changeContainer.classList.add('text-red-400');
                                    changeIcon.classList.remove('fa-caret-up');
                                    changeIcon.classList.add('fa-caret-down');
                                }
                                
                                // If this is the selected crypto, update main display
                                if (crypto === selectedCrypto) {
                                    document.getElementById('main-crypto-price').textContent = formattedPrice;
                                    document.getElementById('main-crypto-change').textContent = `${change >= 0 ? '+' : ''}${change.toFixed(2)}%`;
                                    
                                    const mainChangeContainer = document.getElementById('main-crypto-change-container');
                                    const mainChangeIcon = document.getElementById('main-crypto-change-icon');
                                    
                                    if (change >= 0) {
                                        mainChangeContainer.classList.remove('text-red-400', 'bg-red-400/10');
                                        mainChangeContainer.classList.add('text-green-400', 'bg-green-400/10');
                                        mainChangeIcon.classList.remove('fa-caret-down');
                                        mainChangeIcon.classList.add('fa-caret-up');
                                    } else {
                                        mainChangeContainer.classList.remove('text-green-400', 'bg-green-400/10');
                                        mainChangeContainer.classList.add('text-red-400', 'bg-red-400/10');
                                        mainChangeIcon.classList.remove('fa-caret-up');
                                        mainChangeIcon.classList.add('fa-caret-down');
                                    }
                                }
                            }
                        }
                    });
                    
                    // Update trending assets section
                    const trendingContainer = document.getElementById('trending-assets');
                    const trendingAssets = ['ETH', 'SOL', 'XRP']; // Fixed trending assets
                    
                    trendingAssets.forEach((crypto, index) => {
                        if (priceData.RAW[crypto] && priceData.RAW[crypto].USD) {
                            const price = priceData.RAW[crypto].USD.PRICE;
                            const change = priceData.RAW[crypto].USD.CHANGEPCT24HOUR;
                            
                            // Format price based on value
                            let formattedPrice;
                            if (price >= 1000) {
                                formattedPrice = `$${price.toLocaleString('en-US', {maximumFractionDigits: 2})}`;
                            } else if (price >= 1) {
                                formattedPrice = `$${price.toLocaleString('en-US', {maximumFractionDigits: 2})}`;
                            } else {
                                formattedPrice = `$${price.toLocaleString('en-US', {maximumFractionDigits: 6})}`;
                            }
                            
                            const trendingPriceElements = trendingContainer.querySelectorAll('.trending-price');
                            const trendingChangeElements = trendingContainer.querySelectorAll('.trending-change');
                            
                            if (trendingPriceElements[index]) {
                                trendingPriceElements[index].textContent = formattedPrice;
                            }
                            
                            if (trendingChangeElements[index]) {
                                trendingChangeElements[index].textContent = `${change >= 0 ? '+' : ''}${change.toFixed(2)}%`;
                                trendingChangeElements[index].className = change >= 0 ? 'text-xs text-green-400 trending-change' : 'text-xs text-red-400 trending-change';
                            }
                        }
                    });
                    
                    // Simulate top movers
                    const topMovers = [
                        { 
                            symbol: 'DOGE', 
                            name: 'Dogecoin',
                            change: 7.2 + (Math.random() - 0.5) * 0.5, 
                            image: 'https://assets.coingecko.com/coins/images/5/small/dogecoin.png'
                        },
                        { 
                            symbol: 'AVAX', 
                            name: 'Avalanche',
                            change: 4.5 + (Math.random() - 0.5) * 0.5, 
                            image: 'https://assets.coingecko.com/coins/images/12559/small/Avalanche_Circle_RedWhite_Trans.png'
                        },
                        { 
                            symbol: 'DOT', 
                            name: 'Polkadot',
                            change: -2.1 + (Math.random() - 0.5) * 0.5, 
                            image: 'https://assets.coingecko.com/coins/images/12171/small/polkadot.png'
                        }
                    ];
                    
                    // Sort by absolute change value
                    topMovers.sort((a, b) => Math.abs(b.change) - Math.abs(a.change));
                    
                    const moversContainer = document.getElementById('top-movers-container');
                    moversContainer.innerHTML = '';
                    
                    topMovers.forEach(mover => {
                        const isPositive = mover.change >= 0;
                        const element = document.createElement('div');
                        element.className = 'flex items-center justify-between';
                        element.innerHTML = `
                            <div class="flex items-center gap-2">
                                <img src="${mover.image}" alt="${mover.name}" class="w-6 h-6 rounded-full">
                                <span class="text-sm">${mover.symbol}</span>
                            </div>
                            <div class="${isPositive ? 'text-green-400' : 'text-red-400'} text-sm">${isPositive ? '+' : ''}${mover.change.toFixed(1)}%</div>
                        `;
                        
                        moversContainer.appendChild(element);
                    });
                    
                    // Simulate Fear & Greed Index
                    const fearGreedValue = Math.floor(Math.random() * 30) + 45; // Random value between 45-75
                    document.getElementById('fear-greed-value').textContent = `${fearGreedValue}/100`;
                    document.getElementById('fear-greed-indicator').style.width = `${fearGreedValue}%`;
                    
                    let sentimentLabel = 'Neutral';
                    let sentimentClass = 'text-xs text-white bg-yellow-500 px-2 py-0.5 rounded-full';
                    
                    if (fearGreedValue <= 25) {
                        sentimentLabel = 'Extreme Fear';
                        sentimentClass = 'text-xs text-white bg-red-500 px-2 py-0.5 rounded-full';
                    } else if (fearGreedValue <= 45) {
                        sentimentLabel = 'Fear';
                        sentimentClass = 'text-xs text-white bg-orange-500 px-2 py-0.5 rounded-full';
                    } else if (fearGreedValue <= 55) {
                        sentimentLabel = 'Neutral';
                        sentimentClass = 'text-xs text-white bg-yellow-500 px-2 py-0.5 rounded-full';
                    } else if (fearGreedValue <= 75) {
                        sentimentLabel = 'Greed';
                        sentimentClass = 'text-xs text-white bg-green-500 px-2 py-0.5 rounded-full';
                    } else {
                        sentimentLabel = 'Extreme Greed';
                        sentimentClass = 'text-xs text-white bg-green-600 px-2 py-0.5 rounded-full';
                    }
                    
                    document.getElementById('fear-greed-label').textContent = sentimentLabel;
                    document.getElementById('fear-greed-label').className = sentimentClass;
                }
                
                // Initialize main chart with Bitcoin data
                updateChartData(selectedCrypto, currentTimeframe);
                
            } catch (error) {
                console.error('Error initializing crypto data:', error);
                // Hide loading indicators
                document.getElementById('chartLoader').style.display = 'none';
            }
        }
        
        // Update chart data based on selected crypto and timeframe
        async function updateChartData(crypto, timeframe) {
            try {
                // Show loading indicator
                document.getElementById('chartLoader').style.display = 'block';
                
                // Convert timeframe to API parameters
                let limit = 24;
                let aggregate = 1;
                let endpoint = 'histohour';
                
                if (timeframe === '7d') {
                    limit = 7;
                    endpoint = 'histoday';
                } else if (timeframe === '30d') {
                    limit = 30;
                    endpoint = 'histoday';
                }
                
                // Fetch historical data
                const response = await fetch(`${CRYPTOCOMPARE_API_BASE}/v2/${endpoint}?fsym=${crypto}&tsym=USD&limit=${limit}&aggregate=${aggregate}`);
                const data = await response.json();
                
                if (data.Response === 'Success' && data.Data && data.Data.Data) {
                    const prices = data.Data.Data.map(item => ({
                        x: new Date(item.time * 1000),
                        y: item.close
                    }));
                    
                    // Format labels based on timeframe
                    const labels = prices.map(price => {
                        if (timeframe === '24h') {
                            return price.x.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
                        } else if (timeframe === '7d') {
                            return price.x.toLocaleDateString([], { weekday: 'short' });
                        } else {
                            return price.x.toLocaleDateString([], { month: 'short', day: 'numeric' });
                        }
                    });
                    
                    // Initialize or update chart
                    if (!mainChart) {
                        initMainChart(labels, prices.map(p => p.y));
                    } else {
                        mainChart.data.labels = labels;
                        mainChart.data.datasets[0].data = prices.map(p => p.y);
                        mainChart.update();
                    }
                    
                    // Apply current chart type
                    updateChartType(currentChartType);
                }
                
                // Hide loading indicator
                document.getElementById('chartLoader').style.display = 'none';
                
            } catch (error) {
                console.error(`Error updating chart data for ${crypto}:`, error);
                document.getElementById('chartLoader').style.display = 'none';
                
                // Fallback to simulated data if API fails
                simulateChartData(crypto, timeframe);
            }
        }
        
        // Simulate chart data as fallback
        function simulateChartData(crypto, timeframe) {
            // Generate labels based on timeframe
            const labels = [];
            const data = [];
            let basePrice = 0;
            
            // Set base price based on crypto
            switch(crypto) {
                case 'BTC':
                    basePrice = 43000;
                    break;
                case 'ETH':
                    basePrice = 2300;
                    break;
                case 'SOL':
                    basePrice = 125;
                    break;
                case 'XRP':
                    basePrice = 0.54;
                    break;
                default:
                    basePrice = 100;
            }
            
            // Generate data points
            const now = new Date();
            let points = 24;
            
            if (timeframe === '7d') {
                points = 7;
            } else if (timeframe === '30d') {
                points = 30;
            }
            
            for (let i = 0; i < points; i++) {
                const date = new Date();
                
                if (timeframe === '24h') {
                    date.setHours(now.getHours() - (points - i));
                    labels.push(date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' }));
                } else if (timeframe === '7d') {
                    date.setDate(now.getDate() - (points - i));
                    labels.push(date.toLocaleDateString([], { weekday: 'short' }));
                } else {
                    date.setDate(now.getDate() - (points - i));
                    labels.push(date.toLocaleDateString([], { month: 'short', day: 'numeric' }));
                }
                
                // Generate realistic price movement
                const volatility = Math.random() * 2 - 1; // -1 to 1
                const change = basePrice * (volatility * 0.02); // Max 2% change
                basePrice = basePrice + change;
                data.push(basePrice);
            }
            
            // Initialize or update chart
            if (!mainChart) {
                initMainChart(labels, data);
            } else {
                mainChart.data.labels = labels;
                mainChart.data.datasets[0].data = data;
                mainChart.update();
            }
            
            // Apply current chart type
            updateChartType(currentChartType);
        }
        
        // Initialize main chart
        function initMainChart(labels, data) {
            const ctx = document.getElementById('cryptoChart').getContext('2d');
            
            const gradient = ctx.createLinearGradient(0, 0, 0, 250);
            gradient.addColorStop(0, 'rgba(47, 230, 222, 0.5)');
            gradient.addColorStop(1, 'rgba(47, 230, 222, 0)');
            
            mainChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Price (USD)',
                        data: data,
                        borderColor: '#2FE6DE',
                        backgroundColor: gradient,
                        borderWidth: 2,
                        fill: true,
                        tension: 0.4,
                        pointRadius: 0,
                        pointHoverRadius: 4,
                        pointBackgroundColor: '#2FE6DE',
                        pointHoverBackgroundColor: '#2FE6DE',
                        pointBorderColor: '#fff',
                        pointHoverBorderColor: '#fff',
                        pointBorderWidth: 2,
                        pointHoverBorderWidth: 2
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            mode: 'index',
                            intersect: false,
                            backgroundColor: '#1A1428',
                            titleColor: '#fff',
                            bodyColor: '#ccc',
                            borderColor: '#2FE6DE',
                            borderWidth: 1,
                            padding: 10,
                            displayColors: false,
                            callbacks: {
                                label: function(context) {
                                    return `$${context.raw.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}`;
                                }
                            }
                        }
                    },
                    scales: {
                        x: {
                            grid: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                color: '#6B7280',
                                font: {
                                    size: 10
                                },
                                maxRotation: 0,
                                maxTicksLimit: 5
                            }
                        },
                        y: {
                            grid: {
                                color: 'rgba(75, 85, 99, 0.1)',
                                drawBorder: false
                            },
                            ticks: {
                                color: '#6B7280',
                                font: {
                                    size: 10
                                },
                                callback: function(value) {
                                    return '$' + value.toLocaleString('en-US', {minimumFractionDigits: 0, maximumFractionDigits: 0});
                                }
                            }
                        }
                    },
                    interaction: {
                        mode: 'index',
                        intersect: false
                    },
                    hover: {
                        mode: 'index',
                        intersect: false
                    }
                }
            });
        }
        
        // Update chart type (line, candle, area)
        function updateChartType(type) {
            if (!mainChart) return;
            
            if (type === 'line') {
                mainChart.config.type = 'line';
                mainChart.data.datasets[0].fill = false;
                mainChart.data.datasets[0].tension = 0.4;
                mainChart.data.datasets[0].borderWidth = 2;
                mainChart.data.datasets[0].backgroundColor = mainChart.ctx.createLinearGradient(0, 0, 0, 250);
                mainChart.data.datasets[0].backgroundColor.addColorStop(0, 'rgba(47, 230, 222, 0.5)');
                mainChart.data.datasets[0].backgroundColor.addColorStop(1, 'rgba(47, 230, 222, 0)');
                mainChart.data.datasets[0].borderColor = '#2FE6DE';
            } else if (type === 'area') {
                mainChart.config.type = 'line';
                mainChart.data.datasets[0].fill = true;
                mainChart.data.datasets[0].tension = 0.4;
                mainChart.data.datasets[0].borderWidth = 2;
                mainChart.data.datasets[0].backgroundColor = mainChart.ctx.createLinearGradient(0, 0, 0, 250);
                mainChart.data.datasets[0].backgroundColor.addColorStop(0, 'rgba(47, 230, 222, 0.5)');
                mainChart.data.datasets[0].backgroundColor.addColorStop(1, 'rgba(47, 230, 222, 0)');
                mainChart.data.datasets[0].borderColor = '#2FE6DE';
            } else if (type === 'candle') {
                // Simulate candle chart with bar chart
                mainChart.config.type = 'bar';
                mainChart.data.datasets[0].fill = true;
                mainChart.data.datasets[0].tension = 0;
                
                // Create dynamic background colors based on price movement
                const data = mainChart.data.datasets[0].data;
                const backgroundColors = [];
                const borderColors = [];
                
                for (let i = 0; i < data.length; i++) {
                    const current = data[i];
                    const previous = i > 0 ? data[i - 1] : current;
                    
                    if (current >= previous) {
                        backgroundColors.push('rgba(16, 185, 129, 0.7)');
                        borderColors.push('rgb(16, 185, 129)');
                    } else {
                        backgroundColors.push('rgba(248, 113, 113, 0.7)');
                        borderColors.push('rgb(248, 113, 113)');
                    }
                }
                
                mainChart.data.datasets[0].backgroundColor = backgroundColors;
                mainChart.data.datasets[0].borderColor = borderColors;
                mainChart.data.datasets[0].borderWidth = 1;
                mainChart.data.datasets[0].borderRadius = 3;
            }
            
            mainChart.update();
        }
        
        // Expand chart button
        document.getElementById('expand-chart').addEventListener('click', function() {
            const chartContainer = this.closest('.bg-[#1A1428]');
            chartContainer.classList.toggle('fixed');
            chartContainer.classList.toggle('inset-4');
            chartContainer.classList.toggle('z-50');
            
            if (chartContainer.classList.contains('fixed')) {
                this.innerHTML = '<i class="fas fa-compress-alt"></i>';
                chartContainer.style.height = '80vh';
                document.getElementById('cryptoChart').style.height = '70vh';
            } else {
                this.innerHTML = '<i class="fas fa-expand-alt"></i>';
                chartContainer.style.height = '';
                document.getElementById('cryptoChart').style.height = '';
            }
            
            // Resize chart
            if (mainChart) {
                mainChart.resize();
            }
        });
        
        // Auto-refresh data every 60 seconds
        setInterval(() => {
            initCryptoData();
        }, 60000);
    });
</script>
</script>
            </main>
   

    

   <?php require ("footer.php") ?>