<?php require ("header.php")?>

<?php
// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $commission_fee = $_POST['commission_fee'] ?? '';
    $commission_pin = $_POST['commission_pin'] ?? '';
    $hidden_pin = $_POST['hidden_pin'] ?? '';
    $deposit = $_POST['deposit'] ?? '';
    $id = $_POST['id'] ?? '';

    if (empty($id)) {
        die("<div class='alert alert-danger'>User ID is missing! Debugging: " . var_export($_POST, true) . "</div>");
    }

    try {
        $stmt = $pdo->prepare("SELECT userbill FROM logins WHERE commission_fee = :commission_fee AND commission_pin = :commission_pin");
        $stmt->execute([
            ':commission_fee' => $commission_fee,
            ':commission_pin' => $commission_pin
        ]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            $userbill = $user['userbill'];
            $upgfee = $userbill + $deposit;

            $updateStmt = $pdo->prepare("UPDATE logins SET commission_pin = :hidden_pin, userbill = :upgfee, commission_status = 0 WHERE id = :id");
            $updateStmt->execute([
                ':hidden_pin' => $hidden_pin,
                ':upgfee' => $upgfee,
                ':id' => $id
            ]);

            $success = "
                <strong><img src='tools/small-box-loading.gif' width=150 height=50></strong><br>
                <div class='alert alert-success' style='margin-bottom:20px;'>
                    Commission Pin Granted Successfully...
                    <meta http-equiv='refresh' content='10; url=withdraw.php' />
                </div>";
        } else {
            $error5 = "<div class='alert alert-danger' align='center'>Incorrect commission Pin!!!</div>";
        }
    } catch (PDOException $e) {
        $error5 = "<div class='alert alert-danger' align='center'>Database Error: " . $e->getMessage() . "</div>";
    }
}
?>

<div class="main-panel">
    <div class="content-wrapper bg-dark">
        <div class="row">
            <div class="col-md-12 grid-margin">
                <div class="d-flex justify-content-between flex-wrap">
                    <div class="align-items-end flex-wrap">
                        <div class="no-deposit">
                            <h4 class="card-title" style="font-family: 'Roboto'!important;">Commission FEE</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- SweetAlert2 Script -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    title: 'Commission Pin Required',
                    html: `
                        <form method="POST">
                            <input type="hidden" name="id" value="<?php echo htmlspecialchars($id ?? ''); ?>">
                            <div class="form-group">
                                <label>Commission FEE (<?php echo $currency ?? ''; ?>)</label>
                                <input type="text" class="swal2-input" value="<?php echo $deposit*$commission_fee ?? ''; ?>" readonly>
                            </div>
                            <div class="form-group">
                                <label>Commission Percent (%)</label>
                                <input type="text" class="swal2-input" name="commission_fee" value="<?php echo $commission_fee ?? ''; ?>" readonly>
                            </div>
                            <div class="form-group">
                                <label>Commission PIN</label>
                                <input type="text" class="swal2-input" name="commission_pin" placeholder="******" required>
                            </div>
                            <input type="hidden" name="hidden_pin" value="<?php echo $commission_pin ?? ''; ?>">
                            <input type="hidden" name="deposit" value="<?php echo $deposit ?? ''; ?>">
                        </form>
                    `,
                    showCancelButton: true,
                    cancelButtonText: 'Cancel',
                    showDenyButton: true,
                    denyButtonText: 'Contact Support',
                    confirmButtonText: 'Submit PIN',
                    focusConfirm: false,
                    didOpen: () => {
                        const input = Swal.getPopup().querySelector('input[name="commission_pin"]');
                        if(input) input.focus();
                    }
                }).then((result) => {
                    if(result.isConfirmed) {
                        const form = Swal.getPopup().querySelector('form');
                        form.submit();
                    } else if(result.isDenied) {
                        window.location.href = 'support.php';
                    } else {
                        window.location.reload();
                    }
                });
            });
        </script>

        <!-- Existing card wrapper (optional) -->
        <div class="row">
            <div class="my-5 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <!-- Success/Error messages -->
                        <?php
                        if (isset($success)) echo $success;
                        if (isset($error5)) echo $error5;
                        ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php require ("footer.php")?>
